/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class TBSCertificateStructure
implements DEREncodable,
X509ObjectIdentifiers,
PKCSObjectIdentifiers {
    DERConstructedSequence seq;
    DERInteger version;
    DERInteger serialNumber;
    AlgorithmIdentifier signature;
    X509Name issuer;
    DERUTCTime startDate;
    DERUTCTime endDate;
    X509Name subject;
    SubjectPublicKeyInfo subjectPublicKeyInfo;
    DERBitString issuerUniqueId;
    DERBitString subjectUniqueId;
    X509Extensions extensions;

    public TBSCertificateStructure(DERConstructedSequence dERConstructedSequence) {
        int n = 0;
        this.seq = dERConstructedSequence;
        if (dERConstructedSequence.getObjectAt(0) instanceof DERTaggedObject) {
            this.version = (DERInteger)((DERTaggedObject)dERConstructedSequence.getObjectAt(0)).getObject();
        } else {
            n = -1;
            this.version = new DERInteger(0);
        }
        this.serialNumber = (DERInteger)dERConstructedSequence.getObjectAt(n + 1);
        this.signature = dERConstructedSequence.getObjectAt(n + 2) instanceof AlgorithmIdentifier ? (AlgorithmIdentifier)dERConstructedSequence.getObjectAt(n + 2) : new AlgorithmIdentifier((DERConstructedSequence)dERConstructedSequence.getObjectAt(n + 2));
        this.issuer = dERConstructedSequence.getObjectAt(n + 3) instanceof X509Name ? (X509Name)dERConstructedSequence.getObjectAt(n + 3) : new X509Name((DERConstructedSequence)dERConstructedSequence.getObjectAt(n + 3));
        DERConstructedSequence dERConstructedSequence2 = (DERConstructedSequence)dERConstructedSequence.getObjectAt(n + 4);
        this.startDate = (DERUTCTime)dERConstructedSequence2.getObjectAt(0);
        this.endDate = (DERUTCTime)dERConstructedSequence2.getObjectAt(1);
        this.subject = dERConstructedSequence.getObjectAt(n + 5) instanceof X509Name ? (X509Name)dERConstructedSequence.getObjectAt(n + 5) : new X509Name((DERConstructedSequence)dERConstructedSequence.getObjectAt(n + 5));
        this.subjectPublicKeyInfo = dERConstructedSequence.getObjectAt(n + 6) instanceof SubjectPublicKeyInfo ? (SubjectPublicKeyInfo)dERConstructedSequence.getObjectAt(n + 6) : new SubjectPublicKeyInfo((DERConstructedSequence)dERConstructedSequence.getObjectAt(n + 6));
        int n2 = dERConstructedSequence.getSize() - (n + 6) - 1;
        while (n2 > 0) {
            DERTaggedObject dERTaggedObject = (DERTaggedObject)dERConstructedSequence.getObjectAt(n + 6 + n2);
            switch (dERTaggedObject.getTagNo()) {
                case 1: {
                    this.issuerUniqueId = (DERBitString)dERTaggedObject.getObject();
                    break;
                }
                case 2: {
                    this.subjectUniqueId = (DERBitString)dERTaggedObject.getObject();
                    break;
                }
                case 3: {
                    this.extensions = new X509Extensions((DERConstructedSequence)dERTaggedObject.getObject());
                }
            }
            --n2;
        }
    }

    public int getVersion() {
        return this.version.getValue().intValue() + 1;
    }

    public DERInteger getVersionNumber() {
        return this.version;
    }

    public DERInteger getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X509Name getIssuer() {
        return this.issuer;
    }

    public DERUTCTime getStartDate() {
        return this.startDate;
    }

    public DERUTCTime getEndDate() {
        return this.endDate;
    }

    public X509Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public DERBitString getIssuerUniqueId() {
        return this.issuerUniqueId;
    }

    public DERBitString getSubjectUniqueId() {
        return this.subjectUniqueId;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    public DERObject getDERObject() {
        return this.seq;
    }
}

