/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SubjectPublicKeyInfo
implements DEREncodable {
    private AlgorithmIdentifier algId;
    private DERObject pubKey;

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, DERObject dERObject) {
        this.pubKey = dERObject;
        this.algId = algorithmIdentifier;
    }

    public SubjectPublicKeyInfo(DERConstructedSequence dERConstructedSequence) {
        Enumeration enumeration = dERConstructedSequence.getObjects();
        this.algId = new AlgorithmIdentifier((DERConstructedSequence)enumeration.nextElement());
        byte[] byArray = ((DERBitString)enumeration.nextElement()).getBytes();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
            this.pubKey = dERInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error recovering public key");
        }
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.algId;
    }

    public DERObject getPublicKey() {
        return this.pubKey;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.algId);
        dERConstructedSequence.addObject(new DERBitString(this.pubKey));
        return dERConstructedSequence;
    }
}

