/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;

public class SafeBag
implements DEREncodable {
    DERConstructedSequence seq;
    DERObjectIdentifier bagId;
    DERObject bagValue;
    DERSet bagAttributes;

    public SafeBag(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this.bagId = dERObjectIdentifier;
        this.bagValue = dERObject;
        this.bagAttributes = null;
    }

    public SafeBag(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject, DERSet dERSet) {
        this.bagId = dERObjectIdentifier;
        this.bagValue = dERObject;
        this.bagAttributes = dERSet;
    }

    public SafeBag(DERConstructedSequence dERConstructedSequence) {
        this.seq = dERConstructedSequence;
        this.bagId = (DERObjectIdentifier)dERConstructedSequence.getObjectAt(0);
        this.bagValue = ((DERTaggedObject)dERConstructedSequence.getObjectAt(1)).getObject();
        if (dERConstructedSequence.getSize() == 3) {
            this.bagAttributes = (DERSet)dERConstructedSequence.getObjectAt(2);
        }
    }

    public DERObjectIdentifier getBagId() {
        return this.bagId;
    }

    public DERObject getBagValue() {
        return this.bagValue;
    }

    public DERSet getBagAttributes() {
        return this.bagAttributes;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.bagId);
        dERConstructedSequence.addObject(new DERTaggedObject(0, this.bagValue));
        if (this.bagAttributes != null) {
            dERConstructedSequence.addObject(this.bagAttributes);
        }
        return dERConstructedSequence;
    }
}

