/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.DigestInfo;

public class MacData
implements DEREncodable {
    DERConstructedSequence seq;
    DigestInfo digInfo;
    byte[] salt;
    BigInteger iterationCount;

    public MacData(DERConstructedSequence dERConstructedSequence) {
        this.seq = dERConstructedSequence;
        this.digInfo = new DigestInfo((DERConstructedSequence)dERConstructedSequence.getObjectAt(0));
        this.salt = ((DEROctetString)dERConstructedSequence.getObjectAt(1)).getOctets();
        this.iterationCount = dERConstructedSequence.getSize() == 3 ? ((DERInteger)dERConstructedSequence.getObjectAt(2)).getValue() : BigInteger.valueOf(1L);
    }

    public MacData(DigestInfo digestInfo, byte[] byArray, int n) {
        this.digInfo = digestInfo;
        this.salt = byArray;
        this.iterationCount = BigInteger.valueOf(n);
    }

    public DigestInfo getMac() {
        return this.digInfo;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public BigInteger getIterationCount() {
        return this.iterationCount;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.digInfo);
        dERConstructedSequence.addObject(new DEROctetString(this.salt));
        dERConstructedSequence.addObject(new DERInteger(this.iterationCount));
        return dERConstructedSequence;
    }
}

