/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.util.Enumeration;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class ContentInfo
implements DEREncodable,
PKCSObjectIdentifiers {
    private DERObjectIdentifier contentType;
    private DERObject content;

    public ContentInfo(DERConstructedSequence dERConstructedSequence) {
        Enumeration enumeration = dERConstructedSequence.getObjects();
        this.contentType = (DERObjectIdentifier)enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            this.content = ((DERTaggedObject)enumeration.nextElement()).getObject();
        }
    }

    public ContentInfo(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this.contentType = dERObjectIdentifier;
        this.content = dERObject;
    }

    public DERObjectIdentifier getContentType() {
        return this.contentType;
    }

    public DERObject getContent() {
        return this.content;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.contentType);
        if (this.content != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(0, this.content));
        }
        return bERConstructedSequence;
    }
}

