/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERTaggedObject
extends DERObject {
    int tagNo;
    boolean empty = false;
    boolean explicit = true;
    DEREncodable obj = null;

    public DERTaggedObject(int n) {
        this.explicit = true;
        this.tagNo = n;
        this.empty = true;
    }

    public DERTaggedObject(int n, DEREncodable dEREncodable) {
        this.explicit = true;
        this.tagNo = n;
        this.obj = dEREncodable;
    }

    public DERTaggedObject(boolean bl, int n, DEREncodable dEREncodable) {
        this.explicit = bl;
        this.tagNo = n;
        this.obj = dEREncodable;
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public DERObject getObject() {
        return this.obj.getDERObject();
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        if (!this.empty) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream2 = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream2.writeObject(this.obj);
            dEROutputStream2.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (this.explicit) {
                dEROutputStream.writeEncoded(0xA0 | this.tagNo, byteArrayOutputStream.toByteArray());
            } else {
                byArray[0] = (byArray[0] & 0x20) != 0 ? (byte)(0xA0 | this.tagNo) : (byte)(0x80 | this.tagNo);
                dEROutputStream.write(byArray);
            }
        } else {
            dEROutputStream.writeEncoded(0xA0 | this.tagNo, new byte[0]);
        }
    }
}

