/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DEROctetString
extends DERObject {
    byte[] string;

    public DEROctetString(byte[] byArray) {
        this.string = byArray;
    }

    public DEROctetString(DERObject dERObject) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(dERObject);
            dEROutputStream.close();
            this.string = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error processing object : " + iOException.toString());
        }
    }

    public DEROctetString(DEREncodable dEREncodable) {
        this(dEREncodable.getDERObject());
    }

    public byte[] getOctets() {
        return this.string;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(4, this.string);
    }

    public int hashCode() {
        byte[] byArray = this.getOctets();
        int n = 0;
        int n2 = 0;
        while (n2 != byArray.length) {
            n ^= (byArray[n2] & 0xFF) << n2 % 4;
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DEROctetString)) {
            return false;
        }
        DEROctetString dEROctetString = (DEROctetString)object;
        if (dEROctetString.getOctets().length != this.getOctets().length) {
            return false;
        }
        byte[] byArray = dEROctetString.getOctets();
        byte[] byArray2 = this.getOctets();
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

