/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.OIDTokenizer;

public class DERObjectIdentifier
extends DERObject {
    String identifier;

    public DERObjectIdentifier(String string) {
        this.identifier = string;
    }

    public String getId() {
        return this.identifier;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.identifier);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream2 = new DEROutputStream(byteArrayOutputStream);
        byte[] byArray = new byte[5];
        dEROutputStream2.write(Integer.parseInt(oIDTokenizer.nextToken()) * 40 + Integer.parseInt(oIDTokenizer.nextToken()));
        while (oIDTokenizer.hasMoreTokens()) {
            int n = Integer.parseInt(oIDTokenizer.nextToken());
            int n2 = byArray.length - 1;
            byArray[n2--] = (byte)(n % 128);
            n /= 128;
            while (n != 0) {
                byArray[n2--] = (byte)(n % 128 | 0x80);
                n /= 128;
            }
            dEROutputStream2.write(byArray, n2 + 1, byArray.length - (n2 + 1));
        }
        dEROutputStream2.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        dEROutputStream.writeEncoded(6, byArray2);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)object).identifier);
    }
}

