/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERInteger
extends DERObject {
    byte[] bytes;

    public DERInteger(int n) {
        int n2 = n;
        int n3 = 1;
        while ((n2 >>>= 8) != 0) {
            ++n3;
        }
        this.bytes = new byte[n3];
        int n4 = n3 - 1;
        while (n4 >= 0) {
            this.bytes[n4] = (byte)(n >> n4);
            --n4;
        }
    }

    public DERInteger(BigInteger bigInteger) {
        this.bytes = bigInteger.toByteArray();
    }

    public DERInteger(byte[] byArray) {
        this.bytes = byArray;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(2, this.bytes);
    }
}

