/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERBitString
extends DERObject {
    protected byte[] data;
    protected int padBits;

    protected DERBitString(byte by, int n) {
        this.data = new byte[1];
        this.data[0] = by;
        this.padBits = n;
    }

    public DERBitString(byte[] byArray, int n) {
        this.data = byArray;
        this.padBits = n;
    }

    public DERBitString(byte[] byArray) {
        this(byArray, 0);
    }

    public DERBitString(DERObject dERObject) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(dERObject);
            dEROutputStream.close();
            this.data = byteArrayOutputStream.toByteArray();
            this.padBits = 0;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error processing object : " + iOException.toString());
        }
    }

    public DERBitString(DEREncodable dEREncodable) {
        this(dEREncodable.getDERObject());
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int getPadBits() {
        return this.padBits;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        byte[] byArray = new byte[this.getBytes().length + 1];
        byArray[0] = (byte)this.getPadBits();
        System.arraycopy(this.getBytes(), 0, byArray, 1, byArray.length - 1);
        dEROutputStream.writeEncoded(3, byArray);
    }
}

