/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERTaggedObject;

public class BERTaggedObject
extends DERTaggedObject {
    public BERTaggedObject(int n) {
        super(n);
    }

    public BERTaggedObject(int n, DERObject dERObject) {
        super(n, dERObject);
    }

    public BERTaggedObject(boolean bl, int n, DERObject dERObject) {
        super(bl, n, dERObject);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        if (dEROutputStream instanceof BEROutputStream) {
            dEROutputStream.write(0xA0 | this.tagNo);
            dEROutputStream.write(128);
            if (!this.empty) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BEROutputStream bEROutputStream = new BEROutputStream((OutputStream)byteArrayOutputStream);
                if (!this.explicit) {
                    if (this.obj instanceof BERConstructedOctetString) {
                        Vector vector = ((BERConstructedOctetString)this.obj).getDEROctets();
                        int n = 0;
                        while (n != vector.size()) {
                            bEROutputStream.writeObject(vector.elementAt(n));
                            ++n;
                        }
                    } else {
                        bEROutputStream.writeObject((Object)this.obj);
                    }
                } else {
                    bEROutputStream.writeObject((Object)this.obj);
                }
                bEROutputStream.close();
                dEROutputStream.write(byteArrayOutputStream.toByteArray());
            }
            dEROutputStream.write(0);
            dEROutputStream.write(0);
        } else {
            super.encode(dEROutputStream);
        }
    }
}

