/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.BCClass;
import com.techtrader.modules.tools.bytecode.BCField;
import com.techtrader.modules.tools.bytecode.BCHelper;
import com.techtrader.modules.tools.bytecode.BCMethod;
import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;

public abstract class FieldInstruction
extends Instruction {
    private int _index = 0;
    private static /* synthetic */ Class class$Lcom$techtrader$modules$tools$bytecode$lowlevel$FieldEntry;

    public int getFieldIndex() {
        return this._index;
    }

    public void setFieldIndex(int n) {
        this._index = n;
    }

    public FieldInstruction setField(BCField bCField) {
        BCClass bCClass = bCField.getOwner();
        return this.setField(bCField.getName(), bCField.getTypeName(), bCClass.getName());
    }

    public FieldInstruction setField(Field field) {
        return this.setField(field.getName(), field.getType().getName(), field.getDeclaringClass().getName());
    }

    public FieldInstruction setField(String string, String string2, String string3) {
        String string4 = BCHelper.getInternalForm(string2, true);
        String string5 = BCHelper.getInternalForm(string3, false);
        this._index = this._owner.getPool().setComplex(0, string, string4, string5, class$Lcom$techtrader$modules$tools$bytecode$lowlevel$FieldEntry != null ? class$Lcom$techtrader$modules$tools$bytecode$lowlevel$FieldEntry : (class$Lcom$techtrader$modules$tools$bytecode$lowlevel$FieldEntry = FieldInstruction.class$("com.techtrader.modules.tools.bytecode.lowlevel.FieldEntry")));
        return this;
    }

    public FieldInstruction setField(String string, Class clazz, String string2) {
        String string3 = clazz == null ? null : clazz.getName();
        return this.setField(string, string3, string2);
    }

    public FieldInstruction setField(String string, Class clazz, Class clazz2) {
        String string2 = clazz == null ? null : clazz.getName();
        String string3 = clazz2 == null ? null : clazz2.getName();
        return this.setField(string, string2, string3);
    }

    public FieldInstruction setFieldName(String string) {
        return this.setField(string, this.getFieldTypeName(), this.getFieldOwnerTypeName());
    }

    public boolean isFieldInCurrentClass() {
        BCClass bCClass = ((BCMethod)this._owner.getOwner()).getOwner();
        return bCClass.getName().equals(this.getFieldOwnerTypeName());
    }

    public BCField getField() {
        if (!this.isFieldInCurrentClass()) {
            return null;
        }
        return ((BCMethod)this._owner.getOwner()).getOwner().getField(this.getFieldName());
    }

    public String getFieldName() {
        return this._owner.getPool().getComplexName(this._index);
    }

    public String getFieldTypeName() {
        return BCHelper.getExternalForm(this._owner.getPool().getComplexTypeName(this._index), true);
    }

    public Class getFieldType() throws ClassNotFoundException {
        return BCHelper.classForName(this._owner.getPool().getComplexTypeName(this._index));
    }

    public String getFieldOwnerTypeName() {
        return BCHelper.getExternalForm(this._owner.getPool().getComplexOwnerTypeName(this._index), true);
    }

    public Class getFieldOwnerType() throws ClassNotFoundException {
        return BCHelper.classForName(this._owner.getPool().getComplexOwnerTypeName(this._index));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FieldInstruction)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        FieldInstruction fieldInstruction = (FieldInstruction)object;
        String string = this.getFieldName();
        String string2 = fieldInstruction.getFieldName();
        if (string.length() != 0 && string2.length() != 0 && !string.equals(string2)) {
            return false;
        }
        string = this.getFieldTypeName();
        string2 = fieldInstruction.getFieldTypeName();
        if (string.length() != 0 && string2.length() != 0 && !string.equals(string2)) {
            return false;
        }
        string = this.getFieldOwnerTypeName();
        string2 = fieldInstruction.getFieldOwnerTypeName();
        return string.length() == 0 || string2.length() == 0 || string.equals(string2);
    }

    public int getLength() {
        return super.getLength() + 2;
    }

    protected void copy(Instruction instruction) {
        super.copy(instruction);
        FieldInstruction fieldInstruction = (FieldInstruction)instruction;
        this.setField(fieldInstruction.getFieldName(), fieldInstruction.getFieldTypeName(), fieldInstruction.getFieldOwnerTypeName());
    }

    protected void readData(DataInput dataInput) throws IOException {
        this._index = dataInput.readUnsignedShort();
    }

    protected void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this._index);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected FieldInstruction(Code code, int n) {
        super(code);
        this._opcode = n;
    }
}

