/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.util.HashMap;
import java.util.Map;

public class ConvertInstruction
extends Instruction {
    private static final Map _typeNames = new HashMap();
    private Class _fromType = null;
    private Class _toType = null;

    public Class getFromType() {
        return this._fromType;
    }

    public String getFromTypeName() {
        if (this._fromType == null) {
            return null;
        }
        return this._fromType.getName();
    }

    public ConvertInstruction setFromType(Class clazz) {
        this._fromType = Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz) || Long.TYPE.equals(clazz) ? clazz : Integer.TYPE;
        this.calculateOpCode();
        return this;
    }

    public ConvertInstruction setFromTypeName(String string) {
        this._fromType = (Class)_typeNames.get(string);
        if (this._fromType == null && string != null) {
            this._fromType = Integer.TYPE;
        }
        this.calculateOpCode();
        return this;
    }

    public Class getToType() {
        return this._toType;
    }

    public String getToTypeName() {
        if (this._toType == null) {
            return null;
        }
        return this._toType.getName();
    }

    public ConvertInstruction setToType(Class clazz) {
        this._toType = Instruction._opcodeTypes.indexOf(clazz) != -1 ? clazz : Integer.TYPE;
        this.calculateOpCode();
        return this;
    }

    public ConvertInstruction setToTypeName(String string) {
        this._toType = (Class)_typeNames.get(string);
        if (this._toType == null && string != null) {
            this._toType = string.equals("byte") ? Byte.TYPE : (string.equals("char") ? Character.TYPE : (string.equals("short") ? Short.TYPE : Integer.TYPE));
        }
        this.calculateOpCode();
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConvertInstruction)) {
            return false;
        }
        ConvertInstruction convertInstruction = (ConvertInstruction)object;
        boolean bl = this._fromType == null || convertInstruction._fromType == null || this._fromType.equals(convertInstruction._fromType);
        boolean bl2 = this._toType == null || convertInstruction._toType == null || this._toType.equals(convertInstruction._toType);
        return bl && bl2;
    }

    public int getStackChange() {
        switch (this._opcode) {
            case 133: 
            case 135: 
            case 140: 
            case 141: {
                return 1;
            }
            case 136: 
            case 137: 
            case 142: 
            case 144: {
                return -1;
            }
        }
        return 0;
    }

    protected void copy(Instruction instruction) {
        super.copy(instruction);
        ConvertInstruction convertInstruction = (ConvertInstruction)instruction;
        this._fromType = convertInstruction._fromType;
        this._toType = convertInstruction._toType;
    }

    private void calculateOpCode() {
        int n = Instruction._opcodeTypes.indexOf(this._fromType);
        int n2 = Instruction._opcodeTypes.indexOf(this._toType);
        this._opcode = 133 + 3 * n;
        if (n != 0 && n2 > 4) {
            n2 = 0;
        } else if (n2 > 4) {
            this._opcode += 8;
        }
        if (n == n2) {
            this._opcode = 0;
            return;
        }
        this._opcode += n2;
        if (n2 > n) {
            --this._opcode;
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterConvertInstruction(this);
        bCVisitor.exitConvertInstruction(this);
    }

    protected ConvertInstruction(Code code) {
        super(code);
    }

    protected ConvertInstruction(Code code, int n, Class clazz, Class clazz2) {
        super(code);
        this._opcode = n;
        this._fromType = clazz;
        this._toType = clazz2;
    }

    static {
        _typeNames.put("long", Long.TYPE);
        _typeNames.put("float", Float.TYPE);
        _typeNames.put("double", Double.TYPE);
    }
}

