/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.mortbay.util.Code;
import org.mortbay.util.DateCache;
import org.mortbay.util.Frame;
import org.mortbay.util.Log;
import org.mortbay.util.LogSink;
import org.mortbay.util.StringUtil;

public class WriterLogSink
implements LogSink {
    public static final char OPT_TIMESTAMP = 't';
    public static final char OPT_LABEL = 'L';
    public static final char OPT_TAG = 'T';
    public static final char OPT_STACKSIZE = 's';
    public static final char OPT_STACKTRACE = 'S';
    public static final char OPT_ONELINE = 'O';
    private static final String __lineSeparator = System.getProperty("line.separator");
    private static final String __indentBase = "";
    private static final String __indentSeparator = __lineSeparator + "";
    private static final int __lineSeparatorLen = __lineSeparator.length();
    private static final String YYYY_MM_DD = "yyyy_mm_dd";
    private static SimpleDateFormat __fileBackupFormat = new SimpleDateFormat(System.getProperty("LOG_FILE_BACKUP_FORMAT", "HHmmssSSS"));
    private SimpleDateFormat _fileDateFormat;
    private int _retainDays;
    protected DateCache _dateFormat;
    protected String _logTimezone;
    protected boolean _logTimeStamps;
    protected boolean _logLabels;
    protected boolean _logTags;
    protected boolean _logStackSize;
    protected boolean _logStackTrace;
    protected boolean _logOneLine;
    protected PrintWriter _out;
    protected boolean _started;
    private String _filename;
    private boolean _append;
    private StringBuffer _stringBuffer;
    private Thread _rollover;
    protected boolean _flushOn;

    public void setOptions(String logOptions) {
        this.setOptions(logOptions.indexOf(116) >= 0, logOptions.indexOf(76) >= 0, logOptions.indexOf(84) >= 0, logOptions.indexOf(115) >= 0, logOptions.indexOf(83) >= 0, logOptions.indexOf(79) >= 0);
    }

    public String getOptions() {
        return (this._logTimeStamps ? "t" : __indentBase) + (this._logLabels ? "L" : __indentBase) + (this._logTags ? "T" : __indentBase) + (this._logStackSize ? "s" : __indentBase) + (this._logStackTrace ? "S" : __indentBase) + (this._logOneLine ? "O" : __indentBase);
    }

    public void setOptions(boolean logTimeStamps, boolean logLabels, boolean logTags, boolean logStackSize, boolean logStackTrace, boolean logOneLine) {
        this._logTimeStamps = logTimeStamps;
        this._logLabels = logLabels;
        this._logTags = logTags;
        this._logStackSize = logStackSize;
        this._logStackTrace = logStackTrace;
        this._logOneLine = logOneLine;
    }

    public String getLogDateFormat() {
        return this._dateFormat.getFormatString();
    }

    public void setLogDateFormat(String logDateFormat) {
        logDateFormat = logDateFormat.replace('+', ' ');
        this._dateFormat = new DateCache(logDateFormat);
        if (this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public String getLogTimezone() {
        return this._logTimezone;
    }

    public void setLogTimezone(String logTimezone) {
        this._logTimezone = logTimezone;
        if (this._dateFormat != null && this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public boolean isLogTimeStamps() {
        return this._logTimeStamps;
    }

    public void setLogTimeStamps(boolean logTimeStamps) {
        this._logTimeStamps = logTimeStamps;
    }

    public boolean isLogLabels() {
        return this._logLabels;
    }

    public void setLogLabels(boolean logLabels) {
        this._logLabels = logLabels;
    }

    public boolean isLogTags() {
        return this._logTags;
    }

    public void setLogTags(boolean logTags) {
        this._logTags = logTags;
    }

    public boolean isLogStackSize() {
        return this._logStackSize;
    }

    public void setLogStackSize(boolean logStackSize) {
        this._logStackSize = logStackSize;
    }

    public boolean isLogStackTrace() {
        return this._logStackTrace;
    }

    public void setLogStackTrace(boolean logStackTrace) {
        this._logStackTrace = logStackTrace;
    }

    public boolean isLogOneLine() {
        return this._logOneLine;
    }

    public void setLogOneLine(boolean logOneLine) {
        this._logOneLine = logOneLine;
    }

    public boolean isAppend() {
        return this._append;
    }

    public void setAppend(boolean a) {
        this._append = a;
    }

    public void setWriter(PrintWriter out) {
        StringBuffer stringBuffer = this._stringBuffer;
        synchronized (stringBuffer) {
            this.setFilename(null);
            this._out = out;
        }
    }

    public PrintWriter getWriter() {
        return this._out;
    }

    public void setFilename(String filename) {
        StringBuffer stringBuffer = this._stringBuffer;
        synchronized (stringBuffer) {
            block15: {
                try {
                    if (filename != null && (filename = filename.trim()).length() == 0) {
                        filename = null;
                    }
                    if (filename == null || !filename.equals(this._filename)) {
                        if (this._out != null && this._filename != null) {
                            try {
                                this._out.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            this._out = null;
                        }
                        this._filename = null;
                        if (this._rollover != null) {
                            this._rollover.interrupt();
                        }
                        this._rollover = null;
                    }
                    if (filename == null || filename.equals(this._filename)) break block15;
                    try {
                        this._filename = filename;
                        if (this.isStarted()) {
                            this.openFile(filename);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this._out = null;
                        this._filename = null;
                        this.setWriter(new PrintWriter(System.err));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this._filename == null && this._out == null) {
            this._out = new PrintWriter(System.err);
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    public void setRetainDays(int retainDays) {
        this._retainDays = retainDays;
    }

    private void openFile(String filename) throws IOException {
        StringBuffer stringBuffer = this._stringBuffer;
        synchronized (stringBuffer) {
            try {
                File file = new File(filename);
                filename = file.getCanonicalPath();
                file = new File(filename);
                File dir = new File(file.getParent());
                if (!dir.exists() && dir.canWrite()) {
                    throw new IOException("Cannot write log directory " + dir);
                }
                Date now = new Date();
                int i = file.getName().toLowerCase().indexOf(YYYY_MM_DD);
                if (i >= 0) {
                    file = new File(dir, file.getName().substring(0, i) + this._fileDateFormat.format(now) + file.getName().substring(i + YYYY_MM_DD.length()));
                    if (this._rollover == null) {
                        this._rollover = new Rollover();
                    }
                }
                if (file.exists() && !file.canWrite()) {
                    throw new IOException("Cannot write log file " + file);
                }
                if (!this._append && file.exists()) {
                    file.renameTo(new File(file.toString() + "." + __fileBackupFormat.format(now)));
                }
                this._out = new PrintWriter(new FileWriter(file.toString(), this._append));
                if (this._rollover != null && !this._rollover.isAlive()) {
                    this._rollover.start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this._out = new PrintWriter(System.err);
                throw e;
            }
        }
    }

    public void setFlushOn(boolean on) {
        this._flushOn = on;
        if (on && this._out != null) {
            this._out.flush();
        }
        if (!on) {
            Code.warning("Using WriterLogSink. It is less efficient than OutputStreamLogSink");
        }
    }

    public boolean getFlushOn() {
        return this._flushOn;
    }

    public void log(String tag, Object msg, Frame frame, long time) {
        StringBuffer stringBuffer = this._stringBuffer;
        synchronized (stringBuffer) {
            String smsg;
            this._stringBuffer.setLength(0);
            if (this._logTimeStamps) {
                this._stringBuffer.append(this._dateFormat.format(time));
            }
            if (this._logTags) {
                this._stringBuffer.append(tag);
            }
            if (this._logLabels && frame != null) {
                this._stringBuffer.append(frame.toString());
            }
            if (this._logStackSize && frame != null) {
                this._stringBuffer.append((frame._depth > 9 ? __indentBase : "0") + frame._depth + "> ");
            }
            String nl = __lineSeparator + (this._logOneLine ? __indentBase : "+ ");
            if (this._logLabels && !this._logOneLine && this._stringBuffer.length() > 0) {
                this._stringBuffer.append(nl);
            }
            String string = msg == null ? "???" : (smsg = msg instanceof String ? (String)msg : msg.toString());
            if (this._logOneLine) {
                smsg = StringUtil.replace(smsg, "\r\n", "<|");
                smsg = StringUtil.replace(smsg, "\r", "<");
                smsg = StringUtil.replace(smsg, "\n", "|");
            } else {
                smsg = StringUtil.replace(smsg, "\r\n", "<|");
                smsg = StringUtil.replace(smsg, "\r", "<|");
                smsg = StringUtil.replace(smsg, "\n", "<|");
                smsg = StringUtil.replace(smsg, "<|", nl);
            }
            this._stringBuffer.append(smsg);
            if (this._logStackTrace && frame != null) {
                this._stringBuffer.append(nl);
                this._stringBuffer.append(frame._stack);
            }
            this.log(this._stringBuffer.toString());
        }
    }

    public void log(String formattedLog) {
        if (this._out == null) {
            return;
        }
        StringBuffer stringBuffer = this._stringBuffer;
        synchronized (stringBuffer) {
            this._out.println(formattedLog);
            if (this._flushOn) {
                this._out.flush();
            }
        }
    }

    public void start() {
        StringBuffer stringBuffer = this._stringBuffer;
        synchronized (stringBuffer) {
            if (this._filename != null) {
                try {
                    this.openFile(this._filename);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this._started = this._out != null;
        }
    }

    public void stop() {
        this._started = false;
        if (this._out != null) {
            try {
                this._out.flush();
            }
            catch (Exception e) {
                Code.ignore(e);
            }
        }
        if (this._filename != null) {
            this._out.close();
        }
        if (this._rollover != null) {
            this._rollover.interrupt();
        }
        this._rollover = null;
    }

    public boolean isStarted() {
        return this._started;
    }

    public void destroy() {
        if (this._filename != null) {
            this._out.close();
        }
        this._out = null;
    }

    public boolean isDestroyed() {
        return !this._started && this._out == null;
    }

    static /* synthetic */ String access$2() {
        return YYYY_MM_DD;
    }

    private final void block$() {
        this._fileDateFormat = new SimpleDateFormat(System.getProperty("LOG_FILE_DATE_FORMAT", "yyyy_MM_dd"));
        this._retainDays = Integer.getInteger("LOG_FILE_RETAIN_DAYS", 31);
        this._dateFormat = new DateCache(System.getProperty("LOG_DATE_FORMAT", "HH:mm:ss.SSS "));
        this._logTimezone = System.getProperty("LOG_TIME_ZONE");
        if (this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
        this._logTimeStamps = true;
        this._logLabels = true;
        this._logTags = true;
        this._logStackSize = true;
        this._logStackTrace = false;
        this._logOneLine = false;
        this._append = true;
        this._stringBuffer = new StringBuffer(512);
        this._flushOn = true;
    }

    public WriterLogSink() throws IOException {
        this.block$();
        this._filename = System.getProperty("LOG_FILE");
        if (this._filename == null) {
            this._out = new PrintWriter(System.err);
        }
    }

    public WriterLogSink(PrintWriter out) {
        this.block$();
        this._out = out;
    }

    public WriterLogSink(String filename) throws IOException {
        this.block$();
        this._filename = filename;
    }

    private class Rollover
    extends Thread {
        public void run() {
            while (true) {
                try {
                    if (WriterLogSink.this._retainDays > 0) {
                        Calendar retainDate = Calendar.getInstance();
                        retainDate.add(5, -WriterLogSink.this._retainDays);
                        int borderYear = retainDate.get(1);
                        int borderMonth = retainDate.get(2) + 1;
                        int borderDay = retainDate.get(5);
                        File file = new File(WriterLogSink.this._filename);
                        File dir = new File(file.getParent());
                        String fn = file.getName();
                        int s = fn.toLowerCase().indexOf(WriterLogSink.YYYY_MM_DD);
                        String prefix = fn.substring(0, s);
                        String suffix = fn.substring(s + WriterLogSink.YYYY_MM_DD.length());
                        String[] logList = dir.list();
                        int i = 0;
                        while (i < logList.length) {
                            block11: {
                                fn = logList[i];
                                if (fn.startsWith(prefix) && fn.indexOf(suffix, prefix.length()) >= 0) {
                                    try {
                                        StringTokenizer st = new StringTokenizer(fn.substring(prefix.length()), "_.");
                                        int nYear = Integer.parseInt(st.nextToken());
                                        int nMonth = Integer.parseInt(st.nextToken());
                                        int nDay = Integer.parseInt(st.nextToken());
                                        if (nYear < borderYear || nYear == borderYear && nMonth < borderMonth || nYear == borderYear && nMonth == borderMonth && nDay <= borderDay) {
                                            Log.event("Log age " + fn);
                                            new File(dir, fn).delete();
                                        }
                                    }
                                    catch (Exception e) {
                                        if (!Code.debug()) break block11;
                                        e.printStackTrace();
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    Calendar now = Calendar.getInstance();
                    GregorianCalendar midnight = new GregorianCalendar(now.get(1), now.get(2), now.get(5), 23, 0);
                    midnight.add(10, 1);
                    long sleeptime = midnight.getTime().getTime() - now.getTime().getTime();
                    Code.debug("Log rollover sleep until " + midnight.getTime());
                    Thread.sleep(sleeptime);
                    WriterLogSink.this.openFile(WriterLogSink.this._filename);
                    Log.event("Rolled over " + WriterLogSink.this._filename);
                    continue;
                }
                catch (InterruptedIOException e) {
                }
                catch (InterruptedException e) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            Code.debug("Log rollover exiting");
        }

        Rollover() {
            this.setName("Rollover: " + WriterLogSink.this.hashCode());
        }
    }
}

