/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mortbay.util.Code;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.UrlEncoded;

public class URI
implements Cloneable {
    private String _uri;
    private String _scheme;
    private String _host;
    private int _port;
    private String _path;
    private String _query;
    private UrlEncoded _parameters = new UrlEncoded();
    private boolean _dirty;
    private boolean _encodeNulls = false;

    public boolean isAbsolute() {
        return this._scheme != null || this._host != null;
    }

    public String getScheme() {
        return this._scheme;
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
        this._dirty = true;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
        this._dirty = true;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
        this._dirty = true;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
        this._dirty = true;
    }

    public String getQuery() {
        if (this._dirty) {
            this._query = this._parameters.encode(this._encodeNulls);
            if (this._query != null && this._query.length() == 0) {
                this._query = null;
            }
        }
        return this._query;
    }

    public void setQuery(String query) {
        this._dirty = true;
        this._query = query;
        this._parameters.clear();
        this._parameters.decode(query);
    }

    public void setEncodeNulls(boolean b) {
        this._dirty = this._encodeNulls != b;
        this._encodeNulls = b;
    }

    public Set getParameterNames() {
        return this._parameters.keySet();
    }

    public MultiMap getParameters() {
        this._dirty = true;
        return this._parameters;
    }

    public Map getUnmodifiableParameters() {
        return Collections.unmodifiableMap(this._parameters);
    }

    public void clearParameters() {
        this._dirty = true;
        this._parameters.clear();
    }

    public void put(String encoded) {
        UrlEncoded params = new UrlEncoded(encoded);
        this.put(params);
    }

    public Object put(Object name, Object value) {
        this._dirty = true;
        return this._parameters.put(name, value);
    }

    public void put(Map values) {
        this._dirty = true;
        this._parameters.putAll(values);
    }

    public String get(String name) {
        return (String)this._parameters.get(name);
    }

    public List getValues(String name) {
        return this._parameters.getValues(name);
    }

    public void remove(String name) {
        this._dirty = true;
        this._parameters.remove(name);
    }

    public String toString() {
        if (this._dirty) {
            StringBuffer buf;
            this.getQuery();
            StringBuffer stringBuffer = buf = new StringBuffer(this._uri.length() * 2);
            synchronized (stringBuffer) {
                if (this._scheme != null) {
                    buf.append(this._scheme);
                    buf.append("://");
                    buf.append(this._host);
                    if (this._port > 0) {
                        buf.append(':');
                        buf.append(this._port);
                    }
                }
                URI.encodePath(buf, this._path);
                if (this._query != null && this._query.length() > 0) {
                    buf.append('?');
                    buf.append(this._query);
                }
                this._uri = buf.toString();
                this._dirty = false;
            }
        }
        return this._uri;
    }

    public static String encodePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        StringBuffer buf = new StringBuffer(path.length() << 1);
        URI.encodePath(buf, path);
        return buf.toString();
    }

    public static void encodePath(StringBuffer buf, String path) {
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            int i = 0;
            while (i < path.length()) {
                char c = path.charAt(i);
                switch (c) {
                    case '%': {
                        buf.append("%25");
                        break;
                    }
                    case '?': {
                        buf.append("%3F");
                        break;
                    }
                    case ';': {
                        buf.append("%3B");
                        break;
                    }
                    case '#': {
                        buf.append("%23");
                        break;
                    }
                    case ' ': {
                        buf.append("%20");
                        break;
                    }
                    default: {
                        buf.append(c);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String decodePath(String path) {
        len = path.length();
        bytes = null;
        n = 0;
        noDecode = true;
        i = 0;
        while (i < len) {
            block9: {
                c = path.charAt(i);
                if (c < '\u0000' || c > '\u00ff') {
                    throw new IllegalArgumentException("Not decoded");
                }
                b = (byte)(255 & c);
                if (c != '%' || i + 2 >= len) break block9;
                noDecode = false;
                b = (byte)(255 & Integer.parseInt(path.substring(i + 1, i + 3), 16));
                i += 2;
                ** GOTO lbl-1000
            }
            if (bytes == null) {
                ++n;
            } else lbl-1000:
            // 2 sources

            {
                if (bytes == null) {
                    noDecode = false;
                    bytes = new byte[len];
                    j = 0;
                    while (j < n) {
                        bytes[j] = (byte)(255 & path.charAt(j));
                        ++j;
                    }
                }
                bytes[n++] = b;
            }
            ++i;
        }
        if (noDecode) {
            return path;
        }
        try {
            return new String(bytes, 0, n, StringUtil.__ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            Code.warning(e);
            return new String(bytes, 0, n);
        }
    }

    public Object clone() {
        return new URI(this);
    }

    public static String addPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p2 == null || p2.length() == 0) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        Object p3 = null;
        int split = p1.indexOf(59);
        if (split < 0) {
            split = p1.indexOf(63);
        }
        if (split == 0) {
            return p2 + p1;
        }
        if (split < 0) {
            split = p1.length();
        }
        StringBuffer buf = new StringBuffer(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (buf.charAt(split - 1) == '/') {
            if (p2.startsWith("/")) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, p2);
            } else {
                buf.insert(split, p2);
            }
        } else if (p2.startsWith("/")) {
            buf.insert(split, p2);
        } else {
            buf.insert(split, '/');
            buf.insert(split + 1, p2);
        }
        return buf.toString();
    }

    public static String parentPath(String p) {
        if (p == null || "/".equals(p)) {
            return null;
        }
        int slash = p.lastIndexOf(47, p.length() - 2);
        if (slash >= 0) {
            return p.substring(0, slash + 1);
        }
        return null;
    }

    public static String stripPath(String path) {
        if (path == null) {
            return null;
        }
        int semi = path.indexOf(59);
        if (semi < 0) {
            return path;
        }
        return path.substring(0, semi);
    }

    /*
     * Unable to fully structure code
     */
    public static String oldCanonicalPath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        last = -1;
        slash = path.indexOf(47);
        if (slash < 0) {
            slash = path.length();
        }
        block10: while (last < slash) {
            switch (slash - last) {
                case 1: {
                    if (last >= 0 && slash != path.length()) break block10;
                    ** GOTO lbl17
                }
                case 2: {
                    if (path.charAt(last + 1) == '.') break block10;
                    ** GOTO lbl17
                }
                case 3: {
                    if (path.charAt(last + 1) == '.' && path.charAt(last + 2) == '.') break block10;
                }
lbl17:
                // 4 sources

                default: {
                    last = slash;
                    slash = path.indexOf(47, last + 1);
                    if (slash >= 0) continue block10;
                    slash = path.length();
                }
            }
        }
        if (last >= slash) {
            return path;
        }
        buf = new StringBuffer(path);
        while (last < slash) {
            switch (slash - last) {
                case 1: {
                    if (last < 0 || slash == buf.length()) break;
                    buf.deleteCharAt(last);
                    slash = last;
                    break;
                }
                case 2: {
                    if (buf.charAt(last + 1) == '.') ** GOTO lbl38
                    break;
lbl-1000:
                    // 1 sources

                    {
                        ++slash;
lbl38:
                        // 2 sources

                        ** while (slash < buf.length() && buf.charAt((int)slash) == '/')
                    }
lbl39:
                    // 1 sources

                    if (last < 0) {
                        buf.delete(0, slash);
                    } else {
                        buf.delete(last + 1, slash);
                    }
                    slash = last;
                    break;
                }
                case 3: {
                    if (buf.charAt(last + 1) != '.' || buf.charAt(last + 2) != '.') break;
                    if (last <= 0) {
                        return null;
                    }
                    i = last - 1;
                    while (i > 0 && buf.charAt(i) != '/') {
                        --i;
                    }
                    buf.delete(buf.charAt(i) == '/' ? i + 1 : i, slash == buf.length() || buf.charAt(i) == '/' ? slash : slash + 1);
                    if (i < 0 || buf.length() == 0) {
                        slash = last = i;
                        break;
                    }
                    last = buf.charAt(i) == '/' ? i : i - 1;
                    slash = last;
                    break;
                }
            }
            last = slash;
            if (slash < buf.length()) {
                ++slash;
            }
            while (slash < buf.length() && buf.charAt(slash) != '/') {
                ++slash;
            }
        }
        return buf.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String canonicalPath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        int end = path.length();
        int start = path.lastIndexOf(47, end);
        block10: while (end >= 0) {
            switch (end - start) {
                case 1: {
                    if (start >= 0 && end != path.length()) break block10;
                    break;
                }
                case 2: {
                    if (path.charAt(start + 1) == '.') break block10;
                    break;
                }
                case 3: {
                    if (path.charAt(start + 1) == '.' && path.charAt(start + 2) == '.') break block10;
                }
            }
            end = start;
            start = path.lastIndexOf(47, end - 1);
        }
        if (start >= end) {
            return path;
        }
        StringBuffer buf = new StringBuffer(path);
        int delStart = -1;
        int delEnd = -1;
        int skip = 0;
        block11: while (end >= 0) {
            switch (end - start) {
                case 1: {
                    if (start < 0 || end == path.length()) break;
                    delStart = start;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    if (delStart == 0 && delEnd == buf.length()) {
                        ++delStart;
                        break;
                    }
                    end = start--;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block11;
                }
                case 2: {
                    if (buf.charAt(start + 1) != '.') {
                        if (--skip != 0) break;
                        delStart = start >= 0 ? start : 0;
                        break;
                    }
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    if ((delStart = start) < 0 || delStart == 0 && buf.charAt(delStart) == '/') {
                        ++delStart;
                        if (delEnd >= buf.length() || buf.charAt(delEnd) != '/') break;
                        ++delEnd;
                        break;
                    }
                    end = start--;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block11;
                }
                case 3: {
                    if (buf.charAt(start + 1) != '.' || buf.charAt(start + 2) != '.') {
                        if (--skip != 0) break;
                        delStart = start >= 0 ? start : 0;
                        break;
                    }
                    delStart = start;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    ++skip;
                    end = start--;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block11;
                }
                default: {
                    if (--skip != 0) break;
                    int n = delStart = start >= 0 ? start : 0;
                }
            }
            if (skip <= 0 && delStart >= 0 && delStart >= 0) {
                buf.delete(delStart, delEnd);
                delEnd = -1;
                delStart = -1;
                if (skip > 0) {
                    delEnd = end;
                }
            }
            end = start--;
            while (start >= 0 && buf.charAt(start) != '/') {
                --start;
            }
        }
        if (skip > 0) {
            return null;
        }
        if (delEnd >= 0) {
            buf.delete(delStart, delEnd);
        }
        if (path.endsWith(".") && buf.length() > 0 && buf.charAt(buf.length() - 1) != '/') {
            buf.append('/');
        }
        return buf.toString();
    }

    public URI(URI uri) throws IllegalArgumentException {
        this._uri = uri.toString();
        this._scheme = uri._scheme;
        this._host = uri._host;
        this._port = uri._port;
        this._path = uri._path;
        this._query = uri._query;
        this._parameters = (UrlEncoded)uri._parameters.clone();
        this._dirty = false;
        this._encodeNulls = uri._encodeNulls;
    }

    public URI(String uri) throws IllegalArgumentException {
        try {
            this._uri = uri;
            int maxi = uri.length() - 1;
            int mark = 0;
            int state = 0;
            int i = 0;
            while (i <= maxi) {
                char c = uri.charAt(i);
                switch (state) {
                    case 0: {
                        if (c == ':' && uri.charAt(i + 1) == '/' && uri.charAt(i + 2) == '/') {
                            this._scheme = uri.substring(mark, i);
                            mark = (i += 2) + 1;
                            state = 1;
                            break;
                        }
                        if (i == 0 && c == '/') {
                            state = 3;
                            break;
                        }
                        if (i != 0 || c != '*') break;
                        state = 5;
                        this._path = "*";
                        break;
                    }
                    case 1: {
                        if (c == ':') {
                            this._host = uri.substring(mark, i);
                            mark = i + 1;
                            state = 2;
                            break;
                        }
                        if (c != '/') break;
                        this._host = uri.substring(mark, i);
                        mark = i;
                        state = 3;
                        break;
                    }
                    case 2: {
                        if (c != '/') break;
                        this._port = Integer.parseInt(uri.substring(mark, i));
                        mark = i;
                        state = 3;
                        break;
                    }
                    case 3: {
                        if (c != '?') break;
                        this._path = URI.decodePath(uri.substring(mark, i));
                        mark = i + 1;
                        state = 4;
                        break;
                    }
                }
                ++i;
            }
            switch (state) {
                case 0: {
                    this._dirty = true;
                    this._path = "/" + this._uri;
                    break;
                }
                case 1: {
                    this._dirty = true;
                    this._path = "/";
                    this._host = uri.substring(mark);
                    break;
                }
                case 2: {
                    this._dirty = true;
                    this._path = "/";
                    this._port = Integer.parseInt(uri.substring(mark));
                    break;
                }
                case 3: {
                    this._dirty = mark == maxi;
                    this._path = URI.decodePath(uri.substring(mark));
                    break;
                }
                case 4: {
                    this._dirty = false;
                    if (mark > maxi) break;
                    this._query = uri.substring(mark);
                    break;
                }
                case 5: {
                    this._dirty = false;
                }
            }
            if (this._query != null && this._query.length() > 0) {
                this._parameters.decode(this._query);
            } else {
                this._query = null;
            }
        }
        catch (Exception e) {
            Code.ignore(e);
            throw new IllegalArgumentException("Malformed URI '" + uri + "' : " + e.toString());
        }
    }
}

