/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import org.mortbay.util.BlockingQueue;
import org.mortbay.util.Code;
import org.mortbay.util.LifeCycle;

public class ThreadPool
implements LifeCycle {
    static int __maxThreads = Integer.getInteger("THREADPOOL_MAX_THREADS", 256);
    static int __minThreads = Integer.getInteger("THREADPOOL_MIN_THREADS", 1);
    static int __stopWaitMs = Integer.getInteger("THREADPOOL_STOP_WAIT", 5000);
    public static int __nullLockChecks = Integer.getInteger("THREADPOOL_NULL_LOCK_CHECKS", 2);
    String __threadClass = System.getProperty("THREADPOOL_THREAD_CLASS", "java.lang.Thread");
    private HashSet _threadSet;
    private int _maxThreads = __maxThreads;
    private int _minThreads = __minThreads;
    private int _maxIdleTimeMs = 0;
    private String _name;
    private int _threadId = 0;
    private HashSet _idleSet = new HashSet();
    private boolean _running = false;
    private Class _threadClass;
    private Constructor _constructThread;
    private BlockingQueue _queue;
    private int _queueChecks;
    private static /* synthetic */ Class class$Ljava$lang$Thread;
    private static /* synthetic */ Class class$Ljava$lang$Runnable;

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public synchronized void setThreadClass(Class threadClass) throws IllegalStateException {
        if (this._running) {
            throw new IllegalStateException("Thread Pool Running");
        }
        this._threadClass = threadClass;
        if (this._threadClass == null || !(class$Ljava$lang$Thread != null ? class$Ljava$lang$Thread : (class$Ljava$lang$Thread = ThreadPool.class$("java.lang.Thread"))).isAssignableFrom(this._threadClass)) {
            Code.warning("Invalid thread class (ignored) " + this._threadClass.getName());
            this._threadClass = class$Ljava$lang$Thread != null ? class$Ljava$lang$Thread : (class$Ljava$lang$Thread = ThreadPool.class$("java.lang.Thread"));
        }
        try {
            Class[] args = new Class[]{class$Ljava$lang$Runnable != null ? class$Ljava$lang$Runnable : (class$Ljava$lang$Runnable = ThreadPool.class$("java.lang.Runnable"))};
            this._constructThread = this._threadClass.getConstructor(args);
        }
        catch (Exception e) {
            Code.warning("Invalid thread class (ignored)", e);
            this.setThreadClass(class$Ljava$lang$Thread != null ? class$Ljava$lang$Thread : (class$Ljava$lang$Thread = ThreadPool.class$("java.lang.Thread")));
        }
        if (this._name == null) {
            this._name = this.getClass().getName();
            this._name = this._name.substring(this._name.lastIndexOf(46) + 1);
        }
    }

    public Class getThreadClass() {
        return this._threadClass;
    }

    protected void handle(Object job) throws InterruptedException {
        if (job != null && job instanceof Runnable) {
            ((Runnable)job).run();
        } else {
            Code.warning("Invalid job: " + job);
        }
    }

    public boolean isStarted() {
        return this._running && this._threadSet != null;
    }

    public boolean isDestroyed() {
        return this._threadSet == null;
    }

    public int getThreads() {
        if (this._threadSet == null) {
            return 0;
        }
        return this._threadSet.size();
    }

    public int getIdleThreads() {
        if (this._idleSet == null) {
            return 0;
        }
        return this._idleSet.size();
    }

    public int getMinThreads() {
        return this._minThreads;
    }

    public void setMinThreads(int minThreads) {
        this._minThreads = minThreads;
    }

    public int getMaxThreads() {
        return this._maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this._maxThreads = maxThreads;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeMs = maxIdleTimeMs;
    }

    public synchronized void initialize(Object o) {
        this.destroy();
    }

    public synchronized void start() throws Exception {
        this.getName();
        if (this._running) {
            Code.debug("Already started");
            return;
        }
        Code.debug((Object)"Start Pool ", (Object)this._name);
        this._running = true;
        this._threadSet = new HashSet(this._maxThreads + this._maxThreads / 2 + 13);
        int i = 0;
        while (i < this._minThreads) {
            this.newThread();
            ++i;
        }
    }

    public void stop() throws InterruptedException {
        Code.debug((Object)"Stop Pool ", (Object)this._name);
        this._running = false;
        while (this._idleSet != null && !this._idleSet.isEmpty()) {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                Object[] threads = ((AbstractCollection)this._idleSet).toArray();
                int t = 0;
                while (t < threads.length) {
                    Thread thread = (Thread)threads[t];
                    thread.interrupt();
                    ++t;
                }
            }
            Thread.yield();
            if (this._idleSet.size() <= 0) continue;
            Thread.sleep(100L);
            if (this._idleSet.size() > 0) {
                ThreadPool threadPool2 = this;
                synchronized (threadPool2) {
                    Object[] threads = ((AbstractCollection)this._idleSet).toArray();
                    int t = 0;
                    while (t < threads.length) {
                        Thread thread = (Thread)threads[t];
                        thread.stop();
                        ++t;
                    }
                }
            }
            if (this._idleSet.size() <= 0) continue;
            Code.warning("JVM cannot interrupt Idle Threads!");
            this._idleSet.clear();
        }
    }

    public synchronized void destroy() {
        Object var3_4;
        Code.debug((Object)"Destroy Pool ", (Object)this._name);
        if (this._threadSet == null) {
            return;
        }
        this._running = false;
        Object[] threads = ((AbstractCollection)this._threadSet).toArray();
        int t = 0;
        while (t < threads.length) {
            Thread thread = (Thread)threads[t];
            thread.interrupt();
            ++t;
        }
        Thread.yield();
        try {
            long end_wait = System.currentTimeMillis() + (long)__stopWaitMs;
            while (this._threadSet.size() > 0 && end_wait > System.currentTimeMillis()) {
                Thread.yield();
            }
            if (this._threadSet.size() > 0) {
                threads = ((AbstractCollection)this._threadSet).toArray();
                int t2 = 0;
                while (t2 < threads.length) {
                    Thread thread = (Thread)threads[t2];
                    if (thread.isAlive()) {
                        thread.interrupt();
                        Thread.yield();
                        thread.stop();
                        if (thread.isAlive()) {
                            Code.warning("Can't stop " + thread);
                        }
                    }
                    ++t2;
                }
            }
        }
        catch (Throwable throwable) {
            var3_4 = null;
            this._threadSet.clear();
            this._threadSet = null;
            throw throwable;
        }
        var3_4 = null;
        this._threadSet.clear();
        this._threadSet = null;
    }

    private synchronized void newThread() throws InvocationTargetException, IllegalAccessException, InstantiationException {
        PoolThreadRunnable runner = new PoolThreadRunnable();
        Object[] args = new Object[]{runner};
        Thread thread = (Thread)this._constructThread.newInstance(args);
        thread.setName(this._name + "-" + this._threadId++);
        this._threadSet.add(thread);
        thread.start();
    }

    public final void join() throws InterruptedException {
        while (this._threadSet != null && this._threadSet.size() > 0) {
            Thread thread = null;
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                Iterator iter = this._threadSet.iterator();
                if (iter.hasNext()) {
                    thread = (Thread)iter.next();
                }
            }
            if (thread == null) continue;
            thread.join();
        }
    }

    protected Object getJob(int idleTimeoutMs) throws InterruptedException, InterruptedIOException {
        if (this._queue == null || this._queueChecks < __nullLockChecks) {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (this._queue == null) {
                    this._queue = new BlockingQueue(this._maxThreads);
                }
                ++this._queueChecks;
            }
        }
        return this._queue.get(idleTimeoutMs);
    }

    public void run(Object job) throws InterruptedException {
        if (!this._running) {
            throw new IllegalStateException("Not started");
        }
        if (job == null) {
            Code.warning("Null Job");
            return;
        }
        if (this._queue == null || this._queueChecks < 2) {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (this._queue == null) {
                    this._queue = new BlockingQueue(this._maxThreads);
                }
                ++this._queueChecks;
            }
        }
        this._queue.put(job);
    }

    public int getSize() {
        if (this._threadSet == null) {
            return 0;
        }
        return this._threadSet.size();
    }

    public int getMinSize() {
        return this._minThreads;
    }

    public void setMinSize(int minThreads) {
        this._minThreads = minThreads;
    }

    public int getMaxSize() {
        return this._maxThreads;
    }

    public void setMaxSize(int maxThreads) {
        this._maxThreads = maxThreads;
    }

    static /* synthetic */ String access$0(ThreadPool threadPool) {
        return threadPool._name;
    }

    static /* synthetic */ HashSet access$1(ThreadPool threadPool) {
        return threadPool._threadSet;
    }

    static /* synthetic */ boolean access$2(ThreadPool threadPool) {
        return threadPool._running;
    }

    static /* synthetic */ HashSet access$3(ThreadPool threadPool) {
        return threadPool._idleSet;
    }

    static /* synthetic */ int access$4(ThreadPool threadPool) {
        return threadPool._maxThreads;
    }

    static /* synthetic */ void access$5(ThreadPool threadPool) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        threadPool.newThread();
    }

    static /* synthetic */ int access$6(ThreadPool threadPool) {
        return threadPool._maxIdleTimeMs;
    }

    static /* synthetic */ int access$7(ThreadPool threadPool) {
        return threadPool._minThreads;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ThreadPool() {
        try {
            this._threadClass = Class.forName(this.__threadClass);
            Code.debug("Using thread class '", this._threadClass.getName(), "'");
        }
        catch (Exception e) {
            Code.warning("Invalid thread class (ignored) ", e);
            this._threadClass = class$Ljava$lang$Thread != null ? class$Ljava$lang$Thread : (class$Ljava$lang$Thread = ThreadPool.class$("java.lang.Thread"));
        }
        this.setThreadClass(this._threadClass);
    }

    public ThreadPool(String name) {
        this();
        this._name = name;
    }

    private class PoolThreadRunnable
    implements Runnable {
        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 41[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        PoolThreadRunnable() {
        }
    }
}

