/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

public class BlockingQueue {
    Object[] elements;
    int maxSize;
    int size = 0;
    int head = 0;
    int tail = 0;

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public void put(Object o) throws InterruptedException {
        Object[] objectArray = this.elements;
        synchronized (objectArray) {
            while (this.size == this.maxSize) {
                this.elements.wait();
            }
            this.elements[this.tail] = o;
            if (++this.tail == this.maxSize) {
                this.tail = 0;
            }
            ++this.size;
            this.elements.notify();
        }
    }

    public void put(Object o, int timeout) throws InterruptedException {
        Object[] objectArray = this.elements;
        synchronized (objectArray) {
            if (this.size == this.maxSize) {
                this.elements.wait(timeout);
                if (this.size == this.maxSize) {
                    throw new InterruptedException("Timed out");
                }
            }
            this.elements[this.tail] = o;
            if (++this.tail == this.maxSize) {
                this.tail = 0;
            }
            ++this.size;
            this.elements.notify();
        }
    }

    public Object get() throws InterruptedException {
        Object[] objectArray = this.elements;
        synchronized (objectArray) {
            while (this.size == 0) {
                this.elements.wait();
            }
            Object o = this.elements[this.head];
            this.elements[this.head] = null;
            if (++this.head == this.maxSize) {
                this.head = 0;
            }
            if (this.size == this.maxSize) {
                this.elements.notifyAll();
            }
            --this.size;
            Object object = o;
            Object var2_4 = null;
            return object;
        }
    }

    public Object get(int timeoutMs) throws InterruptedException {
        Object[] objectArray = this.elements;
        synchronized (objectArray) {
            if (this.size == 0) {
                this.elements.wait(timeoutMs);
            }
            if (this.size == 0) {
                Object var4_3 = null;
                Object var3_5 = null;
                return var4_3;
            }
            Object o = this.elements[this.head];
            this.elements[this.head] = null;
            if (++this.head == this.maxSize) {
                this.head = 0;
            }
            if (this.size == this.maxSize) {
                this.elements.notifyAll();
            }
            --this.size;
            Object object = o;
            Object var3_6 = null;
            return object;
        }
    }

    public Object peek() throws InterruptedException {
        Object[] objectArray = this.elements;
        synchronized (objectArray) {
            Object o;
            if (this.size == 0) {
                this.elements.wait();
            }
            if (this.size == 0) {
                Object var3_2 = null;
                Object var2_4 = null;
                return var3_2;
            }
            Object object = o = this.elements[this.head];
            Object var2_5 = null;
            return object;
        }
    }

    public Object peek(int timeoutMs) throws InterruptedException {
        Object[] objectArray = this.elements;
        synchronized (objectArray) {
            Object o;
            if (this.size == 0) {
                this.elements.wait(timeoutMs);
            }
            if (this.size == 0) {
                Object var4_3 = null;
                Object var3_5 = null;
                return var4_3;
            }
            Object object = o = this.elements[this.head];
            Object var3_6 = null;
            return object;
        }
    }

    public BlockingQueue(int maxSize) {
        this.maxSize = maxSize;
        if (maxSize == 0) {
            this.maxSize = 255;
        }
        this.elements = new Object[this.maxSize];
    }
}

