/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.mortbay.http.ChunkableInputStream;
import org.mortbay.http.ChunkableOutputStream;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.InclusiveByteRange;
import org.mortbay.http.MultiPartResponse;
import org.mortbay.http.PathMap;
import org.mortbay.http.handler.NullHandler;
import org.mortbay.util.Code;
import org.mortbay.util.IO;
import org.mortbay.util.Log;
import org.mortbay.util.Resource;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;

public class ResourceHandler
extends NullHandler {
    private String _allowHeader;
    private CachedFile _mostRecentlyUsed;
    private CachedFile _leastRecentlyUsed;
    private Map _cacheMap;
    private boolean _dirAllowed;
    private boolean _putAllowed;
    private boolean _delAllowed;
    private int _maxCachedFiles;
    private int _maxCachedFileSize;
    private Resource _baseResource;
    private boolean _handleGeneralOptionsQuery;
    private boolean _acceptRanges;
    List _indexFiles;

    public boolean isDirAllowed() {
        return this._dirAllowed;
    }

    public void setDirAllowed(boolean dirAllowed) {
        this._dirAllowed = dirAllowed;
    }

    public boolean isPutAllowed() {
        return this._putAllowed;
    }

    public void setPutAllowed(boolean putAllowed) {
        this._putAllowed = putAllowed;
    }

    public boolean isDelAllowed() {
        return this._delAllowed;
    }

    public void setDelAllowed(boolean delAllowed) {
        this._delAllowed = delAllowed;
    }

    public boolean isAcceptRanges() {
        return this._acceptRanges;
    }

    public void setAcceptRanges(boolean ar) {
        this._acceptRanges = ar;
    }

    public List getIndexFiles() {
        return this._indexFiles;
    }

    public void setIndexFiles(List indexFiles) {
        this._indexFiles = indexFiles == null ? new ArrayList(5) : indexFiles;
    }

    public void addIndexFile(String indexFile) {
        this._indexFiles.add(indexFile);
    }

    public int getMaxCachedFiles() {
        return this._maxCachedFiles;
    }

    public void setMaxCachedFiles(int maxCachedFiles_) {
        this._maxCachedFiles = maxCachedFiles_;
    }

    public int getMaxCachedFileSize() {
        return this._maxCachedFileSize;
    }

    public void setMaxCachedFileSize(int maxCachedFileSize) {
        this._maxCachedFileSize = maxCachedFileSize;
    }

    public boolean getHandleGeneralOptionsQuery() {
        return this._handleGeneralOptionsQuery;
    }

    public void setHandleGeneralOptionsQuery(boolean b) {
        this._handleGeneralOptionsQuery = b;
    }

    public synchronized void start() throws Exception {
        this._baseResource = this.getHandlerContext().getBaseResource();
        Log.event("ResourceHandler started in " + this._baseResource);
        this._mostRecentlyUsed = null;
        this._leastRecentlyUsed = null;
        if (this._maxCachedFiles > 0 && this._maxCachedFileSize > 0) {
            this._cacheMap = new HashMap();
        }
        super.start();
    }

    public void stop() {
        super.stop();
    }

    public void destroy() {
        Map map = this._cacheMap;
        synchronized (map) {
            if (this._cacheMap != null) {
                this._cacheMap.clear();
            }
            this._cacheMap = null;
            this._mostRecentlyUsed = null;
            this._leastRecentlyUsed = null;
        }
        super.destroy();
    }

    private Resource makeresource(String pathSpec, String path) throws MalformedURLException, IOException {
        Resource baseResource = this.getHandlerContext().getBaseResource();
        if (baseResource == null) {
            return null;
        }
        String info = PathMap.pathInfo(pathSpec, path);
        if (info == null) {
            info = path;
        }
        return baseResource.addPath(info);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if ((pathInContext = Resource.canonicalPath(pathInContext)) == null) {
            throw new HttpException(403);
        }
        Resource baseResource = this.getHandlerContext().getBaseResource();
        if (baseResource == null) {
            return;
        }
        boolean endsWithSlash = pathInContext.endsWith("/");
        Resource resource = null;
        try {
            try {
                resource = baseResource.addPath(pathInContext);
                Code.debug((Object)"\nPATH=", pathInContext, (Object)"\nRESOURCE=", resource);
                String method = request.getMethod();
                if (method.equals("GET") || method.equals("HEAD")) {
                    this.handleGet(request, response, pathInContext, resource, endsWithSlash);
                } else if (method.equals("PUT")) {
                    this.handlePut(request, response, pathInContext, resource);
                } else if (method.equals("DELETE")) {
                    this.handleDelete(request, response, pathInContext, resource);
                } else if (method.equals("OPTIONS")) {
                    this.handleOptions(response, pathInContext);
                } else if (method.equals("MOVE")) {
                    this.handleMove(request, response, pathInContext, resource);
                } else {
                    Code.debug("Unknown action:" + method);
                    try {
                        if (resource.exists()) {
                            response.sendError(HttpResponse.__501_Not_Implemented);
                        }
                    }
                    catch (Exception e) {
                        Code.ignore(e);
                    }
                }
                Object var9_11 = null;
                if (resource == null) return;
            }
            catch (IllegalArgumentException e) {
                Code.ignore(e);
                Object var9_12 = null;
                if (resource == null) return;
                resource.release();
                return;
            }
            resource.release();
            return;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (resource == null) throw throwable;
            resource.release();
            throw throwable;
        }
    }

    public void handleGet(HttpRequest request, HttpResponse response, String pathInContext, Resource resource, boolean endsWithSlash) throws IOException {
        Code.debug((Object)"Looking for ", (Object)resource);
        if (this._cacheMap != null && !endsWithSlash) {
            CachedFile cachedFile = null;
            Map map = this._cacheMap;
            synchronized (map) {
                cachedFile = (CachedFile)this._cacheMap.get(resource.toString());
                if (cachedFile != null && !cachedFile.isValid()) {
                    cachedFile = null;
                }
            }
            if (cachedFile != null) {
                if (!this.passConditionalHeaders(request, response, cachedFile.resource)) {
                    return;
                }
                Code.debug((Object)"Cache hit: ", (Object)resource);
                this.sendData(request, response, cachedFile);
                return;
            }
        }
        if (resource != null && resource.exists()) {
            if (!this.passConditionalHeaders(request, response, resource)) {
                return;
            }
            if (resource.isDirectory()) {
                if (!endsWithSlash && !pathInContext.equals("/")) {
                    Code.debug("Redirect to directory/");
                    String q = request.getQuery();
                    StringBuffer buf = request.getRequestURL();
                    if (q != null && q.length() != 0) {
                        buf.append('?');
                        buf.append(q);
                    }
                    response.setField("Location", URI.addPaths(buf.toString(), "/"));
                    response.sendError(302);
                    return;
                }
                int i = this._indexFiles.size();
                while (i-- > 0) {
                    Resource index = resource.addPath((String)this._indexFiles.get(i));
                    if (!index.exists()) continue;
                    int last = request.setState(0);
                    String ipath = URI.addPaths(request.getPath(), (String)this._indexFiles.get(i));
                    request.setPath(ipath);
                    request.setState(last);
                    this.getHandlerContext().handle(request, response);
                    return;
                }
                this.sendDirectory(request, response, resource, pathInContext.length() > 1);
            } else if (resource.exists()) {
                if (!endsWithSlash) {
                    this.sendFile(request, response, resource);
                }
            } else {
                Code.warning("Unknown file type");
            }
        }
    }

    private boolean passConditionalHeaders(HttpRequest request, HttpResponse response, Resource resource) throws IOException {
        if (!request.getMethod().equals("HEAD")) {
            long date = 0L;
            date = request.getDateField("If-Unmodified-Since");
            if (date > 0L && resource.lastModified() > date) {
                response.sendError(HttpResponse.__412_Precondition_Failed);
                return false;
            }
            date = request.getDateField("If-Modified-Since");
            if (date > 0L && resource.lastModified() <= date) {
                response.sendError(HttpResponse.__304_Not_Modified);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    void handlePut(HttpRequest request, HttpResponse response, String pathInContext, Resource resource) throws IOException {
        Code.debug((Object)"PUT ", pathInContext, (Object)" in ", resource);
        if (!this._putAllowed) {
            return;
        }
        if (resource.exists() && !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        try {
            int read;
            int toRead = request.getIntField("Content-Length");
            ChunkableInputStream in = request.getInputStream();
            OutputStream fos = resource.getOutputStream();
            int bufSize = 1024;
            byte[] bytes = new byte[1024];
            Code.debug("Content-Length=" + toRead);
            while (toRead > 0 && (read = ((InputStream)in).read(bytes, 0, toRead > 1024 ? 1024 : toRead)) > 0) {
                void var10_12;
                toRead -= var10_12;
                fos.write(bytes, 0, (int)var10_12);
                if (!Code.debug()) continue;
                Code.debug("Read " + (int)var10_12 + "bytes: " + bytes);
            }
            ((InputStream)in).close();
            fos.close();
            request.setHandled(true);
            response.sendError(HttpResponse.__204_No_Content);
        }
        catch (SecurityException sex) {
            Code.warning(sex);
            response.sendError(HttpResponse.__403_Forbidden, sex.getMessage());
        }
        catch (Exception ex) {
            Code.warning(ex);
        }
    }

    void handleDelete(HttpRequest request, HttpResponse response, String pathInContext, Resource resource) throws IOException {
        Code.debug((Object)"DELETE ", pathInContext, (Object)" from ", resource);
        if (!resource.exists() || !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        if (!this._delAllowed) {
            this.setAllowHeader(response);
            response.sendError(HttpResponse.__405_Method_Not_Allowed);
            return;
        }
        try {
            CachedFile cachedFile;
            resource.delete();
            if (this._cacheMap != null && (cachedFile = (CachedFile)this._cacheMap.get(resource.toString())) != null) {
                cachedFile.invalidate();
            }
            request.setHandled(true);
            response.sendError(HttpResponse.__204_No_Content);
        }
        catch (SecurityException sex) {
            Code.warning(sex);
            response.sendError(HttpResponse.__403_Forbidden, sex.getMessage());
        }
    }

    void handleMove(HttpRequest request, HttpResponse response, String pathInContext, Resource resource) throws IOException {
        if (!resource.exists() || !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        if (!this._delAllowed || !this._putAllowed) {
            this.setAllowHeader(response);
            response.sendError(HttpResponse.__405_Method_Not_Allowed);
            return;
        }
        String newPath = Resource.canonicalPath(request.getField("New-uri"));
        if (newPath == null) {
            response.sendError(HttpResponse.__405_Method_Not_Allowed, "Bad new uri");
            return;
        }
        String contextPath = this.getHandlerContext().getContextPath();
        if (contextPath != null && !newPath.startsWith(contextPath)) {
            response.sendError(HttpResponse.__405_Method_Not_Allowed, "Not in context");
            return;
        }
        try {
            String newInfo = newPath;
            if (contextPath != null) {
                newInfo = newInfo.substring(contextPath.length());
            }
            Resource newFile = this._baseResource.addPath(newInfo);
            Code.debug("Moving " + resource + " to " + newFile);
            resource.renameTo(newFile);
            request.setHandled(true);
            response.sendError(HttpResponse.__204_No_Content);
        }
        catch (Exception ex) {
            Code.warning(ex);
            this.setAllowHeader(response);
            response.sendError(HttpResponse.__405_Method_Not_Allowed, "Error:" + ex);
            return;
        }
    }

    void handleOptions(HttpResponse response, String pathInContext) throws IOException {
        if (!this._handleGeneralOptionsQuery && pathInContext.equals("*")) {
            return;
        }
        this.setAllowHeader(response);
        response.commit();
    }

    void setAllowHeader(HttpResponse response) {
        if (this._allowHeader == null) {
            StringBuffer sb = new StringBuffer(128);
            sb.append("GET");
            sb.append(", ");
            sb.append("HEAD");
            if (this._putAllowed) {
                sb.append(", ");
                sb.append("PUT");
            }
            if (this._delAllowed) {
                sb.append(", ");
                sb.append("DELETE");
            }
            if (this._putAllowed && this._delAllowed) {
                sb.append(", ");
                sb.append("MOVE");
            }
            sb.append(", ");
            sb.append("OPTIONS");
            this._allowHeader = sb.toString();
        }
        response.setField("Allow", this._allowHeader);
    }

    void sendData(HttpRequest request, HttpResponse response, SendableResource data) throws IOException {
        String ctp;
        long resLength = data.getLength();
        Enumeration reqRanges = request.getFieldValues("Range");
        if (reqRanges == null || !reqRanges.hasMoreElements()) {
            data.writeHeaders(response, resLength);
            data.writeBytes(response.getOutputStream(), 0L, resLength);
            request.setHandled(true);
            return;
        }
        List validRanges = InclusiveByteRange.parseRangeHeaders(reqRanges);
        Code.debug("requested ranges: " + reqRanges + "=" + validRanges);
        ListIterator rit = validRanges.listIterator();
        InclusiveByteRange singleSatisfiableRange = null;
        while (rit.hasNext()) {
            InclusiveByteRange ibr = (InclusiveByteRange)rit.next();
            if (ibr.getFirst() >= resLength) {
                Code.warning("not satisfiable: " + ibr);
                rit.remove();
                continue;
            }
            if (singleSatisfiableRange != null) continue;
            singleSatisfiableRange = ibr;
        }
        if (singleSatisfiableRange == null) {
            Code.debug("no satisfiable ranges");
            data.writeHeaders(response, resLength);
            response.setStatus(HttpResponse.__416_Requested_Range_Not_Satisfiable);
            response.setReason((String)HttpResponse.__statusMsg.get(new Integer(HttpResponse.__416_Requested_Range_Not_Satisfiable)));
            response.setField("Content-Range", InclusiveByteRange.to416HeaderRangeString(resLength));
            data.writeBytes(response.getOutputStream(), 0L, resLength);
            request.setHandled(true);
            return;
        }
        if (validRanges.size() == 1) {
            Code.debug("single satisfiable range: " + singleSatisfiableRange);
            long singleLength = singleSatisfiableRange.getSize(resLength);
            data.writeHeaders(response, singleLength);
            response.setStatus(HttpResponse.__206_Partial_Content);
            response.setReason((String)HttpResponse.__statusMsg.get(new Integer(HttpResponse.__206_Partial_Content)));
            response.setField("Content-Range", singleSatisfiableRange.toHeaderRangeString(resLength));
            data.writeBytes(response.getOutputStream(), singleSatisfiableRange.getFirst(resLength), singleLength);
            request.setHandled(true);
            return;
        }
        String encoding = data.getEncoding();
        MultiPartResponse multi = new MultiPartResponse(request, response);
        response.setStatus(HttpResponse.__206_Partial_Content);
        response.setReason((String)HttpResponse.__statusMsg.get(new Integer(HttpResponse.__206_Partial_Content)));
        if (request.containsField("Request-Range")) {
            String string = "multipart/x-byteranges; boundary=";
        } else {
            ctp = "multipart/byteranges; boundary=";
        }
        response.setField("Content-Type", ctp + multi.getBoundary());
        rit = validRanges.listIterator();
        while (rit.hasNext()) {
            InclusiveByteRange ibr = (InclusiveByteRange)rit.next();
            String header = "Content-Range: " + ibr.toHeaderRangeString(resLength);
            Code.debug((Object)"multi range: ", encoding, (Object)" ", header);
            multi.startPart(encoding, new String[]{header});
            data.writeBytes(multi.getOut(), ibr.getFirst(resLength), ibr.getSize(resLength));
        }
        multi.close();
        request.setHandled(true);
    }

    void sendFile(HttpRequest request, HttpResponse response, Resource resource) throws IOException {
        Code.debug((Object)"sendFile: ", (Object)resource);
        SendableResource data = null;
        data = this._cacheMap != null && resource.length() > 0L && resource.length() < (long)this._maxCachedFileSize ? new CachedFile(resource) : new UnCachedFile(resource);
        try {
            this.sendData(request, response, data);
        }
        finally {
            Object var6_5 = null;
            data.requestDone();
        }
    }

    void sendDirectory(HttpRequest request, HttpResponse response, Resource file, boolean parent) throws IOException {
        if (this._dirAllowed) {
            String[] ls = file.list();
            if (ls == null) {
                try {
                    this.sendFile(request, response, file);
                }
                catch (IOException e) {
                    Code.ignore(e);
                    response.sendError(403, "Invalid directory");
                }
                return;
            }
            Code.debug("sendDirectory: " + file);
            String base = URI.addPaths(request.getPath(), "/");
            response.setField("Content-Type", "text/html");
            if (request.getMethod().equals("HEAD")) {
                response.commit();
                return;
            }
            String title = "Directory: " + base;
            ChunkableOutputStream out = response.getOutputStream();
            out.print("<HTML><HEAD><TITLE>");
            out.print(title);
            out.print("</TITLE></HEAD><BODY>\n<H1>");
            out.print(title);
            out.print("</H1><TABLE BORDER=0>");
            if (parent) {
                out.print("<TR><TD><A HREF=");
                out.print(this.padSpaces(URI.addPaths(base, "../")));
                out.print(">Parent Directory</A></TD><TD></TD><TD></TD></TR>\n");
            }
            DateFormat dfmt = DateFormat.getDateTimeInstance(2, 2);
            int i = 0;
            while (i < ls.length) {
                Resource item = file.addPath(ls[i]);
                out.print("<TR><TD><A HREF=\"");
                String path = URI.addPaths(base, ls[i]);
                if (item.isDirectory() && !path.endsWith("/")) {
                    path = URI.addPaths(path, "/");
                }
                out.print(this.padSpaces(path));
                out.print("\">");
                out.print(ls[i]);
                out.print("&nbsp;");
                out.print("</TD><TD ALIGN=right>");
                out.print("" + item.length());
                out.print(" bytes&nbsp;</TD><TD>");
                out.print(dfmt.format(new Date(item.lastModified())));
                out.print("</TD></TR>\n");
                ++i;
            }
            out.println("</TABLE>");
            request.setHandled(true);
        } else {
            response.sendError(403, "Directory access not allowed");
        }
    }

    private String padSpaces(String str) {
        return StringUtil.replace(str, " ", "%20");
    }

    private final void block$() {
        this._allowHeader = null;
        this._mostRecentlyUsed = null;
        this._leastRecentlyUsed = null;
        this._cacheMap = null;
        this._dirAllowed = true;
        this._putAllowed = false;
        this._delAllowed = false;
        this._maxCachedFiles = 128;
        this._maxCachedFileSize = 40960;
        this._baseResource = null;
        this._handleGeneralOptionsQuery = true;
        this._acceptRanges = true;
        this._indexFiles = new ArrayList(2);
        this._indexFiles.add("index.html");
        this._indexFiles.add("index.htm");
    }

    public ResourceHandler() {
        this.block$();
    }

    private static interface SendableResource {
        public long getLength();

        public String getEncoding();

        public void writeHeaders(HttpResponse var1, long var2) throws IOException;

        public void writeBytes(OutputStream var1, long var2, long var4) throws IOException;

        public void requestDone();
    }

    private class UnCachedFile
    implements SendableResource {
        Resource resource;
        InputStream ris = null;
        String encoding;
        long length = 0L;
        long pos = 0L;

        public String getEncoding() {
            return this.encoding;
        }

        public long getLength() {
            return this.length;
        }

        public void writeBytes(OutputStream os, long start, long count) throws IOException {
            if (this.ris == null || this.pos > start) {
                if (this.ris != null) {
                    this.ris.close();
                }
                this.ris = this.resource.getInputStream();
                this.pos = 0L;
            }
            if (this.pos < start) {
                this.ris.skip(start - this.pos);
                this.pos = start;
            }
            IO.copy(this.ris, os, (long)((int)count));
            this.pos += count;
        }

        public void writeHeaders(HttpResponse response, long count) {
            response.setField("Content-Type", this.encoding);
            if (this.length != -1L) {
                response.setIntField("Content-Length", (int)count);
            }
            response.setDateField("Last-Modified", this.resource.lastModified());
            if (ResourceHandler.this._acceptRanges) {
                response.setField("Accept-Ranges", "bytes");
            }
        }

        public void requestDone() {
            try {
                if (this.ris != null) {
                    this.ris.close();
                }
            }
            catch (IOException ioe) {
                Code.ignore(ioe);
            }
        }

        public UnCachedFile(Resource resource) {
            this.resource = resource;
            this.encoding = ResourceHandler.this.getHandlerContext().getMimeByExtension(resource.getName());
            if (this.encoding == null) {
                this.encoding = ResourceHandler.this.getHandlerContext().getMimeByExtension(".default");
            }
            this.length = resource.length();
        }
    }

    private class CachedFile
    implements SendableResource {
        Resource resource;
        long lastModified;
        String lastModifiedString;
        String sizeString;
        byte[] bytes;
        String encoding;
        CachedFile prev;
        CachedFile next;

        public String getEncoding() {
            return this.encoding;
        }

        public void writeBytes(OutputStream os, long startByte, long count) throws IOException {
            os.write(this.bytes, (int)startByte, (int)count);
        }

        boolean isValid() throws IOException {
            if (this.resource == null || !this.resource.exists() || this.lastModified != this.resource.lastModified()) {
                this.invalidate();
                return false;
            }
            this.use();
            return true;
        }

        public void invalidate() {
            Map map = ResourceHandler.this._cacheMap;
            synchronized (map) {
                --this.lastModified;
                this.lastModifiedString = null;
                ResourceHandler.this._cacheMap.remove(this.resource.toString());
                if (this.prev == null) {
                    ResourceHandler.this._mostRecentlyUsed = this.next;
                } else {
                    this.prev.next = this.next;
                }
                if (this.next == null) {
                    ResourceHandler.this._leastRecentlyUsed = this.prev;
                } else {
                    this.next.prev = this.prev;
                }
                this.prev = null;
                this.next = null;
            }
        }

        public void use() {
            Map map = ResourceHandler.this._cacheMap;
            synchronized (map) {
                if (ResourceHandler.this._mostRecentlyUsed != this) {
                    CachedFile tp = this.prev;
                    CachedFile tn = this.next;
                    this.next = ResourceHandler.this._mostRecentlyUsed;
                    ResourceHandler.this._mostRecentlyUsed = this;
                    if (this.next != null) {
                        this.next.prev = this;
                    }
                    this.prev = null;
                    if (tp != null) {
                        tp.next = tn;
                    }
                    if (tn != null) {
                        tn.prev = tp;
                    }
                    if (ResourceHandler.this._leastRecentlyUsed == this && tp != null) {
                        ResourceHandler.this._leastRecentlyUsed = tp;
                    }
                }
            }
        }

        public void writeHeaders(HttpResponse response, long count) throws IOException {
            Code.debug((Object)"HIT: ", (Object)this.resource);
            response.setField("Content-Type", this.encoding);
            if (count != -1L) {
                if (count == (long)this.bytes.length) {
                    response.setField("Content-Length", this.sizeString);
                } else {
                    response.setIntField("Content-Length", (int)count);
                }
            }
            response.setField("Last-Modified", this.lastModifiedString);
            if (ResourceHandler.this._acceptRanges) {
                response.setField("Accept-Ranges", "bytes");
            }
        }

        void load(Resource resource) throws IOException {
            this.resource = resource;
            this.lastModified = resource.lastModified();
            this.lastModifiedString = HttpFields.__dateSend.format(new Date(this.lastModified));
            this.bytes = new byte[(int)resource.length()];
            this.sizeString = Integer.toString(this.bytes.length);
            Code.debug((Object)"LOAD: ", (Object)resource);
            InputStream in = resource.getInputStream();
            int read = 0;
            while (read < this.bytes.length) {
                int len = in.read(this.bytes, read, this.bytes.length - read);
                if (len == -1) {
                    throw new IOException("Unexpected EOF: " + resource);
                }
                read += len;
            }
            in.close();
            this.encoding = ResourceHandler.this.getHandlerContext().getMimeByExtension(resource.getName());
            if (this.encoding == null) {
                this.encoding = ResourceHandler.this.getHandlerContext().getMimeByExtension(".default");
            }
        }

        public void requestDone() {
        }

        public long getLength() {
            return this.bytes.length;
        }

        public String toString() {
            return this.resource.toString();
        }

        CachedFile(Resource resource) throws IOException {
            Map map = ResourceHandler.this._cacheMap;
            synchronized (map) {
                this.load(resource);
                String r = resource.toString();
                Object old = ResourceHandler.this._cacheMap.get(r);
                if (old != null) {
                    ((CachedFile)old).invalidate();
                }
                ResourceHandler.this._cacheMap.put(r, this);
                this.next = ResourceHandler.this._mostRecentlyUsed;
                ResourceHandler.this._mostRecentlyUsed = this;
                if (this.next != null) {
                    this.next.prev = this;
                } else {
                    ResourceHandler.this._leastRecentlyUsed = this;
                }
                if (ResourceHandler.this._cacheMap.size() > ResourceHandler.this._maxCachedFiles) {
                    ResourceHandler.this._leastRecentlyUsed.invalidate();
                }
            }
        }
    }
}

