/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.SSLServerSocketFactory;
import org.mortbay.http.JsseListener;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Log;
import org.mortbay.util.Password;

public class SunJsseListener
extends JsseListener {
    private String _keystore = JsseListener.DEFAULT_KEYSTORE;
    private Password _password;
    private Password _keypassword;

    public void setKeystore(String keystore) {
        this._keystore = keystore;
    }

    public void setPassword(String password) {
        this._password = new Password("jetty.ssl.password", password);
    }

    public void setKeyPassword(String password) {
        this._keypassword = new Password("jetty.ssl.keypassword", password);
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        this._keystore = System.getProperty("jetty.ssl.keystore", this._keystore);
        Log.event("jetty.ssl.keystore=" + this._keystore);
        if (this._password == null) {
            this._password = new Password("jetty.ssl.password");
        }
        Log.event("jetty.ssl.password=" + this._password.toStarString());
        if (this._keypassword == null) {
            this._keypassword = new Password("jetty.ssl.keypassword", null, this._password.toString());
        }
        Log.event("jetty.ssl.keypassword=" + this._keypassword.toStarString());
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(new File(this._keystore)), this._password.getCharArray());
            KeyManagerFactory km = KeyManagerFactory.getInstance((String)"SunX509");
            km.init(ks, this._keypassword.getCharArray());
            KeyManager[] kma = km.getKeyManagers();
            TrustManagerFactory tm = TrustManagerFactory.getInstance((String)"SunX509");
            tm.init(ks);
            TrustManager[] tma = tm.getTrustManagers();
            SSLContext sslc = SSLContext.getInstance((String)"SSL");
            sslc.init(kma, tma, SecureRandom.getInstance("SHA1PRNG"));
            SSLServerSocketFactory ssfc = sslc.getServerSocketFactory();
            Log.event("SSLServerSocketFactory=" + ssfc);
            SSLServerSocketFactory sSLServerSocketFactory = ssfc;
            Object var2_9 = null;
            this._password.zero();
            this._keypassword.zero();
            return sSLServerSocketFactory;
        }
        catch (Throwable throwable) {
            Object var2_10 = null;
            this._password.zero();
            this._keypassword.zero();
            throw throwable;
        }
    }

    public SunJsseListener() throws IOException {
    }

    public SunJsseListener(InetAddrPort p_address) throws IOException {
        super(p_address);
    }

    static {
        Security.addProvider((java.security.Provider)new Provider());
    }
}

