/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.servlet.ServletSSL;
import org.mortbay.util.Code;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Log;

public abstract class JsseListener
extends SocketListener {
    public static final String KEYSTORE_PROPERTY = "jetty.ssl.keystore";
    public static final String DEFAULT_KEYSTORE = System.getProperty("user.home") + File.separator + ".keystore";
    public static final String PASSWORD_PROPERTY = "jetty.ssl.password";
    public static final String KEYPASSWORD_PROPERTY = "jetty.ssl.keypassword";
    static final String CACHED_INFO_ATTR = (class$Lorg$mortbay$http$JsseListener$CachedInfo != null ? class$Lorg$mortbay$http$JsseListener$CachedInfo : (class$Lorg$mortbay$http$JsseListener$CachedInfo = JsseListener.class$("org.mortbay.http.JsseListener$CachedInfo"))).getName();
    private boolean _needClientAuth = false;
    private static /* synthetic */ Class class$Lorg$mortbay$http$JsseListener$CachedInfo;

    public void setNeedClientAuth(boolean needClientAuth) {
        this._needClientAuth = needClientAuth;
    }

    public String getDefaultScheme() {
        return "https";
    }

    protected abstract SSLServerSocketFactory createFactory() throws Exception;

    protected ServerSocket newServerSocket(InetAddrPort p_address, int p_acceptQueueSize) throws IOException {
        SSLServerSocketFactory factory = null;
        SSLServerSocket socket = null;
        try {
            factory = this.createFactory();
            socket = p_address == null ? (SSLServerSocket)factory.createServerSocket(0, p_acceptQueueSize) : (SSLServerSocket)factory.createServerSocket(p_address.getPort(), p_acceptQueueSize, p_address.getInetAddress());
            socket.setNeedClientAuth(this._needClientAuth);
            Log.event("JsseListener.needClientAuth=" + this._needClientAuth);
        }
        catch (Exception e) {
            Code.warning(e);
            throw new IOException("Could not create JsseListener: " + e.toString());
        }
        return socket;
    }

    /*
     * WARNING - void declaration
     */
    protected Socket accept(ServerSocket p_serverSocket) throws IOException {
        try {
            void e;
            SSLSocket s = (SSLSocket)p_serverSocket.accept();
            if (this.getMaxIdleTimeMs() > 0) {
                s.setSoTimeout(this.getMaxIdleTimeMs());
            }
            s.startHandshake();
            return e;
        }
        catch (SSLException e) {
            Code.warning(e);
            throw new IOException(e.getMessage());
        }
    }

    protected void customizeRequest(Socket socket, HttpRequest request) {
        super.customizeRequest(socket, request);
        if (!(socket instanceof SSLSocket)) {
            return;
        }
        try {
            java.security.cert.X509Certificate[] certs;
            Integer keySize;
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession sslSession = sslSocket.getSession();
            String cipherSuite = sslSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sslSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                keySize = cachedInfo.getKeySize();
                java.security.cert.X509Certificate[] x509CertificateArray = cachedInfo.getCerts();
            } else {
                keySize = new Integer(ServletSSL.deduceKeyLength(cipherSuite));
                certs = JsseListener.getCertChain(sslSession);
                cachedInfo = new CachedInfo(keySize, certs);
                sslSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (certs != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", certs);
            } else if (this._needClientAuth) {
                throw new HttpException(403);
            }
            request.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
            request.setAttribute("javax.servlet.request.key_size", keySize);
        }
        catch (Exception e) {
            Code.warning(e);
        }
    }

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sslSession) {
        try {
            X509Certificate[] javaxCerts = sslSession.getPeerCertificateChain();
            if (javaxCerts == null || javaxCerts.length == 0) {
                return null;
            }
            int length = javaxCerts.length;
            java.security.cert.X509Certificate[] javaCerts = new java.security.cert.X509Certificate[length];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            int i = 0;
            while (i < length) {
                byte[] bytes = javaxCerts[i].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
                ++i;
            }
            return javaCerts;
        }
        catch (SSLPeerUnverifiedException pue) {
            return null;
        }
        catch (Exception e) {
            Code.warning(e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JsseListener() throws IOException {
    }

    public JsseListener(InetAddrPort p_address) throws IOException {
        super(p_address);
        if (p_address.getPort() == 0) {
            p_address.setPort(443);
            this.setPort(443);
        }
    }

    private class CachedInfo {
        private Integer _keySize;
        private java.security.cert.X509Certificate[] _certs;

        Integer getKeySize() {
            return this._keySize;
        }

        java.security.cert.X509Certificate[] getCerts() {
            return this._certs;
        }

        CachedInfo(Integer keySize, java.security.cert.X509Certificate[] certs) {
            this._keySize = keySize;
            this._certs = certs;
        }
    }
}

