/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import org.mortbay.util.Code;

public class InclusiveByteRange {
    long first = 0L;
    long last = 0L;

    public long getFirst() {
        return this.first;
    }

    public long getLast() {
        return this.last;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List parseRangeHeaders(Enumeration rit) {
        ArrayList validRanges = new ArrayList();
        ArrayList<InclusiveByteRange> headerRanges = new ArrayList<InclusiveByteRange>();
        block2: while (rit.hasMoreElements()) {
            String header = (String)rit.nextElement();
            StringTokenizer tok = new StringTokenizer(header, "=,", false);
            headerRanges.clear();
            try {
                while (true) {
                    long last;
                    long first;
                    block11: {
                        if (!tok.hasMoreTokens()) {
                            validRanges.addAll(headerRanges);
                            continue block2;
                        }
                        String t = tok.nextToken().trim();
                        first = -1L;
                        last = -1L;
                        int d = t.indexOf(45);
                        if (d < 0 || t.indexOf("-", d + 1) >= 0) {
                            if ("bytes".equals(t)) continue;
                            Code.warning("Bad range format: " + t);
                            continue block2;
                        }
                        if (d == 0) {
                            if (d + 1 < t.length()) {
                                last = Long.parseLong(t.substring(d + 1).trim());
                                break block11;
                            } else {
                                Code.warning("Bad range format: " + t);
                                continue block2;
                            }
                        }
                        if (d + 1 < t.length()) {
                            first = Long.parseLong(t.substring(0, d).trim());
                            last = Long.parseLong(t.substring(d + 1).trim());
                        } else {
                            first = Long.parseLong(t.substring(0, d).trim());
                        }
                    }
                    if (first == -1L && last == -1L || first != -1L && last != -1L && first > last) continue block2;
                    InclusiveByteRange range = new InclusiveByteRange(first, last);
                    headerRanges.add(range);
                }
            }
            catch (Exception e) {
                Code.ignore(e);
            }
        }
        return validRanges;
    }

    public long getFirst(long size) {
        if (this.first < 0L) {
            long tf = size - this.last;
            if (tf < 0L) {
                tf = 0L;
            }
            return tf;
        }
        return this.first;
    }

    public long getLast(long size) {
        if (this.first < 0L) {
            return size - 1L;
        }
        if (this.last < 0L || this.last >= size) {
            return size - 1L;
        }
        return this.last;
    }

    public long getSize(long size) {
        return this.getLast(size) - this.getFirst(size) + 1L;
    }

    public String toHeaderRangeString(long size) {
        StringBuffer sb = new StringBuffer(40);
        sb.append("bytes ");
        sb.append(this.getFirst(size));
        sb.append('-');
        sb.append(this.getLast(size));
        sb.append("/");
        sb.append(size);
        return sb.toString();
    }

    public static String to416HeaderRangeString(long size) {
        StringBuffer sb = new StringBuffer(40);
        sb.append("bytes */");
        sb.append(size);
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(60);
        sb.append(Long.toString(this.first));
        sb.append(":");
        sb.append(Long.toString(this.last));
        return sb.toString();
    }

    public InclusiveByteRange(long first, long last) {
        this.first = first;
        this.last = last;
    }
}

