/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.mortbay.http.ChunkableInputStream;
import org.mortbay.http.ChunkableOutputStream;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpFields;
import org.mortbay.util.Code;

public abstract class HttpMessage {
    public static final int __MSG_EDITABLE = 0;
    public static final int __MSG_BAD = 1;
    public static final int __MSG_RECEIVED = 2;
    public static final int __MSG_SENDING = 3;
    public static final int __MSG_SENT = 4;
    public static final String[] __state = new String[]{"EDITABLE", "BAD", "RECEIVED", "SENDING", "SENT"};
    public static final String __HTTP_0_9 = "HTTP/0.9";
    public static final String __HTTP_1_0 = "HTTP/1.0";
    public static final String __HTTP_1_1 = "HTTP/1.1";
    public static final String __HTTP_1_X = "HTTP/1.";
    protected int _state = 0;
    protected String _version;
    protected int _dotVersion;
    protected HttpFields _header = new HttpFields();
    protected HttpFields _trailer;
    protected boolean _acceptTrailer;
    protected HttpConnection _connection;
    protected String _characterEncoding;
    protected String _mimeType;

    protected void reset() {
        this._state = 0;
        this._header = new HttpFields();
        this._trailer = null;
    }

    public HttpConnection getHttpConnection() {
        return this._connection;
    }

    public ChunkableInputStream getInputStream() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getInputStream();
    }

    public ChunkableOutputStream getOutputStream() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getOutputStream();
    }

    public int getState() {
        return this._state;
    }

    public int setState(int state) {
        int last = this._state;
        this._state = state;
        return last;
    }

    public String getVersion() {
        return this._version;
    }

    public int getDotVersion() {
        return this._dotVersion;
    }

    public Enumeration getFieldNames() {
        if (this._header != null && this._trailer == null) {
            return this._header.getFieldNames();
        }
        Enumeration e1 = this._header.getFieldNames();
        Enumeration e2 = this._trailer.getFieldNames();
        return new Enumeration(this, e1, e2){
            private final /* synthetic */ HttpMessage this$0;
            private final /* synthetic */ Enumeration val$e1;
            private final /* synthetic */ Enumeration val$e2;

            public boolean hasMoreElements() {
                return this.val$e1.hasMoreElements() || this.val$e2.hasMoreElements();
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.val$e1.hasMoreElements()) {
                    return this.val$e1.nextElement();
                }
                return this.val$e2.nextElement();
            }
            {
                this.val$e1 = val$e1;
                this.val$e2 = val$e2;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(HttpMessage httpMessage) {
            }
        };
    }

    public boolean containsField(String name) {
        boolean contains = this._header.containsKey(name);
        if (!contains && this._trailer != null) {
            contains = this._trailer.containsKey(name);
        }
        return contains;
    }

    public String getField(String name) {
        String field = this._header.get(name);
        if (field == null && this._trailer != null) {
            field = this._trailer.get(name);
        }
        return field;
    }

    public Enumeration getFieldValues(String name) {
        Enumeration enumeration = this._header.getValues(name);
        if (enumeration == null && this._trailer != null) {
            enumeration = this._trailer.getValues(name);
        }
        return enumeration;
    }

    public Enumeration getFieldValues(String name, String separators) {
        Enumeration enumeration = this._header.getValues(name, separators);
        if (enumeration == null && this._trailer != null) {
            enumeration = this._trailer.getValues(name, separators);
        }
        return enumeration;
    }

    protected HttpFields setFields() throws IllegalStateException {
        if (this._state == 0) {
            return this._header;
        }
        if (this._acceptTrailer && this._state == 3 && this._version.equals(__HTTP_1_1)) {
            if (this._trailer == null) {
                this._trailer = new HttpFields();
            }
            return this._trailer;
        }
        throw new IllegalStateException("Can't set fields in " + __state[this._state] + " for " + this._version);
    }

    public String setField(String name, String value) throws IllegalStateException {
        HttpFields fields = this.setFields();
        if ("Content-Type".equals(name)) {
            this.setMimeAndEncoding(value);
        }
        return fields.put(name, value);
    }

    protected void setMimeAndEncoding(String contentType) {
        int i0;
        this._characterEncoding = null;
        this._mimeType = contentType;
        if (contentType != null && (i0 = contentType.indexOf(59)) >= 0) {
            this._mimeType = contentType.substring(0, i0).trim();
            int i1 = contentType.indexOf("charset=", i0);
            if (i1 >= 0) {
                int i2 = contentType.indexOf(32, i1 += 8);
                this._characterEncoding = i2 > 0 ? contentType.substring(i1, i2) : contentType.substring(i1);
            }
        }
    }

    public void setField(String name, List value) throws IllegalStateException {
        HttpFields fields = this.setFields();
        fields.put(name, value);
    }

    public void addField(String name, String value) throws IllegalStateException {
        HttpFields fields = this.setFields();
        fields.add(name, value);
    }

    public int getIntField(String name) {
        int v = this._header.getIntField(name);
        if (v == -1 && this._trailer != null) {
            v = this._trailer.getIntField(name);
        }
        return v;
    }

    public void setIntField(String name, int value) throws IllegalStateException {
        this.setFields().put(name, Integer.toString(value));
    }

    public void addIntField(String name, int value) throws IllegalStateException {
        this.setFields().add(name, Integer.toString(value));
    }

    public long getDateField(String name) {
        long d = this._header.getDateField(name);
        if (d < 0L && this._trailer != null) {
            d = this._trailer.getDateField(name);
        }
        return d;
    }

    public void setDateField(String name, Date date) {
        this.setFields().putDateField(name, date);
    }

    public void addDateField(String name, Date date) {
        this.setFields().addDateField(name, date);
    }

    public void setDateField(String name, long date) {
        this.setFields().putDateField(name, date);
    }

    public void setCurrentTime(String name) {
        this.setFields().putCurrentTime(name);
    }

    public String removeField(String name) throws IllegalStateException {
        HttpFields fields = this.setFields();
        return fields.remove(name);
    }

    public void setVersion(String version) {
        if (this._state != 0) {
            throw new IllegalStateException(__state[this._state] + "is not EDITABLE");
        }
        if ((version = version.toUpperCase()).equals(__HTTP_1_1)) {
            this._dotVersion = 1;
            this._version = __HTTP_1_1;
        } else if (version.equals(__HTTP_1_0)) {
            this._dotVersion = 0;
            this._version = __HTTP_1_0;
        } else if (version.equals(__HTTP_0_9)) {
            this._dotVersion = -1;
            this._version = __HTTP_0_9;
        } else {
            throw new IllegalArgumentException("Unknown version");
        }
    }

    public HttpFields getHeader() {
        return this._header;
    }

    public HttpFields getTrailer() {
        if (this._acceptTrailer && this._trailer == null) {
            this._trailer = new HttpFields();
        }
        return this._trailer;
    }

    public void setAcceptTrailer(boolean acceptTrailer) {
        this._acceptTrailer = acceptTrailer;
    }

    public boolean acceptTrailer() {
        return this._acceptTrailer;
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public String getMimeType() {
        return this._mimeType;
    }

    public void recycle(HttpConnection connection) {
        this._state = 0;
        this._version = null;
        this._dotVersion = 0;
        this._header.clear();
        if (this._trailer != null) {
            this._trailer.destroy();
        }
        this._trailer = null;
        this._acceptTrailer = false;
        this._connection = connection;
        this._characterEncoding = null;
        this._mimeType = null;
    }

    public void destroy() {
        this.recycle(null);
        if (this._header != null) {
            this._header.destroy();
        }
        this._header = null;
        this._trailer = null;
    }

    public synchronized String toString() {
        StringWriter writer = new StringWriter();
        int save_state = this._state;
        try {
            try {
                this._state = 0;
                this.writeHeader(writer);
            }
            catch (IOException e) {
                Code.warning(e);
                Object var4_4 = null;
                this._state = save_state;
            }
            Object var4_3 = null;
            this._state = save_state;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this._state = save_state;
            throw throwable;
        }
        return writer.toString();
    }

    abstract void writeHeader(Writer var1) throws IOException;

    public synchronized void commitHeader() throws IOException {
        ChunkableOutputStream out = this.getOutputStream();
        if (out == null) {
            throw new IllegalStateException("No output stream");
        }
        this._connection.setupOutputStream();
        Writer writer = out.getRawWriter();
        this.writeHeader(writer);
        this._state = 3;
    }

    public synchronized void commit() throws IOException, IllegalStateException {
        if (this.isCommitted()) {
            return;
        }
        if (Code.verbose(99)) {
            Code.debug("commit from " + __state[this._state]);
        }
        ChunkableOutputStream out = this.getOutputStream();
        switch (this._state) {
            case 0: {
                this.commitHeader();
                out.flush();
                break;
            }
            case 1: {
                throw new IllegalStateException("BAD");
            }
            case 2: {
                throw new IllegalStateException("RECEIVED");
            }
            case 3: {
                out.flush();
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public boolean isCommitted() {
        ChunkableOutputStream out = this.getOutputStream();
        return out != null && out.isCommitted() || this._state == 3 || this._state == 4;
    }

    public boolean isDirty() {
        ChunkableOutputStream out = this.getOutputStream();
        return this._state != 0 || out != null && (out.isWritten() || out.isCommitted());
    }

    public synchronized void complete() throws IOException {
        ChunkableOutputStream out;
        if (!this.isCommitted()) {
            this.commit();
        }
        if ((out = this.getOutputStream()) != null && this._trailer != null && this._trailer.size() > 0 && out != null && out.isChunking()) {
            out.setTrailer(this._trailer);
        }
        this._state = 4;
    }

    protected HttpMessage() {
    }

    protected HttpMessage(HttpConnection connection) {
        this._connection = connection;
    }
}

