/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import org.mortbay.util.Code;
import org.mortbay.util.DateCache;
import org.mortbay.util.LineInput;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.SingletonList;
import org.mortbay.util.StringMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.UrlEncoded;

public class HttpFields {
    public static final String __CacheControl = "Cache-Control";
    public static final String __Connection = "Connection";
    public static final String __Date = "Date";
    public static final String __Pragma = "Pragma";
    public static final String __Trailer = "Trailer";
    public static final String __TransferEncoding = "Transfer-Encoding";
    public static final String __Upgrade = "Upgrade";
    public static final String __Via = "Via";
    public static final String __Warning = "Warning";
    public static final String __Allow = "Allow";
    public static final String __ContentEncoding = "Content-Encoding";
    public static final String __ContentLanguage = "Content-Language";
    public static final String __ContentLength = "Content-Length";
    public static final String __ContentLocation = "Content-Location";
    public static final String __ContentMD5 = "Content-MD5";
    public static final String __ContentRange = "Content-Range";
    public static final String __ContentType = "Content-Type";
    public static final String __Expires = "Expires";
    public static final String __LastModified = "Last-Modified";
    public static final String __Accept = "Accept";
    public static final String __AcceptCharset = "Accept-Charset";
    public static final String __AcceptEncoding = "Accept-Encoding";
    public static final String __AcceptLanguage = "Accept-Language";
    public static final String __Authorization = "Authorization";
    public static final String __Expect = "Expect";
    public static final String __Forwarded = "Forwarded";
    public static final String __From = "From";
    public static final String __Host = "Host";
    public static final String __IfMatch = "If-Match";
    public static final String __IfModifiedSince = "If-Modified-Since";
    public static final String __IfNoneMatch = "If-None-Match";
    public static final String __IfRange = "If-Range";
    public static final String __IfUnmodifiedSince = "If-Unmodified-Since";
    public static final String __KeepAlive = "keep-alive";
    public static final String __MaxForwards = "Max-Forwards";
    public static final String __ProxyAuthorization = "Proxy-Authorization";
    public static final String __Range = "Range";
    public static final String __RequestRange = "Request-Range";
    public static final String __Referer = "Referer";
    public static final String __TE = "TE";
    public static final String __UserAgent = "User-Agent";
    public static final String __AcceptRanges = "Accept-Ranges";
    public static final String __Age = "Age";
    public static final String __ETag = "ETag";
    public static final String __Location = "Location";
    public static final String __ProxyAuthenticate = "Proxy-Authenticate";
    public static final String __RetryAfter = "Retry-After";
    public static final String __Server = "Server";
    public static final String __ServletEngine = "Servlet-Engine";
    public static final String __Vary = "Vary";
    public static final String __WwwAuthenticate = "WWW-Authenticate";
    public static final String __Cookie = "Cookie";
    public static final String __SetCookie = "Set-Cookie";
    public static final String __SetCookie2 = "Set-Cookie2";
    public static final String __MimeVersion = "MIME-Version";
    public static final String __Identity = "identity";
    private static final StringMap __info = new StringMap(true);
    public static final String __Chunked = "chunked";
    public static final String __Close = "close";
    public static final String __TextHtml = "text/html";
    public static final String __MessageHttp = "message/http";
    public static final String __WwwFormUrlEncode = "application/x-www-form-urlencoded";
    public static final String __ExpectContinue = "100-continue";
    public static final String __separators = ", \t";
    public static final char[] __CRLF;
    public static final char[] __COLON;
    public static final DateCache __dateCache;
    public static final SimpleDateFormat __dateSend;
    private static final String[] __dateReceiveFmt;
    public static SimpleDateFormat[] __dateReceive;
    private static Float __one;
    private ArrayList _fields = new ArrayList(15);
    private int[] _index = new int[2 * FieldInfo.__hashCode];
    private static /* synthetic */ Class class$Lorg$mortbay$http$HttpFields$FieldInfo;

    private static FieldInfo getFieldInfo(String name) {
        FieldInfo info = (FieldInfo)__info.get(name);
        if (info == null) {
            info = new FieldInfo(name, false, false);
        }
        return info;
    }

    private static FieldInfo getFieldInfo(char[] name, int offset, int length) {
        Map.Entry entry = __info.getEntry(name, offset, length);
        if (entry == null) {
            return new FieldInfo(new String(name, offset, length), false, false);
        }
        return (FieldInfo)entry.getValue();
    }

    public int size() {
        return this._fields.size();
    }

    public Enumeration getFieldNames() {
        return new Enumeration(this){
            int i;
            Field f;
            private final /* synthetic */ HttpFields this$0;

            /*
             * Unable to fully structure code
             */
            public boolean hasMoreElements() {
                if (this.f == null) ** GOTO lbl7
                return true;
lbl-1000:
                // 1 sources

                {
                    t = (Field)HttpFields.access$0(this.this$0).get(this.i++);
                    if (t == null || t._prev != null) continue;
                    this.f = t;
                    return true;
lbl7:
                    // 2 sources

                    ** while (this.i < HttpFields.access$0((HttpFields)this.this$0).size())
                }
lbl8:
                // 1 sources

                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.f != null || this.hasMoreElements()) {
                    String n = this.f._info._name;
                    this.f = null;
                    return n;
                }
                throw new NoSuchElementException();
            }
            {
                this.this$0 = this$0;
                this.i = 0;
                this.f = null;
                this.constructor$0(this$0);
            }

            private final void constructor$0(HttpFields httpFields) {
            }
        };
    }

    public boolean containsKey(String name) {
        FieldInfo info = HttpFields.getFieldInfo(name);
        return this._index[info.hashCode()] >= 0;
    }

    public String get(String name) {
        FieldInfo info = HttpFields.getFieldInfo(name);
        if (this._index[info.hashCode()] >= 0) {
            Field field = (Field)this._fields.get(this._index[info.hashCode()]);
            return field._value;
        }
        return null;
    }

    public Enumeration getValues(String name) {
        FieldInfo info = HttpFields.getFieldInfo(name);
        if (this._index[info.hashCode()] >= 0) {
            Field field = (Field)this._fields.get(this._index[info.hashCode()]);
            return new Enumeration(this, field){
                Field f;
                private final /* synthetic */ HttpFields this$0;
                private final /* synthetic */ Field val$field;

                public boolean hasMoreElements() {
                    return this.f != null;
                }

                public Object nextElement() throws NoSuchElementException {
                    if (this.f == null) {
                        throw new NoSuchElementException();
                    }
                    Field n = this.f;
                    this.f = this.f._next;
                    return n._value;
                }
                {
                    this.val$field = val$field;
                    this.this$0 = this$0;
                    this.f = this.val$field;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(HttpFields httpFields) {
                }
            };
        }
        return null;
    }

    public Enumeration getValues(String name, String separators) {
        Enumeration e = this.getValues(name);
        if (e == null) {
            return null;
        }
        return new Enumeration(this, e, separators){
            QuotedStringTokenizer tok;
            private final /* synthetic */ HttpFields this$0;
            private final /* synthetic */ Enumeration val$e;
            private final /* synthetic */ String val$separators;

            /*
             * Unable to fully structure code
             */
            public boolean hasMoreElements() {
                if (this.tok == null || !this.tok.hasMoreElements()) ** GOTO lbl7
                return true;
lbl-1000:
                // 1 sources

                {
                    value = (String)this.val$e.nextElement();
                    this.tok = new QuotedStringTokenizer(value, this.val$separators, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
lbl7:
                    // 2 sources

                    ** while (this.val$e.hasMoreElements())
                }
lbl8:
                // 1 sources

                this.tok = null;
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                return this.tok.nextElement();
            }
            {
                this.val$e = val$e;
                this.val$separators = val$separators;
                this.this$0 = this$0;
                this.tok = null;
                this.constructor$0(this$0);
            }

            private final void constructor$0(HttpFields httpFields) {
            }
        };
    }

    public String put(String name, String value) {
        if (value == null) {
            return this.remove(name);
        }
        FieldInfo info = HttpFields.getFieldInfo(name);
        if (this._index[info.hashCode()] >= 0) {
            Field field = (Field)this._fields.get(this._index[info.hashCode()]);
            String old = field._value;
            field._value = value;
            Field last = field;
            field = last._next;
            last._next = null;
            while (field != null) {
                last = field;
                field = field._next;
                last.clear();
            }
            return old;
        }
        Field field = new Field(info, value);
        this._index[info.hashCode()] = this._fields.size();
        this._fields.add(field);
        return null;
    }

    public void put(String name, List value) {
        FieldInfo info = HttpFields.getFieldInfo(name);
        if (info._singleValued) {
            throw new IllegalArgumentException("Field " + name + " must be single valued");
        }
        if (this._index[info.hashCode()] >= 0) {
            Field field = (Field)this._fields.get(this._index[info.hashCode()]);
            while (field != null) {
                Field last = field;
                field = field._next;
                last.clear();
            }
        }
        Field last = null;
        Iterator iter = value.iterator();
        while (iter.hasNext()) {
            Field field = new Field(info, iter.next().toString());
            if (last == null) {
                this._index[info.hashCode()] = this._fields.size();
            } else {
                field._prev = last;
                last._next = field;
            }
            this._fields.add(field);
            last = field;
        }
    }

    public void add(String name, String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        FieldInfo info = HttpFields.getFieldInfo(name);
        Field last = null;
        if (this._index[info.hashCode()] >= 0) {
            if (info._singleValued) {
                throw new IllegalArgumentException("Field " + name + " must be single valued");
            }
            last = (Field)this._fields.get(this._index[info.hashCode()]);
            while (last._next != null) {
                last = last._next;
            }
        } else {
            this._index[info.hashCode()] = this._fields.size();
        }
        Field field = new Field(info, value);
        this._fields.add(field);
        if (last != null) {
            field._prev = last;
            last._next = field;
        }
    }

    public String remove(String name) {
        String old = null;
        FieldInfo info = HttpFields.getFieldInfo(name);
        if (this._index[info.hashCode()] >= 0) {
            Field field = (Field)this._fields.get(this._index[info.hashCode()]);
            this._fields.set(this._index[info.hashCode()], null);
            old = field._value;
            while (field != null) {
                Field last = field;
                field = field._next;
                last.clear();
            }
            this._index[info.hashCode()] = -1;
        }
        return old;
    }

    public int getIntField(String name) throws NumberFormatException {
        String val = HttpFields.valueParameters(this.get(name), null);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return -1;
    }

    public long getDateField(String name) {
        String val = HttpFields.valueParameters(this.get(name), null);
        if (val != null) {
            int i = 0;
            while (i < __dateReceive.length) {
                try {
                    Date date = (Date)__dateReceive[i].parseObject(val);
                    return date.getTime();
                }
                catch (Exception e) {
                    Code.ignore(e);
                    ++i;
                }
            }
            if (val.endsWith(" GMT")) {
                val = val.substring(0, val.length() - 4);
                i = 0;
                while (i < __dateReceive.length) {
                    try {
                        Code.debug((Object)"TRY ", val, (Object)" against ", __dateReceive[i].toPattern());
                        Date date = (Date)__dateReceive[i].parseObject(val);
                        Code.debug((Object)"GOT ", (Object)date);
                        return date.getTime();
                    }
                    catch (Exception e) {
                        Code.ignore(e);
                        ++i;
                    }
                }
            }
        }
        return -1L;
    }

    public void putIntField(String name, int value) {
        this.put(name, Integer.toString(value));
    }

    public void putDateField(String name, Date date) {
        this.put(name, __dateSend.format(date));
    }

    public void addDateField(String name, Date date) {
        this.add(name, __dateSend.format(date));
    }

    public void putDateField(String name, long date) {
        this.put(name, __dateSend.format(new Date(date)));
    }

    public void putCurrentTime(String name) {
        this.put(name, __dateCache.format(System.currentTimeMillis()));
    }

    /*
     * WARNING - void declaration
     */
    public void read(LineInput in) throws IOException {
        Field last = null;
        char[] buf = null;
        int size = 0;
        LineInput lineInput = in;
        synchronized (lineInput) {
            LineInput.LineBuffer line_buffer;
            while ((line_buffer = in.readLineBuffer()) != null) {
                void var5_6;
                buf = var5_6.buffer;
                size = var5_6.size;
                if (size == 0) break;
                int state = 0;
                int i1 = -1;
                int i2 = -1;
                int name_i = -1;
                int name_l = 0;
                int i = 0;
                while (i < var5_6.size) {
                    char c = buf[i];
                    switch (state) {
                        case 0: {
                            if (c == ' ' || c == '\t') {
                                state = 2;
                                break;
                            }
                            state = 1;
                            i1 = i;
                            i2 = i - 1;
                        }
                        case 1: {
                            if (c == ':') {
                                name_i = i1;
                                name_l = i2 - i1 + 1;
                                state = 2;
                                i1 = i;
                                i2 = i - 1;
                                break;
                            }
                            if (c == ' ' || c == '\t') break;
                            i2 = i;
                            break;
                        }
                        case 2: {
                            if (c == ' ' || c == '\t') break;
                            state = 3;
                            i1 = i;
                            i2 = i - 1;
                        }
                        case 3: {
                            if (c != ' ' && c != '\t') {
                                i2 = i;
                            } else {
                                break;
                            }
                        }
                    }
                    ++i;
                }
                if (name_i < 0 || name_l == 0) {
                    if (state < 2 || last == null) continue;
                    last._value = last._value + " " + new String(buf, i1, i2 - i1 + 1);
                    continue;
                }
                FieldInfo info = HttpFields.getFieldInfo(buf, name_i, name_l);
                Field field = new Field(info, new String(buf, i1, i2 - i1 + 1));
                if (this._index[info.hashCode()] < 0) {
                    this._index[info.hashCode()] = this._fields.size();
                } else {
                    if (info._singleValued) {
                        Code.warning("Ignored duplicate single value header: " + field);
                        continue;
                    }
                    Field link = (Field)this._fields.get(this._index[info.hashCode()]);
                    while (link._next != null) {
                        link = link._next;
                    }
                    field._prev = link;
                    link._next = field;
                }
                this._fields.add(field);
                last = field;
            }
        }
    }

    public void write(Writer writer) throws IOException {
        Writer writer2 = writer;
        synchronized (writer2) {
            int i = 0;
            while (i < this._fields.size()) {
                Field field = (Field)this._fields.get(i);
                if (field != null) {
                    field.write(writer);
                }
                ++i;
            }
            writer.write(__CRLF);
        }
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.write(writer);
            return writer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clear() {
        int i = this._fields.size();
        while (i-- > 0) {
            Field field = (Field)this._fields.get(i);
            if (field == null) continue;
            field.clear();
        }
        this._fields.clear();
        Arrays.fill(this._index, -1);
    }

    public void destroy() {
        this.clear();
        this._fields = null;
    }

    public static String valueParameters(String value, Map parameters) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(59);
        if (i < 0) {
            return value;
        }
        if (parameters == null) {
            return value.substring(0, i).trim();
        }
        QuotedStringTokenizer tok1 = new QuotedStringTokenizer(value.substring(i), ";", false, true);
        while (((StringTokenizer)tok1).hasMoreTokens()) {
            String token = ((StringTokenizer)tok1).nextToken();
            QuotedStringTokenizer tok2 = new QuotedStringTokenizer(token, "= ");
            if (!((StringTokenizer)tok2).hasMoreTokens()) continue;
            String paramName = ((StringTokenizer)tok2).nextToken();
            String paramVal = null;
            if (((StringTokenizer)tok2).hasMoreTokens()) {
                paramVal = ((StringTokenizer)tok2).nextToken();
            }
            parameters.put(paramName, paramVal);
        }
        return value.substring(0, i).trim();
    }

    public static Float getQuality(String value) {
        HashMap params = new HashMap(7);
        HttpFields.valueParameters(value, params);
        String qs = (String)params.get("q");
        Float q = __one;
        if (qs != null) {
            try {
                q = new Float(qs);
            }
            catch (Exception e) {
                q = __one;
            }
        }
        return q;
    }

    /*
     * Unable to fully structure code
     */
    public static List qualityList(Enumeration enum) {
        if (enum == null || !enum.hasMoreElements()) {
            return Collections.EMPTY_LIST;
        }
        value = null;
        quality = null;
        list = null;
        qual = null;
        while (enum.hasMoreElements()) {
            v = enum.nextElement().toString();
            q = HttpFields.getQuality(v);
            if (!((double)q.floatValue() >= 0.001)) continue;
            if (value == null) {
                value = v;
                quality = q;
                continue;
            }
            list = new LinkedList<String>();
            qual = new LinkedList<Float>();
            if (quality.floatValue() > q.floatValue()) {
                list.add(value);
                list.add(v);
                qual.add(quality);
                qual.add(q);
                break;
            }
            list.add(v);
            list.add(value);
            qual.add(q);
            qual.add(quality);
            break;
        }
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (list != null) ** GOTO lbl56
        return SingletonList.newSingletonList(value);
lbl-1000:
        // 1 sources

        {
            v = enum.nextElement().toString();
            q = HttpFields.getQuality(v);
            if ((double)q.floatValue() < 0.001) continue;
            vi = list.listIterator();
            qi = qual.listIterator();
            while (vi.hasNext()) {
                cv = (String)vi.next();
                cq = (Float)qi.next();
                if (!(cq.floatValue() < q.floatValue())) continue;
                qi.previous();
                vi.previous();
                break;
            }
            vi.add(v);
            qi.add(q);
lbl56:
            // 3 sources

            ** while (enum.hasMoreElements())
        }
lbl57:
        // 1 sources

        qual.clear();
        return list;
    }

    public void addSetCookie(Cookie cookie, boolean cookie2) {
        String name = cookie.getName();
        String value = cookie.getValue();
        int version = cookie.getVersion();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuffer buf = new StringBuffer(128);
        String name_value_params = null;
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            long maxAge;
            String domain;
            String path;
            buf.append(name);
            if (value != null && value.length() > 0) {
                buf.append('=');
                buf.append(UrlEncoded.encodeString(value));
            }
            if (version > 0) {
                buf.append(";Version=");
                buf.append(version);
                String comment = cookie.getComment();
                if (comment != null && comment.length() > 0) {
                    buf.append(";Comment=\"");
                    buf.append(comment);
                    buf.append('\"');
                }
            }
            if ((path = cookie.getPath()) != null && path.length() > 0) {
                buf.append(";Path=");
                buf.append(path);
            }
            if ((domain = cookie.getDomain()) != null && domain.length() > 0) {
                buf.append(";Domain=");
                buf.append(domain.toLowerCase());
            }
            if ((maxAge = (long)cookie.getMaxAge()) >= 0L) {
                if (version == 0) {
                    buf.append(";Expires=");
                    buf.append(__dateSend.format(new Date(System.currentTimeMillis() + 1000L * maxAge)));
                } else {
                    buf.append(";Max-Age=");
                    buf.append(cookie.getMaxAge());
                }
            } else if (version > 0) {
                buf.append(";Discard");
            }
            if (cookie.getSecure()) {
                buf.append(";secure");
            }
            name_value_params = buf.toString();
        }
        this.add(cookie2 ? __SetCookie2 : __SetCookie, name_value_params);
    }

    static /* synthetic */ ArrayList access$0(HttpFields httpFields) {
        return httpFields._fields;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public HttpFields() {
        Arrays.fill(this._index, -1);
    }

    static {
        new FieldInfo(__Host, true, false);
        new FieldInfo(__KeepAlive, false, false);
        new FieldInfo(__Connection, false, false);
        new FieldInfo(__Cookie, false, false);
        new FieldInfo(__Accept, false, false);
        new FieldInfo(__AcceptLanguage, false, false);
        new FieldInfo(__AcceptEncoding, false, false);
        new FieldInfo(__AcceptCharset, false, false);
        new FieldInfo(__CacheControl, false, false);
        new FieldInfo(__SetCookie, false, false);
        new FieldInfo(__SetCookie2, false, false);
        new FieldInfo(__Date, true, false);
        new FieldInfo(__TransferEncoding, false, true);
        new FieldInfo(__ContentEncoding, false, true);
        new FieldInfo(__ContentLength, true, false);
        new FieldInfo(__Expires, true, false);
        new FieldInfo(__Expect, true, false);
        new FieldInfo(__Referer, true, false);
        new FieldInfo(__TE, false, false);
        new FieldInfo(__UserAgent, true, false);
        new FieldInfo(__IfModifiedSince, true, false);
        new FieldInfo(__IfRange, true, false);
        new FieldInfo(__IfUnmodifiedSince, true, false);
        new FieldInfo(__Location, true, false);
        new FieldInfo(__Server, true, false);
        new FieldInfo(__ServletEngine, false, false);
        new FieldInfo(__AcceptRanges, false, false);
        new FieldInfo(__Range, true, false);
        new FieldInfo(__RequestRange, true, false);
        new FieldInfo(__ContentLocation, true, false);
        new FieldInfo(__ContentMD5, true, false);
        new FieldInfo(__ContentRange, true, false);
        new FieldInfo(__ContentType, true, false);
        new FieldInfo(__LastModified, true, false);
        new FieldInfo(__Authorization, true, false);
        new FieldInfo(__From, true, false);
        new FieldInfo(__MaxForwards, true, false);
        new FieldInfo(__ProxyAuthenticate, true, false);
        new FieldInfo(__Age, true, false);
        new FieldInfo(__ETag, true, false);
        new FieldInfo(__RetryAfter, true, false);
        __CRLF = new char[]{'\r', '\n'};
        __COLON = new char[]{':', ' '};
        __dateCache = new DateCache("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        __dateSend = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        __dateReceiveFmt = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss", "EEE dd MMM yyyy HH:mm:ss zzz", "EEE dd MMM yyyy HH:mm:ss", "EEE MMM dd yyyy HH:mm:ss zzz", "EEE MMM dd yyyy HH:mm:ss", "EEE MMM-dd-yyyy HH:mm:ss zzz", "EEE MMM-dd-yyyy HH:mm:ss", "dd MMM yyyy HH:mm:ss zzz", "dd MMM yyyy HH:mm:ss", "dd-MMM-yy HH:mm:ss zzz", "dd-MMM-yy HH:mm:ss", "MMM dd HH:mm:ss yyyy zzz", "MMM dd HH:mm:ss yyyy", "EEE MMM dd HH:mm:ss yyyy zzz", "EEE MMM dd HH:mm:ss yyyy", "EEE, MMM dd HH:mm:ss yyyy zzz", "EEE, MMM dd HH:mm:ss yyyy", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss", "EEE dd-MMM-yy HH:mm:ss zzz", "EEE dd-MMM-yy HH:mm:ss"};
        TimeZone tz = TimeZone.getTimeZone("GMT");
        tz.setID("GMT");
        __dateSend.setTimeZone(tz);
        __dateCache.setTimeZone(tz);
        __dateReceive = new SimpleDateFormat[__dateReceiveFmt.length];
        int i = 0;
        while (i < __dateReceive.length) {
            HttpFields.__dateReceive[i] = new SimpleDateFormat(__dateReceiveFmt[i], Locale.US);
            __dateReceive[i].setTimeZone(tz);
            ++i;
        }
        __one = new Float("1.0");
    }

    private static class FieldInfo {
        static int __hashCode;
        String _name;
        String _lname;
        boolean _singleValued;
        boolean _inlineValues;
        int _hashCode;

        public String toString() {
            return "[" + this._name + "," + this._singleValued + "," + this._inlineValues + "]";
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object o) {
            return o instanceof FieldInfo && ((FieldInfo)o)._hashCode == this._hashCode;
        }

        FieldInfo(String name, boolean single, boolean inline) {
            Class clazz;
            if (class$Lorg$mortbay$http$HttpFields$FieldInfo != null) {
                clazz = class$Lorg$mortbay$http$HttpFields$FieldInfo;
            } else {
                Class clazz2 = HttpFields.class$("org.mortbay.http.HttpFields$FieldInfo");
                clazz = clazz2;
                class$Lorg$mortbay$http$HttpFields$FieldInfo = clazz2;
            }
            Class clazz3 = clazz;
            synchronized (clazz3) {
                this._name = name;
                this._lname = StringUtil.asciiToLowerCase(name);
                this._singleValued = single;
                this._inlineValues = inline;
                __info.put(name, this);
                if (!name.equals(this._lname)) {
                    __info.put(this._lname, this);
                }
                this._hashCode = __hashCode++;
            }
        }
    }

    private static class Field {
        FieldInfo _info;
        String _value;
        Field _next;
        Field _prev;

        public boolean equals(Object o) {
            return o instanceof Field && ((Field)o)._info == this._info;
        }

        void clear() {
            this._info = null;
            this._value = null;
            this._next = null;
            this._prev = null;
        }

        public void write(Writer writer) throws IOException {
            if (this._info == null) {
                return;
            }
            if (this._info._inlineValues) {
                if (this._prev != null) {
                    return;
                }
                writer.write(this._info._name);
                writer.write(__COLON);
                Field f = this;
                while (true) {
                    writer.write(QuotedStringTokenizer.quote(f._value, HttpFields.__separators));
                    f = f._next;
                    if (f == null) break;
                    writer.write(",");
                }
                writer.write(__CRLF);
            } else {
                writer.write(this._info._name);
                writer.write(__COLON);
                writer.write(this._value);
                writer.write(__CRLF);
            }
        }

        public String toString() {
            return (this._prev == null ? "[" : "[" + this._prev._info._name + "<- ") + this._info._name + __COLON + this._value + (this._next == null ? "]" : " ->" + this._next._info._name + "]");
        }

        Field(FieldInfo info, String value) {
            this._info = info;
            this._value = value;
            this._next = null;
            this._prev = null;
        }
    }
}

