/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mortbay.http.ChunkableInputStream;
import org.mortbay.http.ChunkableOutputStream;
import org.mortbay.http.HandlerContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.OutputObserver;
import org.mortbay.http.Version;
import org.mortbay.util.Code;
import org.mortbay.util.StringUtil;

public class HttpConnection
implements OutputObserver {
    private HttpListener _listener;
    private ChunkableInputStream _inputStream;
    private ChunkableOutputStream _outputStream;
    private boolean _persistent;
    private boolean _close;
    private boolean _keepAlive;
    private String _version;
    private int _dotVersion;
    private boolean _outputSetup;
    private HttpRequest _request;
    private HttpResponse _response;
    private Thread _handlingThread;
    private InetAddress _remoteAddr;
    private String _remoteHost;
    private HttpServer _httpServer;
    private Object _connection;
    private HashMap _codingParams;
    private ArrayList _codings;
    private boolean _statsOn;
    private long _tmpTime;
    private long _openTime;
    private long _reqTime;
    private int _requests;
    private Object _object;

    public InetAddress getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        if (this._remoteHost == null) {
            if (this._remoteAddr == null) {
                return "127.0.0.1";
            }
            this._remoteHost = this._remoteAddr.getHostAddress();
        }
        return this._remoteHost;
    }

    public ChunkableInputStream getInputStream() {
        return this._inputStream;
    }

    public ChunkableOutputStream getOutputStream() {
        return this._outputStream;
    }

    public Object getConnection() {
        return this._connection;
    }

    public HttpRequest getRequest() {
        return this._request;
    }

    public HttpResponse getResponse() {
        return this._response;
    }

    public void forceClose() {
        this._persistent = false;
        this._close = true;
    }

    public void close() throws IOException {
        try {
            this._outputStream.close();
            this._inputStream.close();
        }
        finally {
            Object var2_1 = null;
            if (this._handlingThread != null) {
                this._handlingThread.interrupt();
            }
        }
    }

    public HttpListener getListener() {
        return this._listener;
    }

    public HttpServer getHttpServer() {
        return this._httpServer;
    }

    public String getDefaultScheme() {
        return this._listener.getDefaultScheme();
    }

    public String getHost() {
        return this._listener.getHost();
    }

    public int getPort() {
        return this._listener.getPort();
    }

    public Object getObject() {
        return this._object;
    }

    public void setObject(Object o) {
        this._object = o;
    }

    private void verifyHTTP_1_0() throws HttpException, IOException {
        int content_length = this._request.getIntField("Content-Length");
        if (content_length >= 0) {
            this._inputStream.setContentLength(content_length);
        } else if (content_length < 0) {
            this._inputStream.setContentLength(0);
        }
        this._persistent = this._keepAlive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyHTTP_1_1() throws HttpException, IOException {
        String host = this._request.getField("Host");
        if (host == null || host.length() == 0) {
            throw new HttpException(HttpResponse.__400_Bad_Request);
        }
        Enumeration transfer_coding = this._request.getFieldValues("Transfer-Encoding", ", \t");
        boolean input_encodings = false;
        if (transfer_coding != null) {
            if (this._codingParams == null) {
                this._codingParams = new HashMap(7);
                this._codings = new ArrayList(4);
            } else {
                this._codingParams.clear();
                this._codings.clear();
            }
            while (transfer_coding.hasMoreElements()) {
                this._codings.add(transfer_coding.nextElement());
            }
            int i = this._codings.size();
            while (i-- > 0) {
                String value = this._codings.get(i).toString();
                String coding = HttpFields.valueParameters(value, this._codingParams);
                if ("identity".equalsIgnoreCase(coding)) continue;
                input_encodings = true;
                if ("chunked".equalsIgnoreCase(coding)) {
                    if (i + 1 < this._codings.size() || this._codingParams.size() > 0) {
                        throw new HttpException(400);
                    }
                    this._inputStream.setChunking();
                    continue;
                }
                this.getHttpServer().getHttpEncoding().enableEncoding(this._inputStream, coding, (Map)this._codingParams);
            }
        }
        int content_length = this._request.getIntField("Content-Length");
        String content_type = this._request.getField("Content-Type");
        if (input_encodings) {
            if (!this._inputStream.isChunking()) {
                throw new HttpException(HttpResponse.__400_Bad_Request);
            }
        } else if (content_length >= 0) {
            this._inputStream.setContentLength(content_length);
        } else if (content_type == null || content_type.length() == 0) {
            this._inputStream.setContentLength(0);
        } else {
            this._inputStream.setContentLength(0);
        }
        String expect = this._request.getField("Expect");
        if (expect != null && expect.length() > 0) {
            if (!StringUtil.asciiToLowerCase(expect).equals("100-continue")) throw new HttpException(HttpResponse.__417_Expectation_Failed);
            if (this._inputStream.available() <= 0) {
                this._outputStream.getRawStream().write(HttpResponse.__Continue);
                this._outputStream.getRawStream().flush();
            }
        } else if (this._inputStream.available() <= 0 && (HttpRequest.__PUT.equals(this._request.getMethod()) || HttpRequest.__POST.equals(this._request.getMethod()))) {
            this._outputStream.getRawStream().write(HttpResponse.__Continue);
            this._outputStream.getRawStream().flush();
        }
        this._persistent = !this._close;
    }

    public void outputNotify(ChunkableOutputStream out, int action) throws IOException {
        if (this._response == null) {
            return;
        }
        switch (action) {
            case 0: {
                if (this._outputSetup) break;
                this.setupOutputStream();
                break;
            }
            case 1: {
                this._outputSetup = false;
                break;
            }
            case 2: {
                if (this._response.getState() != 0) break;
                this._response.commitHeader();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this._response.complete();
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public void setupOutputStream() throws IOException {
        block19: {
            Enumeration transfer_coding;
            block18: {
                if (this._outputSetup) {
                    return;
                }
                this._outputSetup = true;
                transfer_coding = this._response.getFieldValues("Transfer-Encoding", ", \t");
                if (transfer_coding != null && transfer_coding.hasMoreElements()) break block18;
                switch (this._dotVersion) {
                    case 1: {
                        if (this._listener.getHttpServer().isChunkingForced() || !"close".equals(this._response.getField("Connection")) && this._response.getField("Content-Length") == null) {
                            this._response.removeField("Content-Length");
                            this._response.setField("Transfer-Encoding", "chunked");
                            this._outputStream.setChunking();
                            break;
                        }
                        break block19;
                    }
                    case 0: {
                        if (!this._keepAlive || !this._persistent || 304 != this._response.getStatus() && this._response.getField("Content-Length") == null || "close".equals(this._response.getField("Connection"))) {
                            this._persistent = false;
                            if (this._keepAlive) {
                                this._response.setField("Connection", "close");
                            }
                            this._keepAlive = false;
                            break;
                        }
                        if (this._keepAlive) {
                            this._response.setField("Connection", "keep-alive");
                            break;
                        }
                        break block19;
                    }
                    default: {
                        this._keepAlive = false;
                        this._persistent = false;
                    }
                }
                break block19;
            }
            if (this._dotVersion < 1) {
                this._response.removeField("Transfer-Encoding");
                throw new HttpException(HttpResponse.__501_Not_Implemented, "Transfer-Encoding not supported in HTTP/1.0");
            }
            this._response.removeField("Content-Length");
            if (this._codingParams == null) {
                this._codingParams = new HashMap(7);
                this._codings = new ArrayList(4);
            } else {
                this._codingParams.clear();
                this._codings.clear();
            }
            while (transfer_coding.hasMoreElements()) {
                this._codings.add(transfer_coding.nextElement());
            }
            int i = this._codings.size();
            while (i-- > 0) {
                String value = this._codings.get(i).toString();
                String coding = HttpFields.valueParameters(value, this._codingParams);
                if ("identity".equalsIgnoreCase(coding) || "identity".equalsIgnoreCase(coding)) continue;
                if ("chunked".equalsIgnoreCase(coding)) {
                    if (i + 1 < this._codings.size() || this._codingParams.size() > 0) {
                        throw new HttpException(HttpResponse.__400_Bad_Request, "Missing or incorrect chunked transfer-encoding");
                    }
                    this._outputStream.setChunking();
                    continue;
                }
                List te = this._request.getAcceptableTransferCodings();
                if (te == null || !te.contains(coding)) {
                    throw new HttpException(HttpResponse.__501_Not_Implemented, "User agent does not accept " + coding + " transfer-encoding");
                }
                this.getHttpServer().getHttpEncoding().enableEncoding(this._outputStream, coding, (Map)this._codingParams);
            }
        }
        if (HttpRequest.__HEAD.equals(this._request.getMethod())) {
            this._outputStream.nullOutput();
        }
    }

    void commitResponse() throws IOException {
        this._outputSetup = true;
        boolean bl = this._close = "close".equals(this._response.getField("Connection")) || this._listener.isOutOfResources();
        if (this._close) {
            this._persistent = false;
        }
        if (!(this._outputStream.isWritten() || this._response.containsField("Transfer-Encoding") || this._response.containsField("Content-Length"))) {
            if (this._persistent) {
                switch (this._dotVersion) {
                    case 0: {
                        this._close = true;
                        this._persistent = false;
                        this._response.setField("Connection", "close");
                        break;
                    }
                    case 1: {
                        this._response.setField("Transfer-Encoding", "chunked");
                        this._outputStream.setChunking();
                        break;
                    }
                    default: {
                        this._close = true;
                        this._response.setField("Connection", "close");
                        break;
                    }
                }
            } else {
                this._close = true;
                this._response.setField("Connection", "close");
            }
        }
    }

    private void exception(Throwable e) {
        try {
            boolean gotIOException = false;
            if (e instanceof HttpException) {
                if (this._request == null) {
                    Code.warning(e.toString());
                } else {
                    Code.warning(this._request.getRequestLine() + " " + e.toString());
                }
                Code.debug(e);
            } else if (e instanceof IOException) {
                gotIOException = true;
                if (Code.verbose()) {
                    Code.debug(e);
                } else if (Code.debug()) {
                    Code.debug(e.toString());
                }
            } else if (this._request == null) {
                Code.warning(e);
            } else {
                Code.warning(this._request.getRequestLine(), e);
            }
            this._persistent = false;
            if (this._response != null && !this._response.isCommitted()) {
                this._response.reset();
                this._response.removeField("Transfer-Encoding");
                this._response.setField("Connection", "close");
                this._response.sendError(500, e);
                if (gotIOException) {
                    if (this._request == null) {
                        Code.warning(e);
                    } else {
                        Code.warning(this._request.getRequestLine(), e);
                    }
                }
            }
        }
        catch (Exception ex) {
            Code.ignore(ex);
        }
    }

    protected HandlerContext service(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (this._httpServer == null) {
            throw new HttpException(HttpResponse.__503_Service_Unavailable);
        }
        return this._httpServer.service(request, response);
    }

    public void handle() {
        while (this.handleNext()) {
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleNext() {
        block152: {
            block162: {
                block143: {
                    block144: {
                        block151: {
                            block161: {
                                block141: {
                                    block142: {
                                        block150: {
                                            block160: {
                                                block139: {
                                                    block140: {
                                                        block149: {
                                                            block159: {
                                                                block137: {
                                                                    block138: {
                                                                        block148: {
                                                                            block158: {
                                                                                block156: {
                                                                                    block157: {
                                                                                        block136: {
                                                                                            block147: {
                                                                                                block155: {
                                                                                                    block153: {
                                                                                                        block154: {
                                                                                                            block135: {
                                                                                                                block145: {
                                                                                                                    block133: {
                                                                                                                        block134: {
                                                                                                                            this._handlingThread = Thread.currentThread();
                                                                                                                            context = null;
                                                                                                                            try {
                                                                                                                                try {
                                                                                                                                    block131: {
                                                                                                                                        block132: {
                                                                                                                                            if (this._request != null) {
                                                                                                                                                this._request.recycle(this);
                                                                                                                                                if (this._response != null) {
                                                                                                                                                    this._response.recycle(this);
                                                                                                                                                } else {
                                                                                                                                                    this._response = new HttpResponse(this);
                                                                                                                                                }
                                                                                                                                            } else {
                                                                                                                                                this._request = new HttpRequest(this);
                                                                                                                                                this._response = new HttpResponse(this);
                                                                                                                                            }
                                                                                                                                            this._persistent = false;
                                                                                                                                            this._close = false;
                                                                                                                                            this._keepAlive = false;
                                                                                                                                            this._dotVersion = 0;
                                                                                                                                            Code.debug("Wait for request header...");
                                                                                                                                            try {
                                                                                                                                                this._outputSetup = false;
                                                                                                                                                this._request.readHeader(this.getInputStream());
                                                                                                                                                this._listener.customizeRequest(this, this._request);
                                                                                                                                                break block131;
                                                                                                                                            }
                                                                                                                                            catch (HttpException e) {
                                                                                                                                                throw e;
                                                                                                                                            }
                                                                                                                                            catch (IOException e) {
                                                                                                                                                if (this._request.getState() == 2) break block132;
                                                                                                                                                if (Code.debug()) {
                                                                                                                                                    if (Code.verbose()) {
                                                                                                                                                        Code.debug(e);
                                                                                                                                                    } else {
                                                                                                                                                        Code.debug(e.toString());
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                this._persistent = false;
                                                                                                                                                this._response.destroy();
                                                                                                                                                this._response = null;
                                                                                                                                                var4_15 = this._persistent;
                                                                                                                                                var3_17 = null;
                                                                                                                                                content_length = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                                                                                                                bytes_written = 0;
                                                                                                                                                if (!this._persistent) break block133;
                                                                                                                                                try {
                                                                                                                                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                catch (IOException e) {
                                                                                                                                                    if (this._inputStream.getContentLength() > 0) {
                                                                                                                                                        this._inputStream.setContentLength(0);
                                                                                                                                                    }
                                                                                                                                                    this._persistent = false;
                                                                                                                                                    this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            if (this._inputStream.getContentLength() <= 0) break block134;
                                                                                                                                            this._inputStream.setContentLength(0);
                                                                                                                                            this._persistent = false;
                                                                                                                                            this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                                                                                                                                            break block134;
                                                                                                                                        }
                                                                                                                                        this.exception(e);
                                                                                                                                        this._persistent = false;
                                                                                                                                        this._response.destroy();
                                                                                                                                        this._response = null;
                                                                                                                                        var4_16 = this._persistent;
                                                                                                                                        break block135;
                                                                                                                                    }
                                                                                                                                    if (this._request.getState() != 2) {
                                                                                                                                        throw new HttpException(HttpResponse.__400_Bad_Request);
                                                                                                                                    }
                                                                                                                                    if (this._statsOn) {
                                                                                                                                        ++this._requests;
                                                                                                                                        this._reqTime = this._tmpTime = System.currentTimeMillis();
                                                                                                                                        this._httpServer.statsGotRequest();
                                                                                                                                    }
                                                                                                                                    if (Code.debug()) {
                                                                                                                                        this._response.setField("Jetty-Request", this._request.getRequestLine());
                                                                                                                                        Code.debug((Object)"REQUEST:\n", (Object)this._request);
                                                                                                                                    }
                                                                                                                                    this._version = this._request.getVersion();
                                                                                                                                    this._dotVersion = this._request.getDotVersion();
                                                                                                                                    if (this._dotVersion > 1) {
                                                                                                                                        Code.debug("Respond to HTTP/1.X with HTTP/1.1");
                                                                                                                                        this._version = "HTTP/1.1";
                                                                                                                                        this._dotVersion = 1;
                                                                                                                                    }
                                                                                                                                    this._response.setVersion(this._version);
                                                                                                                                    this._response.setCurrentTime("Date");
                                                                                                                                    this._response.setField("Server", Version.__VersionDetail);
                                                                                                                                    this._response.setField("Servlet-Engine", Version.__ServletEngine);
                                                                                                                                    connectionValues = this._request.getFieldValues("Connection", ", \t");
                                                                                                                                    if (connectionValues != null) {
                                                                                                                                        while (connectionValues.hasMoreElements()) {
                                                                                                                                            token = connectionValues.nextElement().toString();
                                                                                                                                            if (token.equalsIgnoreCase("close")) {
                                                                                                                                                this._close = true;
                                                                                                                                                this._response.setField("Connection", "close");
                                                                                                                                            } else if (token.equalsIgnoreCase("keep-alive") && this._dotVersion == 0) {
                                                                                                                                                this._keepAlive = true;
                                                                                                                                            }
                                                                                                                                            if (this._dotVersion != 0) continue;
                                                                                                                                            this._request.forceRemoveField(token);
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    if (this._dotVersion == 1) {
                                                                                                                                        this.verifyHTTP_1_1();
                                                                                                                                    } else if (this._dotVersion == 0) {
                                                                                                                                        this.verifyHTTP_1_0();
                                                                                                                                    } else if (this._dotVersion != -1) {
                                                                                                                                        throw new HttpException(HttpResponse.__505_HTTP_Version_Not_Supported);
                                                                                                                                    }
                                                                                                                                    if (Code.verbose(99)) {
                                                                                                                                        Code.debug("IN is " + (this._inputStream.isChunking() != false ? "chunked" : "not chunked") + " Content-Length=" + this._inputStream.getContentLength());
                                                                                                                                    }
                                                                                                                                    context = this.service(this._request, this._response);
                                                                                                                                    break block136;
                                                                                                                                }
                                                                                                                                catch (InterruptedIOException e) {
                                                                                                                                    this.exception(e);
                                                                                                                                    this._persistent = false;
                                                                                                                                    try {
                                                                                                                                        this._response.commit();
                                                                                                                                        this._outputStream.flush();
                                                                                                                                    }
                                                                                                                                    catch (IOException e2) {
                                                                                                                                        this.exception(e2);
                                                                                                                                    }
                                                                                                                                    var3_20 = null;
                                                                                                                                    content_length = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                                                                                                    bytes_written = 0;
                                                                                                                                    if (!this._persistent) break block137;
                                                                                                                                    ** try [egrp 4[TRYBLOCK] [7 : 801->832)] { 
lbl130:
                                                                                                                                    // 2 sources

                                                                                                                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                                                                                    }
                                                                                                                                    break block138;
lbl133:
                                                                                                                                    // 1 sources

                                                                                                                                    catch (IOException e) {
                                                                                                                                        if (this._inputStream.getContentLength() > 0) {
                                                                                                                                            this._inputStream.setContentLength(0);
                                                                                                                                        }
                                                                                                                                        this._persistent = false;
                                                                                                                                        this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                                                                                                                                        break block138;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                catch (Exception e) {
                                                                                                                                    this.exception(e);
                                                                                                                                    var3_21 = null;
                                                                                                                                    content_length = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                                                                                                    bytes_written = 0;
                                                                                                                                    if (!this._persistent) break block139;
                                                                                                                                    ** try [egrp 4[TRYBLOCK] [7 : 801->832)] { 
lbl147:
                                                                                                                                    // 2 sources

                                                                                                                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                                                                                    }
                                                                                                                                    break block140;
lbl150:
                                                                                                                                    // 1 sources

                                                                                                                                    catch (IOException e) {
                                                                                                                                        if (this._inputStream.getContentLength() > 0) {
                                                                                                                                            this._inputStream.setContentLength(0);
                                                                                                                                        }
                                                                                                                                        this._persistent = false;
                                                                                                                                        this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                                                                                                                                        break block140;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                catch (Error e) {
                                                                                                                                    this.exception(e);
                                                                                                                                    var3_22 = null;
                                                                                                                                    content_length = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                                                                                                    bytes_written = 0;
                                                                                                                                    if (!this._persistent) break block141;
                                                                                                                                    ** try [egrp 4[TRYBLOCK] [7 : 801->832)] { 
lbl164:
                                                                                                                                    // 2 sources

                                                                                                                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                                                                                    }
                                                                                                                                    break block142;
lbl167:
                                                                                                                                    // 1 sources

                                                                                                                                    catch (IOException e) {
                                                                                                                                        if (this._inputStream.getContentLength() > 0) {
                                                                                                                                            this._inputStream.setContentLength(0);
                                                                                                                                        }
                                                                                                                                        this._persistent = false;
                                                                                                                                        this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                                                                                                                                        break block142;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                            catch (Throwable var2_40) {
                                                                                                                                var3_23 = null;
                                                                                                                                content_length = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                                                                                                bytes_written = 0;
                                                                                                                                if (!this._persistent) break block143;
                                                                                                                                ** try [egrp 4[TRYBLOCK] [7 : 801->832)] { 
lbl180:
                                                                                                                                // 2 sources

                                                                                                                                while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                                                                                }
                                                                                                                                break block144;
lbl183:
                                                                                                                                // 1 sources

                                                                                                                                catch (IOException e) {
                                                                                                                                    if (this._inputStream.getContentLength() > 0) {
                                                                                                                                        this._inputStream.setContentLength(0);
                                                                                                                                    }
                                                                                                                                    this._persistent = false;
                                                                                                                                    this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                                                                                                                                    break block144;
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                        try {
                                                                                                                            this._outputStream.flush(this._outputStream.isChunking());
                                                                                                                            bytes_written = this._outputStream.getBytesWritten();
                                                                                                                            this._outputStream.resetStream();
                                                                                                                            this._inputStream.resetStream();
                                                                                                                        }
                                                                                                                        catch (IOException e) {
                                                                                                                            this.exception(e);
                                                                                                                        }
                                                                                                                        break block145;
                                                                                                                    }
                                                                                                                    try {
                                                                                                                        if (this._response != null) {
                                                                                                                            this._response.commit();
                                                                                                                        }
                                                                                                                        this._outputStream.flush();
                                                                                                                        bytes_written = this._outputStream.getBytesWritten();
                                                                                                                        this._outputStream.close();
                                                                                                                    }
                                                                                                                    catch (IOException e) {
                                                                                                                        this.exception(e);
                                                                                                                    }
                                                                                                                }
                                                                                                                if (this._response != null) {
                                                                                                                    Code.debug((Object)"RESPONSE:\n", (Object)this._response);
                                                                                                                    if (this._persistent && content_length >= 0 && bytes_written > 0 && content_length != bytes_written) {
                                                                                                                        Code.warning("Invalid length: Content-Length=" + content_length + " bytes written=" + bytes_written + " for " + this._request.getRequestURL());
                                                                                                                        this._persistent = false;
                                                                                                                        try {
                                                                                                                            this._outputStream.close();
                                                                                                                        }
                                                                                                                        catch (IOException e) {
                                                                                                                            Code.warning(e);
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                                if (this._statsOn && this._reqTime > 0L) {
                                                                                                                    this._httpServer.statsEndRequest(System.currentTimeMillis() - this._reqTime, this._response != null);
                                                                                                                    this._reqTime = 0L;
                                                                                                                }
                                                                                                                if (context != null) {
                                                                                                                    context.log(this._request, this._response, bytes_written);
                                                                                                                }
                                                                                                                if (this._persistent) {
                                                                                                                    this._listener.persistConnection(this);
                                                                                                                    return var4_15;
                                                                                                                }
                                                                                                                this.destroy();
                                                                                                                return var4_15;
                                                                                                            }
                                                                                                            var3_18 = null;
                                                                                                            content_length = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                                                                            bytes_written = 0;
                                                                                                            if (!this._persistent) break block153;
                                                                                                            ** try [egrp 4[TRYBLOCK] [7 : 801->832)] { 
lbl237:
                                                                                                            // 2 sources

                                                                                                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                                                            }
                                                                                                            break block154;
lbl240:
                                                                                                            // 1 sources

                                                                                                            catch (IOException e) {
                                                                                                                if (this._inputStream.getContentLength() > 0) {
                                                                                                                    this._inputStream.setContentLength(0);
                                                                                                                }
                                                                                                                this._persistent = false;
                                                                                                                this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                                                                                                            }
                                                                                                        }
                                                                                                        if (this._inputStream.getContentLength() > 0) {
                                                                                                            this._inputStream.setContentLength(0);
                                                                                                            this._persistent = false;
                                                                                                            this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                                                                                                        }
                                                                                                        ** try [egrp 5[TRYBLOCK] [8 : 914->954)] { 
lbl251:
                                                                                                        // 1 sources

                                                                                                        this._outputStream.flush(this._outputStream.isChunking());
                                                                                                        bytes_written = this._outputStream.getBytesWritten();
                                                                                                        this._outputStream.resetStream();
                                                                                                        this._inputStream.resetStream();
lbl256:
                                                                                                        // 1 sources

                                                                                                        catch (IOException e) {
                                                                                                            this.exception(e);
                                                                                                        }
                                                                                                        break block155;
                                                                                                    }
                                                                                                    ** try [egrp 6[TRYBLOCK] [9 : 965->1005)] { 
lbl261:
                                                                                                    // 1 sources

                                                                                                    if (this._response != null) {
                                                                                                        this._response.commit();
                                                                                                    }
                                                                                                    this._outputStream.flush();
                                                                                                    bytes_written = this._outputStream.getBytesWritten();
                                                                                                    this._outputStream.close();
                                                                                                    break block155;
lbl267:
                                                                                                    // 1 sources

                                                                                                    catch (IOException e) {
                                                                                                        this.exception(e);
                                                                                                    }
                                                                                                }
                                                                                                if (this._response != null) {
                                                                                                    Code.debug((Object)"RESPONSE:\n", (Object)this._response);
                                                                                                    if (this._persistent && content_length >= 0 && bytes_written > 0 && content_length != bytes_written) {
                                                                                                        Code.warning("Invalid length: Content-Length=" + content_length + " bytes written=" + bytes_written + " for " + this._request.getRequestURL());
                                                                                                        this._persistent = false;
                                                                                                        ** try [egrp 7[TRYBLOCK] [10 : 1110->1120)] { 
lbl276:
                                                                                                        // 1 sources

                                                                                                        this._outputStream.close();
                                                                                                        break block147;
lbl278:
                                                                                                        // 1 sources

                                                                                                        catch (IOException e) {
                                                                                                            Code.warning(e);
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                            if (this._statsOn && this._reqTime > 0L) {
                                                                                                this._httpServer.statsEndRequest(System.currentTimeMillis() - this._reqTime, this._response != null);
                                                                                                this._reqTime = 0L;
                                                                                            }
                                                                                            if (context != null) {
                                                                                                context.log(this._request, this._response, bytes_written);
                                                                                            }
                                                                                            if (this._persistent) {
                                                                                                this._listener.persistConnection(this);
                                                                                                return var4_16;
                                                                                            }
                                                                                            this.destroy();
                                                                                            return var4_16;
                                                                                        }
                                                                                        var3_19 = null;
                                                                                        content_length = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                                                        bytes_written = 0;
                                                                                        if (!this._persistent) break block156;
                                                                                        ** try [egrp 4[TRYBLOCK] [7 : 801->832)] { 
lbl297:
                                                                                        // 2 sources

                                                                                        while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                                        }
                                                                                        break block157;
lbl300:
                                                                                        // 1 sources

                                                                                        catch (IOException e) {
                                                                                            if (this._inputStream.getContentLength() > 0) {
                                                                                                this._inputStream.setContentLength(0);
                                                                                            }
                                                                                            this._persistent = false;
                                                                                            this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                                                                                        }
                                                                                    }
                                                                                    if (this._inputStream.getContentLength() > 0) {
                                                                                        this._inputStream.setContentLength(0);
                                                                                        this._persistent = false;
                                                                                        this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                                                                                    }
                                                                                    ** try [egrp 5[TRYBLOCK] [8 : 914->954)] { 
lbl311:
                                                                                    // 1 sources

                                                                                    this._outputStream.flush(this._outputStream.isChunking());
                                                                                    bytes_written = this._outputStream.getBytesWritten();
                                                                                    this._outputStream.resetStream();
                                                                                    this._inputStream.resetStream();
lbl316:
                                                                                    // 1 sources

                                                                                    catch (IOException e) {
                                                                                        this.exception(e);
                                                                                    }
                                                                                    break block158;
                                                                                }
                                                                                ** try [egrp 6[TRYBLOCK] [9 : 965->1005)] { 
lbl321:
                                                                                // 1 sources

                                                                                if (this._response != null) {
                                                                                    this._response.commit();
                                                                                }
                                                                                this._outputStream.flush();
                                                                                bytes_written = this._outputStream.getBytesWritten();
                                                                                this._outputStream.close();
                                                                                break block158;
lbl327:
                                                                                // 1 sources

                                                                                catch (IOException e) {
                                                                                    this.exception(e);
                                                                                }
                                                                            }
                                                                            if (this._response != null) {
                                                                                Code.debug((Object)"RESPONSE:\n", (Object)this._response);
                                                                                if (this._persistent && content_length >= 0 && bytes_written > 0 && content_length != bytes_written) {
                                                                                    Code.warning("Invalid length: Content-Length=" + content_length + " bytes written=" + bytes_written + " for " + this._request.getRequestURL());
                                                                                    this._persistent = false;
                                                                                    ** try [egrp 7[TRYBLOCK] [10 : 1110->1120)] { 
lbl336:
                                                                                    // 1 sources

                                                                                    this._outputStream.close();
                                                                                    break block148;
lbl338:
                                                                                    // 1 sources

                                                                                    catch (IOException e) {
                                                                                        Code.warning(e);
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                        if (this._statsOn && this._reqTime > 0L) {
                                                                            this._httpServer.statsEndRequest(System.currentTimeMillis() - this._reqTime, this._response != null);
                                                                            this._reqTime = 0L;
                                                                        }
                                                                        if (context != null) {
                                                                            context.log(this._request, this._response, bytes_written);
                                                                        }
                                                                        if (this._persistent) {
                                                                            this._listener.persistConnection(this);
                                                                            return this._persistent;
                                                                        }
                                                                        this.destroy();
                                                                        return this._persistent;
                                                                    }
                                                                    if (this._inputStream.getContentLength() > 0) {
                                                                        this._inputStream.setContentLength(0);
                                                                        this._persistent = false;
                                                                        this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                                                                    }
                                                                    ** try [egrp 5[TRYBLOCK] [8 : 914->954)] { 
lbl357:
                                                                    // 1 sources

                                                                    this._outputStream.flush(this._outputStream.isChunking());
                                                                    bytes_written = this._outputStream.getBytesWritten();
                                                                    this._outputStream.resetStream();
                                                                    this._inputStream.resetStream();
lbl362:
                                                                    // 1 sources

                                                                    catch (IOException e) {
                                                                        this.exception(e);
                                                                    }
                                                                    break block159;
                                                                }
                                                                ** try [egrp 6[TRYBLOCK] [9 : 965->1005)] { 
lbl367:
                                                                // 1 sources

                                                                if (this._response != null) {
                                                                    this._response.commit();
                                                                }
                                                                this._outputStream.flush();
                                                                bytes_written = this._outputStream.getBytesWritten();
                                                                this._outputStream.close();
                                                                break block159;
lbl373:
                                                                // 1 sources

                                                                catch (IOException e) {
                                                                    this.exception(e);
                                                                }
                                                            }
                                                            if (this._response != null) {
                                                                Code.debug((Object)"RESPONSE:\n", (Object)this._response);
                                                                if (this._persistent && content_length >= 0 && bytes_written > 0 && content_length != bytes_written) {
                                                                    Code.warning("Invalid length: Content-Length=" + content_length + " bytes written=" + bytes_written + " for " + this._request.getRequestURL());
                                                                    this._persistent = false;
                                                                    ** try [egrp 7[TRYBLOCK] [10 : 1110->1120)] { 
lbl382:
                                                                    // 1 sources

                                                                    this._outputStream.close();
                                                                    break block149;
lbl384:
                                                                    // 1 sources

                                                                    catch (IOException e) {
                                                                        Code.warning(e);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        if (this._statsOn && this._reqTime > 0L) {
                                                            this._httpServer.statsEndRequest(System.currentTimeMillis() - this._reqTime, this._response != null);
                                                            this._reqTime = 0L;
                                                        }
                                                        if (context != null) {
                                                            context.log(this._request, this._response, bytes_written);
                                                        }
                                                        if (this._persistent) {
                                                            this._listener.persistConnection(this);
                                                            return this._persistent;
                                                        }
                                                        this.destroy();
                                                        return this._persistent;
                                                    }
                                                    if (this._inputStream.getContentLength() > 0) {
                                                        this._inputStream.setContentLength(0);
                                                        this._persistent = false;
                                                        this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                                                    }
                                                    ** try [egrp 5[TRYBLOCK] [8 : 914->954)] { 
lbl403:
                                                    // 1 sources

                                                    this._outputStream.flush(this._outputStream.isChunking());
                                                    bytes_written = this._outputStream.getBytesWritten();
                                                    this._outputStream.resetStream();
                                                    this._inputStream.resetStream();
lbl408:
                                                    // 1 sources

                                                    catch (IOException e) {
                                                        this.exception(e);
                                                    }
                                                    break block160;
                                                }
                                                ** try [egrp 6[TRYBLOCK] [9 : 965->1005)] { 
lbl413:
                                                // 1 sources

                                                if (this._response != null) {
                                                    this._response.commit();
                                                }
                                                this._outputStream.flush();
                                                bytes_written = this._outputStream.getBytesWritten();
                                                this._outputStream.close();
                                                break block160;
lbl419:
                                                // 1 sources

                                                catch (IOException e) {
                                                    this.exception(e);
                                                }
                                            }
                                            if (this._response != null) {
                                                Code.debug((Object)"RESPONSE:\n", (Object)this._response);
                                                if (this._persistent && content_length >= 0 && bytes_written > 0 && content_length != bytes_written) {
                                                    Code.warning("Invalid length: Content-Length=" + content_length + " bytes written=" + bytes_written + " for " + this._request.getRequestURL());
                                                    this._persistent = false;
                                                    ** try [egrp 7[TRYBLOCK] [10 : 1110->1120)] { 
lbl428:
                                                    // 1 sources

                                                    this._outputStream.close();
                                                    break block150;
lbl430:
                                                    // 1 sources

                                                    catch (IOException e) {
                                                        Code.warning(e);
                                                    }
                                                }
                                            }
                                        }
                                        if (this._statsOn && this._reqTime > 0L) {
                                            this._httpServer.statsEndRequest(System.currentTimeMillis() - this._reqTime, this._response != null);
                                            this._reqTime = 0L;
                                        }
                                        if (context != null) {
                                            context.log(this._request, this._response, bytes_written);
                                        }
                                        if (this._persistent) {
                                            this._listener.persistConnection(this);
                                            return this._persistent;
                                        }
                                        this.destroy();
                                        return this._persistent;
                                    }
                                    if (this._inputStream.getContentLength() > 0) {
                                        this._inputStream.setContentLength(0);
                                        this._persistent = false;
                                        this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                                    }
                                    ** try [egrp 5[TRYBLOCK] [8 : 914->954)] { 
lbl449:
                                    // 1 sources

                                    this._outputStream.flush(this._outputStream.isChunking());
                                    bytes_written = this._outputStream.getBytesWritten();
                                    this._outputStream.resetStream();
                                    this._inputStream.resetStream();
lbl454:
                                    // 1 sources

                                    catch (IOException e) {
                                        this.exception(e);
                                    }
                                    break block161;
                                }
                                ** try [egrp 6[TRYBLOCK] [9 : 965->1005)] { 
lbl459:
                                // 1 sources

                                if (this._response != null) {
                                    this._response.commit();
                                }
                                this._outputStream.flush();
                                bytes_written = this._outputStream.getBytesWritten();
                                this._outputStream.close();
                                break block161;
lbl465:
                                // 1 sources

                                catch (IOException e) {
                                    this.exception(e);
                                }
                            }
                            if (this._response != null) {
                                Code.debug((Object)"RESPONSE:\n", (Object)this._response);
                                if (this._persistent && content_length >= 0 && bytes_written > 0 && content_length != bytes_written) {
                                    Code.warning("Invalid length: Content-Length=" + content_length + " bytes written=" + bytes_written + " for " + this._request.getRequestURL());
                                    this._persistent = false;
                                    ** try [egrp 7[TRYBLOCK] [10 : 1110->1120)] { 
lbl474:
                                    // 1 sources

                                    this._outputStream.close();
                                    break block151;
lbl476:
                                    // 1 sources

                                    catch (IOException e) {
                                        Code.warning(e);
                                    }
                                }
                            }
                        }
                        if (this._statsOn && this._reqTime > 0L) {
                            this._httpServer.statsEndRequest(System.currentTimeMillis() - this._reqTime, this._response != null);
                            this._reqTime = 0L;
                        }
                        if (context != null) {
                            context.log(this._request, this._response, bytes_written);
                        }
                        if (this._persistent) {
                            this._listener.persistConnection(this);
                            return this._persistent;
                        }
                        this.destroy();
                        return this._persistent;
                    }
                    if (this._inputStream.getContentLength() > 0) {
                        this._inputStream.setContentLength(0);
                        this._persistent = false;
                        this.exception(new HttpException(HttpResponse.__400_Bad_Request, "Missing Content"));
                    }
                    ** try [egrp 5[TRYBLOCK] [8 : 914->954)] { 
lbl495:
                    // 1 sources

                    this._outputStream.flush(this._outputStream.isChunking());
                    bytes_written = this._outputStream.getBytesWritten();
                    this._outputStream.resetStream();
                    this._inputStream.resetStream();
lbl500:
                    // 1 sources

                    catch (IOException e) {
                        this.exception(e);
                    }
                    break block162;
                }
                ** try [egrp 6[TRYBLOCK] [9 : 965->1005)] { 
lbl505:
                // 1 sources

                if (this._response != null) {
                    this._response.commit();
                }
                this._outputStream.flush();
                bytes_written = this._outputStream.getBytesWritten();
                this._outputStream.close();
                break block162;
lbl511:
                // 1 sources

                catch (IOException e) {
                    this.exception(e);
                }
            }
            if (this._response != null) {
                Code.debug((Object)"RESPONSE:\n", (Object)this._response);
                if (this._persistent && content_length >= 0 && bytes_written > 0 && content_length != bytes_written) {
                    Code.warning("Invalid length: Content-Length=" + content_length + " bytes written=" + bytes_written + " for " + this._request.getRequestURL());
                    this._persistent = false;
                    ** try [egrp 7[TRYBLOCK] [10 : 1110->1120)] { 
lbl520:
                    // 1 sources

                    this._outputStream.close();
                    break block152;
lbl522:
                    // 1 sources

                    catch (IOException e) {
                        Code.warning(e);
                    }
                }
            }
        }
        if (this._statsOn && this._reqTime > 0L) {
            this._httpServer.statsEndRequest(System.currentTimeMillis() - this._reqTime, this._response != null);
            this._reqTime = 0L;
        }
        if (context != null) {
            context.log(this._request, this._response, bytes_written);
        }
        if (this._persistent) {
            this._listener.persistConnection(this);
            throw var2_40;
        }
        this.destroy();
        throw var2_40;
    }

    private void destroy() {
        if (this._request != null) {
            this._request.destroy();
        }
        if (this._response != null) {
            this._response.destroy();
        }
        this._request = null;
        this._response = null;
        this._handlingThread = null;
        try {
            this.close();
        }
        catch (IOException e) {
            Code.ignore(e);
        }
        catch (Exception e) {
            Code.warning(e);
        }
        if (this._statsOn) {
            this._tmpTime = System.currentTimeMillis();
            if (this._reqTime > 0L) {
                this._httpServer.statsEndRequest(this._tmpTime - this._reqTime, false);
            }
            this._httpServer.statsCloseConnection(this._tmpTime - this._openTime, this._requests);
        }
    }

    public HttpConnection(HttpListener listener, InetAddress remoteAddr, InputStream in, OutputStream out, Object connection) {
        Code.debug((Object)"new HttpConnection: ", connection);
        this._listener = listener;
        this._remoteAddr = remoteAddr;
        this._inputStream = new ChunkableInputStream(in);
        this._outputStream = new ChunkableOutputStream(out);
        this._outputStream.addObserver(this);
        this._outputSetup = false;
        if (this._listener != null) {
            this._httpServer = this._listener.getHttpServer();
        }
        this._connection = connection;
        boolean bl = this._statsOn = this._httpServer != null && this._httpServer.getStatsOn();
        if (this._statsOn) {
            this._openTime = System.currentTimeMillis();
            this._httpServer.statsOpenConnection();
        }
        this._reqTime = 0L;
        this._requests = 0;
    }
}

