/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.util.xml;

import com.ibm.wsdl.util.xml.XPathUtils;
import java.io.PrintWriter;
import javax.wsdl.Definition;
import javax.wsdl.QName;
import javax.wsdl.WSDLException;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMUtils {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";

    public static String cleanString(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            if (!bl) {
                switch (cArray[n]) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("&apos;");
                        break;
                    }
                    case '<': {
                        if (cArray.length >= n + 9) {
                            String string2 = new String(cArray, n, 9);
                            if (string2.equals("<![CDATA[")) {
                                stringBuffer.append(string2);
                                n += 8;
                                bl = true;
                                break;
                            }
                            stringBuffer.append("&lt;");
                            break;
                        }
                        stringBuffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        break;
                    }
                    default: {
                        stringBuffer.append(cArray[n]);
                        break;
                    }
                }
            } else {
                stringBuffer.append(cArray[n]);
                if (cArray[n] == '>' && cArray[n - 1] == ']' && cArray[n - 2] == ']') {
                    bl = false;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static int countKids(Element element, short s) {
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == s) {
                ++n;
            }
            node = node.getNextSibling();
        }
        return n;
    }

    public static Element findChildElementWithAttribute(Element element, String string, String string2) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && string2.equals(DOMUtils.getAttribute((Element)node, string))) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static String getAttribute(Element element, String string) {
        String string2 = null;
        Attr attr = element.getAttributeNode(string);
        if (attr != null) {
            string2 = attr.getValue();
        }
        return string2;
    }

    public static String getAttributeNS(Element element, String string, String string2) {
        String string3 = null;
        Attr attr = element.getAttributeNodeNS(string, string2);
        if (attr != null) {
            string3 = attr.getValue();
        }
        return string3;
    }

    public static String getChildCharacterData(Element element) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        StringBuffer stringBuffer = new StringBuffer();
        while (node != null) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData characterData = (CharacterData)node;
                    stringBuffer.append(characterData.getData());
                    break;
                }
            }
            node = node.getNextSibling();
        }
        return stringBuffer.toString();
    }

    public static Element getFirstChildElement(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static String getNamespaceURIFromPrefix(Node node, String string) {
        short s = node.getNodeType();
        Node node2 = null;
        switch (s) {
            case 2: {
                node2 = ((Attr)node).getOwnerElement();
                break;
            }
            case 1: {
                node2 = node;
                break;
            }
            default: {
                node2 = node.getParentNode();
                break;
            }
        }
        while (node2 != null && node2.getNodeType() == 1) {
            String string2;
            Element element = (Element)node2;
            String string3 = string2 = string == null ? DOMUtils.getAttribute(element, "xmlns") : DOMUtils.getAttributeNS(element, NS_URI_XMLNS, string);
            if (string2 != null) {
                return string2;
            }
            node2 = element.getParentNode();
        }
        return null;
    }

    public static Element getNextSiblingElement(Element element) {
        Node node = element.getNextSibling();
        while (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static String getPrefix(String string, Definition definition) throws WSDLException {
        String string2 = definition.getPrefix(string);
        if (string2 == null) {
            throw new WSDLException("OTHER_ERROR", "Can't find prefix for '" + string + "'. Namespace prefixes must be set on the" + " Definition object using the " + "addNamespace(...) method.");
        }
        return string2;
    }

    public static QName getQualifiedAttributeValue(Element element, String string, String string2, boolean bl) throws WSDLException {
        String string3 = DOMUtils.getAttribute(element, string);
        if (string3 != null) {
            int n = string3.indexOf(58);
            String string4 = n != -1 ? string3.substring(0, n) : null;
            String string5 = string3.substring(n + 1);
            String string6 = DOMUtils.getNamespaceURIFromPrefix(element, string4);
            if (string6 != null) {
                return new QName(string6, string5);
            }
            WSDLException wSDLException = new WSDLException("INVALID_WSDL", "Unable to determine namespace of '" + (string4 != null ? String.valueOf(string4) + ":" : "") + string5 + "'.");
            wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
            throw wSDLException;
        }
        if (bl) {
            WSDLException wSDLException = new WSDLException("INVALID_WSDL", "The '" + string + "' attribute must be " + "specified for every " + string2 + " element.");
            wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
            throw wSDLException;
        }
        return null;
    }

    public static String getQualifiedValue(String string, String string2, Definition definition) throws WSDLException {
        String string3 = null;
        if (string != null && !string.equals("")) {
            string3 = DOMUtils.getPrefix(string, definition);
        }
        return String.valueOf(string3 != null && !string3.equals("") ? String.valueOf(string3) + ":" : "") + string2;
    }

    public static void printAttribute(String string, String string2, PrintWriter printWriter) {
        if (string2 != null) {
            printWriter.print(String.valueOf(' ') + string + "=\"" + DOMUtils.cleanString(string2) + '\"');
        }
    }

    public static void printQualifiedAttribute(String string, QName qName, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (qName != null) {
            DOMUtils.printAttribute(string, DOMUtils.getQualifiedValue(qName.getNamespaceURI(), qName.getLocalPart(), definition), printWriter);
        }
    }

    public static void printQualifiedAttribute(QName qName, String string, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (qName != null) {
            DOMUtils.printAttribute(DOMUtils.getQualifiedValue(qName.getNamespaceURI(), qName.getLocalPart(), definition), string, printWriter);
        }
    }

    public static void throwWSDLException(Element element) throws WSDLException {
        String string = new QName(element).toString();
        WSDLException wSDLException = new WSDLException("INVALID_WSDL", "Encountered unexpected '" + string + "'.");
        wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
        throw wSDLException;
    }
}

