/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.encoding.DefaultSOAP12TypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BaseTypeMapping;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Element;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaDefinitionWriter;
import org.apache.axis.wsdl.toJava.JavaServiceWriter;
import org.apache.axis.wsdl.toJava.JavaTypeWriter;
import org.apache.axis.wsdl.toJava.MessageEntry;
import org.apache.axis.wsdl.toJava.NoopWriter;
import org.apache.axis.wsdl.toJava.Parameter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.ServiceEntry;
import org.apache.axis.wsdl.toJava.SymTabEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Type;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.axis.wsdl.toJava.Writer;
import org.apache.axis.wsdl.toJava.WriterFactory;

public class JavaWriterFactory
implements WriterFactory {
    private Emitter emitter;
    private SymbolTable symbolTable;
    BaseTypeMapping btm = null;

    public void writerPass(Definition definition, SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.javifyNames(symbolTable);
        this.resolveNameClashes(symbolTable);
        if (this.emitter.bGenerateAll) {
            this.setAllReferencesToTrue();
        } else {
            this.ignoreNonSOAPBindings(symbolTable);
        }
        this.constructSignatures(symbolTable);
        this.determineIfHoldersNeeded(symbolTable);
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public Writer getWriter(Message message, SymbolTable symbolTable) {
        return new NoopWriter();
    }

    public Writer getWriter(PortType portType, SymbolTable symbolTable) {
        return new NoopWriter();
    }

    public Writer getWriter(Binding binding, SymbolTable symbolTable) {
        return new JavaBindingWriter(this.emitter, binding, symbolTable);
    }

    public Writer getWriter(Service service, SymbolTable symbolTable) {
        return new JavaServiceWriter(this.emitter, service, symbolTable);
    }

    public Writer getWriter(TypeEntry typeEntry, SymbolTable symbolTable) {
        return new JavaTypeWriter(this.emitter, typeEntry, symbolTable);
    }

    public Writer getWriter(Definition definition, SymbolTable symbolTable) {
        return new JavaDefinitionWriter(this.emitter, definition, symbolTable);
    }

    private void javifyNames(SymbolTable symbolTable) {
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            int n = 0;
            while (n < vector.size()) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(n);
                if (symTabEntry instanceof TypeEntry) {
                    TypeEntry typeEntry = (TypeEntry)symTabEntry;
                    String string = typeEntry.getDimensions();
                    TypeEntry typeEntry2 = typeEntry.getRefType();
                    while (typeEntry2 != null) {
                        typeEntry = typeEntry2;
                        string = string + typeEntry.getDimensions();
                        typeEntry2 = typeEntry.getRefType();
                    }
                    symTabEntry.setName(symbolTable.getJavaName(typeEntry.getQName()) + string);
                } else {
                    symTabEntry.setName(symbolTable.getJavaName(symTabEntry.getQName()));
                }
                ++n;
            }
        }
    }

    private void resolveNameClashes(SymbolTable symbolTable) {
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            SymTabEntry symTabEntry;
            Object object;
            Vector<TypeEntry> vector = new Vector<TypeEntry>((Vector)iterator.next());
            if (vector.size() <= 1) continue;
            boolean bl = true;
            if (vector.size() == 2 && (vector.elementAt(0) instanceof Element && vector.elementAt(1) instanceof Type || vector.elementAt(1) instanceof Element && vector.elementAt(0) instanceof Type)) {
                object = null;
                object = vector.elementAt(0) instanceof Element ? (Element)vector.elementAt(0) : (Element)vector.elementAt(1);
                javax.wsdl.QName qName = Utils.getNodeTypeRefQName(((TypeEntry)object).getNode(), "type");
                if (qName != null && qName.equals((Object)((SymTabEntry)object).getQName())) {
                    bl = false;
                }
            }
            if (bl) {
                bl = false;
                object = null;
                int n = 0;
                while (n < vector.size() && !bl) {
                    symTabEntry = (SymTabEntry)vector.elementAt(n);
                    if (!(symTabEntry instanceof MessageEntry) && !(symTabEntry instanceof BindingEntry)) {
                        if (object == null) {
                            object = symTabEntry.getName();
                        } else if (((String)object).equals(symTabEntry.getName())) {
                            bl = true;
                        }
                    }
                    ++n;
                }
            }
            if (!bl) continue;
            boolean bl2 = true;
            int n = 0;
            while (n < vector.size()) {
                Object object2;
                symTabEntry = (SymTabEntry)vector.elementAt(n);
                if (symTabEntry instanceof Element) {
                    symTabEntry.setName(this.mangleName(symTabEntry.getName(), "_ElemType"));
                } else if (symTabEntry instanceof TypeEntry) {
                    if (bl2) {
                        bl2 = false;
                        object2 = symbolTable.getTypes();
                        int n2 = 0;
                        while (n2 < ((Vector)object2).size()) {
                            TypeEntry typeEntry = (TypeEntry)((Vector)object2).elementAt(n2);
                            if (typeEntry != symTabEntry && !(typeEntry instanceof Element) && typeEntry.getBaseType() == null && this.sameJavaClass(((Type)symTabEntry).getName(), typeEntry.getName())) {
                                vector.add(typeEntry);
                            }
                            ++n2;
                        }
                    }
                    symTabEntry.setName(this.mangleName(symTabEntry.getName(), "_Type"));
                } else if (symTabEntry instanceof PortTypeEntry) {
                    symTabEntry.setName(this.mangleName(symTabEntry.getName(), "_Port"));
                } else if (symTabEntry instanceof ServiceEntry) {
                    symTabEntry.setName(this.mangleName(symTabEntry.getName(), "_Service"));
                } else if (symTabEntry instanceof BindingEntry && ((BindingEntry)(object2 = (BindingEntry)symTabEntry)).hasLiteral()) {
                    symTabEntry.setName(this.mangleName(symTabEntry.getName(), "_Binding"));
                }
                ++n;
            }
        }
    }

    private String mangleName(String string, String string2) {
        int n = string.indexOf("[");
        if (n >= 0) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n);
            return string3 + string2 + string4;
        }
        return string + string2;
    }

    private boolean sameJavaClass(String string, String string2) {
        int n = string.indexOf("[");
        int n2 = string2.indexOf("[");
        if (n > 0) {
            string = string.substring(0, n);
        }
        if (n2 > 0) {
            string2 = string2.substring(0, n2);
        }
        return string.equals(string2);
    }

    private void setAllReferencesToTrue() {
        Iterator iterator = this.symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            int n = 0;
            while (n < vector.size()) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(n);
                if (symTabEntry instanceof BindingEntry && ((BindingEntry)symTabEntry).getBindingType() != 0) {
                    symTabEntry.setIsReferenced(false);
                } else {
                    symTabEntry.setIsReferenced(true);
                }
                ++n;
            }
        }
    }

    private void ignoreNonSOAPBindings(SymbolTable symbolTable) {
        Vector<PortTypeEntry> vector = new Vector<PortTypeEntry>();
        Vector<PortTypeEntry> vector2 = new Vector<PortTypeEntry>();
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector3 = (Vector)iterator.next();
            int n = 0;
            while (n < vector3.size()) {
                SymTabEntry symTabEntry = (SymTabEntry)vector3.elementAt(n);
                if (symTabEntry instanceof BindingEntry) {
                    BindingEntry bindingEntry = (BindingEntry)symTabEntry;
                    Binding binding = bindingEntry.getBinding();
                    PortType portType = binding.getPortType();
                    PortTypeEntry portTypeEntry = symbolTable.getPortTypeEntry(portType.getQName());
                    if (bindingEntry.getBindingType() == 0) {
                        vector2.add(portTypeEntry);
                        if (vector.contains(portTypeEntry)) {
                            vector.remove(portTypeEntry);
                        }
                    } else {
                        bindingEntry.setIsReferenced(false);
                        if (!vector2.contains(portTypeEntry)) {
                            vector.add(portTypeEntry);
                        }
                    }
                }
                ++n;
            }
        }
        int n = 0;
        while (n < vector.size()) {
            PortTypeEntry portTypeEntry = (PortTypeEntry)vector.get(n);
            portTypeEntry.setIsReferenced(false);
            ++n;
        }
    }

    private void constructSignatures(SymbolTable symbolTable) {
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            int n = 0;
            while (n < vector.size()) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(n);
                if (symTabEntry instanceof BindingEntry) {
                    BindingEntry bindingEntry = (BindingEntry)symTabEntry;
                    Binding binding = bindingEntry.getBinding();
                    PortTypeEntry portTypeEntry = symbolTable.getPortTypeEntry(binding.getPortType().getQName());
                    PortType portType = portTypeEntry.getPortType();
                    Iterator iterator2 = portType.getOperations().iterator();
                    while (iterator2.hasNext()) {
                        Operation operation = (Operation)iterator2.next();
                        OperationType operationType = operation.getStyle();
                        String string = operation.getName();
                        Parameters parameters = bindingEntry.getParameters(operation);
                        if (operationType == OperationType.SOLICIT_RESPONSE) {
                            parameters.signature = "    // " + JavaUtils.getMessage("invalidSolResp00", string);
                            System.err.println(JavaUtils.getMessage("invalidSolResp00", string));
                            continue;
                        }
                        if (operationType == OperationType.NOTIFICATION) {
                            parameters.signature = "    // " + JavaUtils.getMessage("invalidNotif00", string);
                            System.err.println(JavaUtils.getMessage("invalidNotif00", string));
                            continue;
                        }
                        parameters.signature = this.constructSignature(parameters, string);
                    }
                }
                ++n;
            }
        }
    }

    private String constructSignature(Parameters parameters, String string) {
        String string2 = Utils.xmlNameToJava(string);
        String string3 = parameters.returnType == null ? "void" : parameters.returnType.getName();
        String string4 = "    public " + string3 + " " + string2 + "(";
        boolean bl = false;
        int n = 0;
        while (n < parameters.list.size()) {
            Parameter parameter = (Parameter)parameters.list.get(n);
            if (bl) {
                string4 = string4 + ", ";
            } else {
                bl = true;
            }
            String string5 = Utils.xmlNameToJava(parameter.getName());
            string4 = parameter.mode == 1 ? string4 + parameter.type.getName() + " " + string5 : string4 + Utils.holder(parameter.type, this.symbolTable) + " " + string5;
            ++n;
        }
        string4 = string4 + ") throws java.rmi.RemoteException";
        if (parameters.faultString != null) {
            string4 = string4 + ", " + parameters.faultString;
        }
        return string4;
    }

    private void determineIfHoldersNeeded(SymbolTable symbolTable) {
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            int n = 0;
            while (n < vector.size()) {
                if (vector.get(n) instanceof BindingEntry) {
                    BindingEntry bindingEntry = (BindingEntry)vector.get(n);
                    PortTypeEntry portTypeEntry = symbolTable.getPortTypeEntry(bindingEntry.getBinding().getPortType().getQName());
                    Iterator iterator2 = bindingEntry.getParameters().values().iterator();
                    while (iterator2.hasNext()) {
                        Parameters parameters = (Parameters)iterator2.next();
                        int n2 = 0;
                        while (n2 < parameters.list.size()) {
                            Parameter parameter = (Parameter)parameters.list.get(n2);
                            if (parameter.mode != 1) {
                                parameter.type.setDynamicVar("Holder is needed", new Boolean(true));
                            }
                            ++n2;
                        }
                    }
                }
                ++n;
            }
        }
    }

    public void setBaseTypeMapping(BaseTypeMapping baseTypeMapping) {
        this.btm = baseTypeMapping;
    }

    public BaseTypeMapping getBaseTypeMapping() {
        if (this.btm == null) {
            this.btm = new BaseTypeMapping(){
                TypeMapping defaultTM = DefaultSOAP12TypeMappingImpl.create();

                public String getBaseName(javax.wsdl.QName qName) {
                    QName qName2 = new QName(qName.getNamespaceURI(), qName.getLocalPart());
                    Class clazz = this.defaultTM.getClassForQName(qName2);
                    if (clazz == null) {
                        return null;
                    }
                    return JavaUtils.getTextClassName(clazz.getName());
                }
            };
        }
        return this.btm;
    }
}

