/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.QName;
import javax.wsdl.Service;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.SymbolTable;

public class JavaUndeployWriter
extends JavaWriter {
    private Definition definition;
    private SymbolTable symbolTable;

    protected JavaUndeployWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, new QName(definition.getTargetNamespace(), "undeploy"), "", "wsdd", JavaUtils.getMessage("genUndeploy00"), "undeploy");
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    protected void writeFileHeader() throws IOException {
        this.initializeDeploymentDoc("undeploy");
    }

    protected void writeFileBody() throws IOException {
        this.writeDeployServices();
        this.pw.println("</undeployment>");
        this.pw.close();
    }

    private void writeDeployServices() throws IOException {
        Map map = this.definition.getServices();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            this.pw.println();
            this.pw.println("  <!-- " + JavaUtils.getMessage("wsdlService00", service.getQName().getLocalPart()) + " -->");
            this.pw.println();
            Iterator iterator2 = service.getPorts().values().iterator();
            while (iterator2.hasNext()) {
                Port port = (Port)iterator2.next();
                this.writeDeployPort(port);
            }
        }
    }

    private void writeDeployPort(Port port) throws IOException {
        Binding binding = port.getBinding();
        BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
        String string = port.getName();
        boolean bl = bindingEntry.getBindingStyle() == 0;
        this.pw.println("  <service name=\"" + string + "\">");
        this.pw.println("  </service>");
    }
}

