/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Vector;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaComplexTypeWriter;
import org.apache.axis.wsdl.toJava.JavaEnumTypeWriter;
import org.apache.axis.wsdl.toJava.JavaHolderWriter;
import org.apache.axis.wsdl.toJava.SchemaUtils;
import org.apache.axis.wsdl.toJava.SymTabEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Writer;
import org.w3c.dom.Node;

public class JavaTypeWriter
implements Writer {
    public static final String HOLDER_IS_NEEDED = "Holder is needed";
    private Writer typeWriter = null;
    private Writer holderWriter = null;

    public JavaTypeWriter(Emitter emitter, TypeEntry typeEntry, SymbolTable symbolTable) {
        if (typeEntry.isReferenced() && !typeEntry.isOnlyLiteralReferenced()) {
            Node node = typeEntry.getNode();
            if (!typeEntry.getName().endsWith("[]")) {
                Vector vector = SchemaUtils.getComplexElementTypesAndNames(node, symbolTable);
                if (vector != null) {
                    this.typeWriter = new JavaComplexTypeWriter(emitter, typeEntry, vector, SchemaUtils.getComplexElementExtensionBase(node, symbolTable), SchemaUtils.getComplexElementAttributes(node, symbolTable));
                } else {
                    vector = SchemaUtils.getEnumerationBaseAndValues(node, symbolTable);
                    if (vector != null) {
                        this.typeWriter = new JavaEnumTypeWriter(emitter, typeEntry, vector);
                    }
                }
            }
            if (this.holderIsNeeded(typeEntry)) {
                this.holderWriter = new JavaHolderWriter(emitter, typeEntry);
            }
        }
    }

    public void write() throws IOException {
        if (this.typeWriter != null) {
            this.typeWriter.write();
        }
        if (this.holderWriter != null) {
            this.holderWriter.write();
        }
    }

    private boolean holderIsNeeded(SymTabEntry symTabEntry) {
        Boolean bl = (Boolean)symTabEntry.getDynamicVar(HOLDER_IS_NEEDED);
        return bl != null && bl != false;
    }
}

