/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Parameter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.SchemaUtils;
import org.apache.axis.wsdl.toJava.ServiceEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaTestCaseWriter
extends JavaWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;
    private int counter = 1;

    protected JavaTestCaseWriter(Emitter emitter, ServiceEntry serviceEntry, SymbolTable symbolTable) {
        super(emitter, serviceEntry, "TestCase", "java", JavaUtils.getMessage("genTest00"), "testCase");
        this.sEntry = serviceEntry;
        this.symbolTable = symbolTable;
    }

    protected void writeFileHeader() throws IOException {
        super.writeFileHeader();
        this.pw.print("public class ");
        this.pw.print(this.className);
        this.pw.println(" extends junit.framework.TestCase {");
        this.pw.print("    public ");
        this.pw.print(this.className);
        this.pw.println("(String name) {");
        this.pw.println("        super(name);");
        this.pw.println("    }");
    }

    protected void writeFileBody() throws IOException {
        Map map = this.sEntry.getService().getPorts();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            Binding binding = port.getBinding();
            BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bindingEntry.getBindingType() != 0) continue;
            String string = Utils.xmlNameToJavaClass(port.getName());
            PortType portType = binding.getPortType();
            PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(portType.getQName());
            this.writeComment(this.pw, port.getDocumentationElement());
            this.writeServiceTestCode(string, portType, portTypeEntry, binding, bindingEntry);
        }
        this.finish();
    }

    public final void finish() {
        this.pw.println("}");
        this.pw.println();
        this.pw.flush();
        this.pw.close();
    }

    private final void writeServiceTestCode(String string, PortType portType, PortTypeEntry portTypeEntry, Binding binding, BindingEntry bindingEntry) throws IOException {
        Iterator iterator = portType.getOperations().iterator();
        while (iterator.hasNext()) {
            String string2;
            Object object;
            Object object2;
            Object object3;
            Operation operation = (Operation)iterator.next();
            OperationType operationType = operation.getStyle();
            Parameters parameters = bindingEntry.getParameters(operation);
            if (operationType == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE) {
                this.pw.println("    " + parameters.signature);
                continue;
            }
            String string3 = Utils.xmlNameToJavaClass(operation.getName());
            String string4 = "test" + this.counter++ + string + string3;
            this.pw.println("    public void " + string4 + "() {");
            String string5 = bindingEntry.hasLiteral() ? bindingEntry.getName() : portTypeEntry.getName();
            this.writeBindingAssignment(string5, string);
            this.pw.println("        try {");
            if (parameters.returnType != null) {
                this.pw.print("            ");
                this.pw.print(parameters.returnType.getName());
                this.pw.print(" value = ");
                if (this.isPrimitiveType(parameters.returnType)) {
                    if ("boolean".equals(parameters.returnType.getName())) {
                        this.pw.println("false;");
                    } else {
                        this.pw.println("-3;");
                    }
                } else {
                    this.pw.println("null;");
                }
            }
            this.pw.print("            ");
            if (parameters.returnType != null) {
                this.pw.print("value = ");
            }
            this.pw.print("binding.");
            this.pw.print(Utils.xmlNameToJava(operation.getName()));
            this.pw.print("(");
            Iterator iterator2 = parameters.list.iterator();
            boolean bl = true;
            while (iterator2.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    this.pw.print(", ");
                }
                object3 = (Parameter)iterator2.next();
                object2 = ((Parameter)object3).type.getName();
                String string6 = "";
                if (((Parameter)object3).mode != 1) {
                    this.pw.print("new " + Utils.holder(((Parameter)object3).type, this.symbolTable) + "(");
                    string6 = ")";
                }
                if (((Parameter)object3).mode != 2) {
                    if (this.isPrimitiveType(((Parameter)object3).type)) {
                        if ("boolean".equals(object2)) {
                            this.pw.print("true");
                        } else if ("byte".equals(object2)) {
                            this.pw.print("(byte)0");
                        } else if ("short".equals(object2)) {
                            this.pw.print("(short)0");
                        } else {
                            this.pw.print("0");
                        }
                    } else if (((String)object2).equals("java.lang.Boolean")) {
                        this.pw.print("new java.lang.Boolean(false)");
                    } else if (((String)object2).equals("java.lang.Byte")) {
                        this.pw.print("new java.lang.Byte((byte)0)");
                    } else if (((String)object2).equals("java.lang.Double")) {
                        this.pw.print("new java.lang.Double(0)");
                    } else if (((String)object2).equals("java.lang.Float")) {
                        this.pw.print("new java.lang.Float(0)");
                    } else if (((String)object2).equals("java.lang.Integer")) {
                        this.pw.print("new java.lang.Integer(0)");
                    } else if (((String)object2).equals("java.lang.Long")) {
                        this.pw.print("new java.lang.Long(0)");
                    } else if (((String)object2).equals("java.lang.Short")) {
                        this.pw.print("new java.lang.Short((short)0)");
                    } else if (((String)object2).equals("java.math.BigDecimal")) {
                        this.pw.print("new java.math.BigDecimal(0)");
                    } else if (((String)object2).equals("java.math.BigInteger")) {
                        this.pw.print("new java.math.BigInteger(\"0\")");
                    } else if (((String)object2).equals("java.lang.Object")) {
                        this.pw.print("new java.lang.String()");
                    } else if (((String)object2).equals("byte[]")) {
                        this.pw.print("new byte[0]");
                    } else if (((String)object2).endsWith("[]")) {
                        this.pw.print("new " + JavaUtils.replace((String)object2, "[]", "[0]"));
                    } else {
                        object = SchemaUtils.getEnumerationBaseAndValues(((Parameter)object3).type.getNode(), this.symbolTable);
                        if (object != null) {
                            string2 = (String)((Vector)object).get(1);
                            this.pw.print((String)object2 + "." + string2);
                        } else {
                            this.pw.print("new " + (String)object2 + "()");
                        }
                    }
                }
                this.pw.print(string6);
            }
            this.pw.println(");");
            this.pw.println("        }");
            object3 = operation.getFaults();
            if (object3 != null) {
                object2 = object3.values().iterator();
                int n = 0;
                while (object2.hasNext()) {
                    object = (Fault)object2.next();
                    string2 = portType.getQName().getNamespaceURI();
                    this.pw.print("        catch (");
                    this.pw.print(Utils.getFullExceptionName((Fault)object, this.symbolTable, string2));
                    this.pw.println(" e" + ++n + ") {");
                    this.pw.print("            ");
                    this.pw.println("throw new junit.framework.AssertionFailedError(\"" + object.getName() + " Exception caught: \" + e" + n + ");");
                    this.pw.println("        }");
                }
            }
            this.pw.println("        catch (java.rmi.RemoteException re) {");
            this.pw.print("            ");
            this.pw.println("throw new junit.framework.AssertionFailedError(\"Remote Exception caught: \" + re);");
            this.pw.println("        }");
            this.pw.println("    }");
            this.pw.println();
        }
    }

    public final void writeBindingAssignment(String string, String string2) throws IOException {
        this.pw.println("        " + string + " binding;");
        this.pw.println("        try {");
        this.pw.print("            binding = new " + this.sEntry.getName());
        this.pw.println("Locator().get" + string2 + "();");
        this.pw.println("        }");
        this.pw.println("        catch (javax.xml.rpc.ServiceException jre) {");
        this.pw.println("            throw new junit.framework.AssertionFailedError(\"JAX-RPC ServiceException caught: \" + jre);");
        this.pw.println("        }");
        this.pw.println("        assertTrue(\"" + JavaUtils.getMessage("null00", "binding") + "\", binding != null);");
        this.pw.println();
    }
}

