/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.ServiceEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaServiceImplWriter
extends JavaWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;

    protected JavaServiceImplWriter(Emitter emitter, ServiceEntry serviceEntry, SymbolTable symbolTable) {
        super(emitter, serviceEntry, "Locator", "java", JavaUtils.getMessage("genService00"), "service");
        this.sEntry = serviceEntry;
        this.symbolTable = symbolTable;
    }

    protected void writeFileBody() throws IOException {
        Service service = this.sEntry.getService();
        this.pw.println("public class " + this.className + " extends org.apache.axis.client.Service implements " + this.sEntry.getName() + " {");
        this.writeComment(this.pw, service.getDocumentationElement());
        Map map = service.getPorts();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            Binding binding = port.getBinding();
            if (binding == null) {
                throw new IOException(JavaUtils.getMessage("emitFailNoBinding01", new String[]{port.getName()}));
            }
            BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bindingEntry == null) {
                throw new IOException(JavaUtils.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (portTypeEntry == null) {
                throw new IOException(JavaUtils.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            if (bindingEntry.getBindingType() != 0) continue;
            String string = Utils.xmlNameToJavaClass(port.getName());
            String string2 = bindingEntry.getName() + "Stub";
            String string3 = bindingEntry.hasLiteral() ? bindingEntry.getName() : portTypeEntry.getName();
            String string4 = this.getAddressFromPort(port);
            if (string4 == null) {
                throw new IOException(JavaUtils.getMessage("emitFail02", string, this.className));
            }
            try {
                URL uRL = new URL(string4);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException(JavaUtils.getMessage("emitFail03", new String[]{string, this.className, string4}));
            }
            this.pw.println();
            this.pw.println("    // " + JavaUtils.getMessage("getProxy00", string));
            this.writeComment(this.pw, port.getDocumentationElement());
            this.pw.println("    private final java.lang.String " + string + "_address = \"" + string4 + "\";");
            this.pw.println("");
            this.pw.println("    public String get" + string + "Address() {");
            this.pw.println("        return " + string + "_address;");
            this.pw.println("    }");
            this.pw.println("");
            this.pw.println("    public " + string3 + " get" + string + "() throws javax.xml.rpc.ServiceException {");
            this.pw.println("       java.net.URL endpoint;");
            this.pw.println("        try {");
            this.pw.println("            endpoint = new java.net.URL(" + string + "_address);");
            this.pw.println("        }");
            this.pw.println("        catch (java.net.MalformedURLException e) {");
            this.pw.println("            return null; // " + JavaUtils.getMessage("unlikely00"));
            this.pw.println("        }");
            this.pw.println("        return get" + string + "(endpoint);");
            this.pw.println("    }");
            this.pw.println();
            this.pw.println("    public " + string3 + " get" + string + "(java.net.URL portAddress) throws javax.xml.rpc.ServiceException {");
            this.pw.println("        try {");
            this.pw.println("            return new " + string2 + "(portAddress, this);");
            this.pw.println("        }");
            this.pw.println("        catch (org.apache.axis.AxisFault e) {");
            this.pw.println("            return null; // ???");
            this.pw.println("        }");
            this.pw.println("    }");
        }
        this.pw.println("}");
        this.pw.close();
    }

    private String getAddressFromPort(Port port) {
        List list = port.getExtensibilityElements();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (!(e instanceof SOAPAddress)) continue;
            return ((SOAPAddress)e).getLocationURI();
        }
        return null;
    }
}

