/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.ServiceEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaServiceIfaceWriter
extends JavaWriter {
    private Service service;
    private SymbolTable symbolTable;

    protected JavaServiceIfaceWriter(Emitter emitter, ServiceEntry serviceEntry, SymbolTable symbolTable) {
        super(emitter, serviceEntry, "", "java", JavaUtils.getMessage("genService00"), "service");
        this.service = serviceEntry.getService();
        this.symbolTable = symbolTable;
    }

    protected void writeFileBody() throws IOException {
        this.pw.println("public interface " + this.className + " extends javax.xml.rpc.Service {");
        this.writeComment(this.pw, this.service.getDocumentationElement());
        Map map = this.service.getPorts();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            Binding binding = port.getBinding();
            if (binding == null) {
                throw new IOException(JavaUtils.getMessage("emitFailNoBinding01", new String[]{port.getName()}));
            }
            BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bindingEntry == null) {
                throw new IOException(JavaUtils.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (portTypeEntry == null) {
                throw new IOException(JavaUtils.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            if (bindingEntry.getBindingType() != 0) continue;
            String string = Utils.xmlNameToJavaClass(port.getName());
            String string2 = bindingEntry.hasLiteral() ? bindingEntry.getName() : portTypeEntry.getName();
            this.pw.println("    public String get" + string + "Address();");
            this.pw.println();
            this.pw.println("    public " + string2 + " get" + string + "() throws javax.xml.rpc.ServiceException;");
            this.pw.println();
            this.pw.println("    public " + string2 + " get" + string + "(java.net.URL portAddress) throws javax.xml.rpc.ServiceException;");
        }
        this.pw.println("}");
        this.pw.close();
    }
}

