/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Iterator;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaInterfaceWriter
extends JavaWriter {
    private PortType portType;
    private PortTypeEntry ptEntry;
    private SymbolTable symbolTable;
    private BindingEntry bEntry;

    protected JavaInterfaceWriter(Emitter emitter, PortTypeEntry portTypeEntry, BindingEntry bindingEntry, SymbolTable symbolTable) {
        super(emitter, portTypeEntry, "", "java", JavaUtils.getMessage("genIface00"), "interface");
        this.ptEntry = portTypeEntry;
        this.portType = portTypeEntry.getPortType();
        this.symbolTable = symbolTable;
        this.bEntry = bindingEntry;
        if (bindingEntry.hasLiteral()) {
            this.className = Utils.getJavaLocalName(bindingEntry.getName());
            this.fileName = this.className + ".java";
        }
    }

    public void write() throws IOException {
        String string = this.packageName + "." + this.className;
        if (!this.emitter.fileInfo.getClassNames().contains(string)) {
            super.write();
        }
    }

    protected void writeFileBody() throws IOException {
        this.pw.println("public interface " + this.className + " extends java.rmi.Remote {");
        Iterator iterator = this.portType.getOperations().iterator();
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            this.writeOperation(operation);
        }
        this.pw.println("}");
        this.pw.close();
    }

    private void writeOperation(Operation operation) throws IOException {
        this.writeComment(this.pw, operation.getDocumentationElement());
        Parameters parameters = this.bEntry.getParameters(operation);
        this.pw.println(parameters.signature + ";");
    }
}

