/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Parameter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaImplWriter
extends JavaWriter {
    private Binding binding;
    private SymbolTable symbolTable;
    private BindingEntry bEntry;

    protected JavaImplWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        super(emitter, bindingEntry, "Impl", "java", JavaUtils.getMessage("genImpl00"), "skeletonImpl");
        this.binding = bindingEntry.getBinding();
        this.symbolTable = symbolTable;
        this.bEntry = bindingEntry;
    }

    protected void writeFileBody() throws IOException {
        PortType portType = this.binding.getPortType();
        PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(portType.getQName());
        String string = this.bEntry.hasLiteral() ? this.bEntry.getName() : portTypeEntry.getName();
        this.pw.print("public class " + this.className + " implements " + string);
        this.pw.println(" {");
        List list = this.binding.getBindingOperations();
        int n = 0;
        while (n < list.size()) {
            BindingOperation bindingOperation = (BindingOperation)list.get(n);
            Operation operation = bindingOperation.getOperation();
            OperationType operationType = operation.getStyle();
            Parameters parameters = this.bEntry.getParameters(bindingOperation.getOperation());
            if (operationType == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE) {
                this.pw.println(parameters.signature);
                this.pw.println();
            } else {
                this.writeOperation(parameters);
            }
            ++n;
        }
        this.pw.println("}");
        this.pw.close();
    }

    private void writeOperation(Parameters parameters) throws IOException {
        Object object;
        this.pw.println(parameters.signature + " {");
        Iterator iterator = parameters.list.iterator();
        while (iterator.hasNext()) {
            object = (Parameter)iterator.next();
            String string = ((Parameter)object).type.getName();
            if (((Parameter)object).mode != 2) continue;
            this.pw.print("        " + Utils.xmlNameToJava(((Parameter)object).getName()) + ".value = ");
            if (this.isPrimitiveType(((Parameter)object).type)) {
                if ("boolean".equals(string)) {
                    this.pw.print("false");
                } else if ("byte".equals(string)) {
                    this.pw.print("(byte)-3");
                } else if ("short".equals(string)) {
                    this.pw.print("(short)-3");
                } else {
                    this.pw.print("-3");
                }
            } else if (string.equals("java.lang.Boolean")) {
                this.pw.print("new java.lang.Boolean(false)");
            } else if (string.equals("java.lang.Byte")) {
                this.pw.print("new java.lang.Byte((byte)-3)");
            } else if (string.equals("java.lang.Double")) {
                this.pw.print("new java.lang.Double(-3)");
            } else if (string.equals("java.lang.Float")) {
                this.pw.print("new java.lang.Float(-3)");
            } else if (string.equals("java.lang.Integer")) {
                this.pw.print("new java.lang.Integer(-3)");
            } else if (string.equals("java.lang.Long")) {
                this.pw.print("new java.lang.Long(-3)");
            } else if (string.equals("java.lang.Short")) {
                this.pw.print("new java.lang.Short((short)-3)");
            } else if (string.equals("java.math.BigDecimal")) {
                this.pw.print("new java.math.BigDecimal(-3)");
            } else if (string.equals("java.math.BigInteger")) {
                this.pw.print("new java.math.BigInteger(\"-3\")");
            } else if (string.equals("byte[]")) {
                this.pw.print("new byte[0]");
            } else if (string.equals("java.lang.Byte[]")) {
                this.pw.print("new java.lang.Byte[0]");
            } else {
                this.pw.print("new " + string + "()");
            }
            this.pw.println(";");
        }
        if (parameters.returnType != null) {
            this.pw.print("        return ");
            if (this.isPrimitiveType(parameters.returnType)) {
                object = parameters.returnType.getName();
                if ("boolean".equals(object)) {
                    this.pw.println("false;");
                } else if ("byte".equals(object)) {
                    this.pw.println("(byte)-3;");
                } else if ("short".equals(object)) {
                    this.pw.println("(short)-3;");
                } else {
                    this.pw.println("-3;");
                }
            } else {
                this.pw.println("null;");
            }
        }
        this.pw.println("    }");
        this.pw.println();
    }
}

