/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Vector;
import javax.wsdl.Fault;
import javax.wsdl.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaFaultWriter
extends JavaWriter {
    private Fault fault;
    private SymbolTable symbolTable;

    protected JavaFaultWriter(Emitter emitter, QName qName, Fault fault, SymbolTable symbolTable) {
        super(emitter, qName, "", "java", JavaUtils.getMessage("genFault00"), "fault");
        this.fault = fault;
        this.symbolTable = symbolTable;
    }

    protected void writeFileBody() throws IOException {
        this.pw.println("public class " + this.className + " extends org.apache.axis.AxisFault {");
        Vector vector = new Vector();
        this.symbolTable.partStrings(vector, this.fault.getMessage().getOrderedParts(null), false, this.fault.getName(), "unknown");
        int n = 0;
        while (n < vector.size()) {
            String string = ((TypeEntry)vector.get(n)).getName();
            String string2 = (String)vector.get(n + 1);
            this.pw.println("    public " + string + " " + string2 + ";");
            this.pw.println("    public " + string + " get" + Utils.capitalizeFirstChar(string2) + "() {");
            this.pw.println("        return this." + string2 + ";");
            this.pw.println("    }");
            n += 2;
        }
        this.pw.println();
        this.pw.println("    public " + this.className + "() {");
        this.pw.println("    }");
        this.pw.println();
        if (vector.size() > 0) {
            this.pw.print("      public " + this.className + "(");
            int n2 = 0;
            while (n2 < vector.size()) {
                if (n2 != 0) {
                    this.pw.print(", ");
                }
                this.pw.print(((TypeEntry)vector.get(n2)).getName() + " " + vector.get(n2 + 1));
                n2 += 2;
            }
            this.pw.println(") {");
            int n3 = 1;
            while (n3 < vector.size()) {
                String string = (String)vector.get(n3);
                this.pw.println("        this." + string + " = " + string + ";");
                n3 += 2;
            }
            this.pw.println("    }");
        }
        this.pw.println("}");
        this.pw.close();
    }
}

