/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Vector;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Node;

public class JavaEnumTypeWriter
extends JavaWriter {
    private TypeEntry type;
    private Vector elements;

    protected JavaEnumTypeWriter(Emitter emitter, TypeEntry typeEntry, Vector vector) {
        super(emitter, typeEntry, "", "java", JavaUtils.getMessage("genType00"), "enumType");
        this.type = typeEntry;
        this.elements = vector;
    }

    protected void writeFileBody() throws IOException {
        Object object;
        Node node = this.type.getNode();
        String string = Utils.getJavaLocalName(this.type.getName());
        String string2 = ((TypeEntry)this.elements.get(0)).getName();
        String string3 = "Object";
        if (string2.indexOf("String") >= 0) {
            string3 = "String";
        } else if (string2.indexOf("int") == 0) {
            string3 = "Integer";
        } else if (string2.indexOf("char") == 0) {
            string3 = "Character";
        } else if (string2.indexOf("short") == 0) {
            string3 = "Short";
        } else if (string2.indexOf("long") == 0) {
            string3 = "Long";
        } else if (string2.indexOf("double") == 0) {
            string3 = "Double";
        } else if (string2.indexOf("float") == 0) {
            string3 = "Float";
        } else if (string2.indexOf("byte") == 0) {
            string3 = "Byte";
        }
        Vector<Object> vector = new Vector<Object>();
        boolean bl = true;
        int n = 1;
        while (n < this.elements.size()) {
            object = (String)this.elements.get(n);
            if (!JavaUtils.isJavaId((String)object)) {
                bl = false;
            }
            if (string3.equals("String")) {
                object = "\"" + (String)object + "\"";
            } else if (string3.equals("Character")) {
                object = "'" + (String)object + "'";
            } else if (string3.equals("Float") && !((String)object).endsWith("F") && !((String)object).endsWith("f")) {
                object = (String)object + "F";
            }
            vector.add(object);
            ++n;
        }
        object = new Vector();
        int n2 = 1;
        while (n2 < this.elements.size()) {
            if (!bl) {
                ((Vector)object).add("value" + n2);
            } else {
                ((Vector)object).add(this.elements.get(n2));
            }
            ++n2;
        }
        this.pw.println("public class " + string + " implements java.io.Serializable {");
        this.pw.println("    private " + string2 + " _value_;");
        this.pw.println("    private static java.util.HashMap _table_ = new java.util.HashMap();");
        this.pw.println("");
        this.pw.println("    // " + JavaUtils.getMessage("ctor00"));
        this.pw.println("    protected " + string + "(" + string2 + " value) {");
        this.pw.println("        _value_ = value;");
        if (string3.equals("String")) {
            this.pw.println("        _table_.put(_value_,this);");
        } else {
            this.pw.println("        _table_.put(new " + string3 + "(_value_),this);");
        }
        this.pw.println("    };");
        this.pw.println("");
        int n3 = 0;
        while (n3 < ((Vector)object).size()) {
            this.pw.println("    public static final " + string2 + " _" + ((Vector)object).get(n3) + " = " + vector.get(n3) + ";");
            ++n3;
        }
        int n4 = 0;
        while (n4 < ((Vector)object).size()) {
            this.pw.println("    public static final " + string + " " + ((Vector)object).get(n4) + " = new " + string + "(_" + ((Vector)object).get(n4) + ");");
            ++n4;
        }
        this.pw.println("    public " + string2 + " getValue() { return _value_;}");
        this.pw.println("    public static " + string + " fromValue(" + string2 + " value)");
        this.pw.println("          throws java.lang.IllegalStateException {");
        this.pw.println("        " + string + " enum = (" + string + ")");
        if (string3.equals("String")) {
            this.pw.println("            _table_.get(value);");
        } else {
            this.pw.println("            _table_.get(new " + string3 + "(value));");
        }
        this.pw.println("        if (enum==null) throw new java.lang.IllegalStateException();");
        this.pw.println("        return enum;");
        this.pw.println("    }");
        this.pw.println("    public static " + string + " fromString(String value)");
        this.pw.println("          throws java.lang.IllegalStateException {");
        if (string3.equals("String")) {
            this.pw.println("        return fromValue(value);");
        } else if (string3.equals("Character")) {
            this.pw.println("        if (value != null && value.length() == 1);");
            this.pw.println("            return fromValue(value.charAt(0));");
            this.pw.println("        throw new java.lang.IllegalStateException();");
        } else if (string3.equals("Integer")) {
            this.pw.println("        try {");
            this.pw.println("            return fromValue(Integer.parseInt(value));");
            this.pw.println("        } catch (Exception e) {");
            this.pw.println("            throw new java.lang.IllegalStateException();");
            this.pw.println("        }");
        } else {
            this.pw.println("        try {");
            this.pw.println("            return fromValue(" + string3 + ".parse" + string3 + "(value));");
            this.pw.println("        } catch (Exception e) {");
            this.pw.println("            throw new java.lang.IllegalStateException();");
            this.pw.println("        }");
        }
        this.pw.println("    }");
        this.pw.println("    public boolean equals(Object obj) {return (obj == this);}");
        this.pw.println("    public int hashCode() { return toString().hashCode();}");
        if (string3.equals("String")) {
            this.pw.println("    public String toString() { return _value_;}");
        } else {
            this.pw.println("    public String toString() { return String.valueOf(_value_);}");
        }
        this.pw.println("}");
        this.pw.close();
    }
}

