/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.GeneratedFileInfo;
import org.apache.axis.wsdl.toJava.MessageEntry;
import org.apache.axis.wsdl.toJava.Namespaces;
import org.apache.axis.wsdl.toJava.NoopWriterFactory;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.ServiceEntry;
import org.apache.axis.wsdl.toJava.SymTabEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Writer;
import org.apache.axis.wsdl.toJava.WriterFactory;
import org.w3c.dom.Document;

public class Emitter {
    public static final byte NO_EXPLICIT_SCOPE = 0;
    public static final byte APPLICATION_SCOPE = 1;
    public static final byte REQUEST_SCOPE = 16;
    public static final byte SESSION_SCOPE = 17;
    protected Document doc = null;
    protected Definition def = null;
    protected boolean bDebug = false;
    protected boolean bEmitSkeleton = false;
    protected boolean bDeploySkeleton = true;
    protected boolean bEmitTestCase = false;
    protected boolean bVerbose = false;
    protected boolean bGenerateImports = true;
    protected boolean bGenerateAll = false;
    protected String outputDir = null;
    protected String packageName = null;
    protected byte scope = 0;
    protected GeneratedFileInfo fileInfo = new GeneratedFileInfo();
    protected Namespaces namespaces = null;
    protected HashMap delaySetMap = null;
    protected WriterFactory writerFactory = null;
    protected SymbolTable symbolTable = null;
    protected String currentWSDLURI = null;
    protected File NStoPkg = new File("NStoPkg.properties");
    private static final int HELP_OPT = 104;
    private static final int VERBOSE_OPT = 118;
    private static final int DEBUG_OPT = 68;
    private static final CLOptionDescriptor[] options = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, JavaUtils.getMessage("optionHelp00")), new CLOptionDescriptor("verbose", 8, 118, JavaUtils.getMessage("optionVerbose00")), new CLOptionDescriptor("Debug", 8, 68, JavaUtils.getMessage("optionDebug00"))};
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$Emitter;

    public Emitter(WriterFactory writerFactory) {
        this.writerFactory = writerFactory;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public void emit(String string) throws IOException, WSDLException {
        if (this.bVerbose) {
            System.out.println(JavaUtils.getMessage("parsing00", string));
        }
        this.emit(string, XMLUtils.newDocument(string));
    }

    public void emit(String string, Document document) throws IOException, WSDLException {
        this.currentWSDLURI = string;
        WSDLReader wSDLReader = WSDLFactory.newInstance().newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", this.bVerbose);
        this.def = wSDLReader.readWSDL(string, document);
        this.doc = document;
        this.namespaces = new Namespaces(this.outputDir);
        if (this.packageName != null) {
            this.namespaces.setDefaultPackage(this.packageName);
        } else {
            this.getNStoPkgFromPropsFile(this.namespaces);
            if (this.delaySetMap != null) {
                this.namespaces.putAll((Map)this.delaySetMap);
            }
        }
        this.symbolTable = new SymbolTable(this.namespaces, this.writerFactory.getBaseTypeMapping(), this.bGenerateImports, this.bDebug);
        this.symbolTable.add(string, this.def, document);
        this.writerFactory.writerPass(this.def, this.symbolTable);
        if (this.bDebug) {
            this.symbolTable.dump(System.out);
        }
        this.emit(this.def, document);
        Writer writer = this.writerFactory.getWriter(this.def, this.symbolTable);
        writer.write();
        this.currentWSDLURI = null;
    }

    private void emit(Definition definition, Document document) throws IOException, WSDLException {
        this.writeTypes();
        Iterator iterator = this.symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            int n = 0;
            while (n < vector.size()) {
                block7: {
                    Writer writer;
                    block5: {
                        SymTabEntry symTabEntry;
                        block8: {
                            SymTabEntry symTabEntry2;
                            block6: {
                                block4: {
                                    symTabEntry = (SymTabEntry)vector.elementAt(n);
                                    writer = null;
                                    if (!(symTabEntry instanceof MessageEntry)) break block4;
                                    writer = this.writerFactory.getWriter(((MessageEntry)symTabEntry).getMessage(), this.symbolTable);
                                    break block5;
                                }
                                if (!(symTabEntry instanceof PortTypeEntry)) break block6;
                                symTabEntry2 = (PortTypeEntry)symTabEntry;
                                if (((PortTypeEntry)symTabEntry2).getPortType().isUndefined()) break block7;
                                writer = this.writerFactory.getWriter(((PortTypeEntry)symTabEntry2).getPortType(), this.symbolTable);
                                break block5;
                            }
                            if (!(symTabEntry instanceof BindingEntry)) break block8;
                            symTabEntry2 = (BindingEntry)symTabEntry;
                            Binding binding = ((BindingEntry)symTabEntry2).getBinding();
                            if (binding.isUndefined()) break block7;
                            writer = this.writerFactory.getWriter(binding, this.symbolTable);
                            break block5;
                        }
                        if (symTabEntry instanceof ServiceEntry) {
                            writer = this.writerFactory.getWriter(((ServiceEntry)symTabEntry).getService(), this.symbolTable);
                        }
                    }
                    if (writer != null) {
                        writer.write();
                    }
                }
                ++n;
            }
        }
    }

    private void getNStoPkgFromPropsFile(HashMap hashMap) {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(this.NStoPkg));
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                try {
                    String string = (String)enumeration.nextElement();
                    hashMap.put(string, properties.getProperty(string));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void generateSkeleton(boolean bl) {
        this.bEmitSkeleton = bl;
    }

    public boolean getGenerateSkeleton() {
        return this.bEmitSkeleton;
    }

    public void deploySkeleton(boolean bl) {
        this.bDeploySkeleton = bl;
    }

    public boolean getDeploySkeleton() {
        return this.bDeploySkeleton;
    }

    public void generateTestCase(boolean bl) {
        this.bEmitTestCase = bl;
    }

    public Definition getCurrentDefinition() {
        return this.def;
    }

    public void generateImports(boolean bl) {
        this.bGenerateImports = bl;
    }

    public void generateAll(boolean bl) {
        this.bGenerateAll = bl;
    }

    public void debug(boolean bl) {
        this.bDebug = bl;
    }

    public boolean getDebug() {
        return this.bDebug;
    }

    public void verbose(boolean bl) {
        this.bVerbose = bl;
    }

    public boolean getVerbose() {
        return this.bVerbose;
    }

    public void setNamespaceMap(HashMap hashMap) {
        this.delaySetMap = hashMap;
    }

    public HashMap getNamespaceMap() {
        return this.delaySetMap;
    }

    public void setOutputDir(String string) {
        this.outputDir = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setScope(byte by) {
        this.scope = by;
    }

    public byte getScope() {
        return this.scope;
    }

    public void setNStoPkg(File file) {
        this.NStoPkg = file;
    }

    public List getGeneratedClassNames() {
        return this.fileInfo.getClassNames();
    }

    public List getGeneratedFileNames() {
        return this.fileInfo.getFileNames();
    }

    public GeneratedFileInfo getGeneratedFileInfo() {
        return this.fileInfo;
    }

    protected void writeTypes() throws IOException {
        Vector vector = this.symbolTable.getTypes();
        int n = 0;
        while (n < vector.size()) {
            TypeEntry typeEntry = (TypeEntry)vector.elementAt(n);
            if (typeEntry.getNode() != null && typeEntry.isReferenced() && typeEntry.getBaseType() == null) {
                Writer writer = this.writerFactory.getWriter(typeEntry, this.symbolTable);
                writer.write();
            }
            ++n;
        }
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    public String getWSDLURI() {
        return this.currentWSDLURI;
    }

    private static void printUsage() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("java " + (class$org$apache$axis$wsdl$toJava$Emitter == null ? (class$org$apache$axis$wsdl$toJava$Emitter = Emitter.class$("org.apache.axis.wsdl.toJava.Emitter")) : class$org$apache$axis$wsdl$toJava$Emitter).getName() + " [options] WSDL-URI").append(string);
        stringBuffer.append(string);
        stringBuffer.append(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
        System.out.println(stringBuffer.toString());
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        String string = null;
        HashMap hashMap = new HashMap();
        Emitter emitter = new Emitter(new NoopWriterFactory());
        CLArgsParser cLArgsParser = new CLArgsParser(stringArray, options);
        if (null != cLArgsParser.getErrorString()) {
            Emitter.printUsage();
        }
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        try {
            int n2 = 0;
            while (n2 < n) {
                CLOption cLOption = (CLOption)vector.get(n2);
                switch (cLOption.getId()) {
                    case 0: {
                        if (string != null) {
                            Emitter.printUsage();
                        }
                        string = cLOption.getArgument();
                        break;
                    }
                    case 104: {
                        Emitter.printUsage();
                        break;
                    }
                    case 118: {
                        emitter.verbose(true);
                        break;
                    }
                    case 68: {
                        emitter.debug(true);
                    }
                }
                ++n2;
            }
            if (string == null) {
                Emitter.printUsage();
            }
            emitter.emit(string);
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

