/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class tcpmon
extends JFrame {
    private JTabbedPane notebook = new JTabbedPane();
    private static int STATE_COLUMN = 0;
    private static int TIME_COLUMN = 1;
    private static int INHOST_COLUMN = 2;
    private static int OUTHOST_COLUMN = 3;
    private static int REQ_COLUMN = 4;
    private static ResourceBundle messages = null;

    public tcpmon(int n, String string, int n2) {
        super(tcpmon.getMessage("tcpmon00", "TCPMonitor"));
        this.getContentPane().add(this.notebook);
        new AdminPage(this.notebook, tcpmon.getMessage("admin00", "Admin"));
        if (n != 0) {
            Listener listener = null;
            listener = string == null ? new Listener(this.notebook, null, n, string, n2, true) : new Listener(this.notebook, null, n, string, n2, false);
            this.notebook.setSelectedIndex(1);
            listener.HTTPProxyHost = System.getProperty("http.proxyHost");
            if (listener.HTTPProxyHost != null && listener.HTTPProxyHost.equals("")) {
                listener.HTTPProxyHost = null;
            }
            if (listener.HTTPProxyHost != null) {
                String string2 = System.getProperty("http.proxyPort");
                if (string2 != null && string2.equals("")) {
                    string2 = null;
                }
                listener.HTTPProxyPort = string2 == null ? 80 : Integer.parseInt(string2);
            }
        }
        this.pack();
        this.setSize(600, 600);
        this.setVisible(true);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 201: {
                this.exit();
                break;
            }
            default: {
                super.processWindowEvent(windowEvent);
            }
        }
    }

    private void exit() {
        System.exit(0);
    }

    public void setInputPort(int n) {
    }

    public void setOutputHostPort(char c, int n) {
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 3) {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[2]);
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new tcpmon(n, stringArray[1], n2);
            } else if (stringArray.length == 1) {
                int n = Integer.parseInt(stringArray[0]);
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new tcpmon(n, null, 0);
            } else if (stringArray.length != 0) {
                System.err.println(tcpmon.getMessage("usage00", "Usage:") + " tcpmon [listenPort targetHost targetPort]\n");
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new tcpmon(0, null, 0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static String getMessage(String string, String string2) {
        try {
            if (messages == null) {
                tcpmon.initializeMessages();
            }
            return messages.getString(string);
        }
        catch (Throwable throwable) {
            return string2;
        }
    }

    private static void initializeMessages() {
        messages = ResourceBundle.getBundle("org.apache.axis.utils.tcpmon");
    }

    class Listener
    extends JPanel {
        public Socket inputSocket = null;
        public Socket outputSocket = null;
        public JTextField portField = null;
        public JTextField hostField = null;
        public JTextField tPortField = null;
        public JCheckBox isProxyBox = null;
        public JButton stopButton = null;
        public JButton removeButton = null;
        public JButton removeAllButton = null;
        public JCheckBox xmlFormatBox = null;
        public JButton saveButton = null;
        public JButton resendButton = null;
        public JButton switchButton = null;
        public JButton closeButton = null;
        public JTable connectionTable = null;
        public DefaultTableModel tableModel = null;
        public JSplitPane outPane = null;
        public ServerSocket sSocket = null;
        public SocketWaiter sw = null;
        public JPanel leftPanel = null;
        public JPanel rightPanel = null;
        public JTabbedPane notebook = null;
        public String HTTPProxyHost = null;
        public int HTTPProxyPort = 80;
        public final Vector connections = new Vector();

        public Listener(JTabbedPane jTabbedPane, String string, int n, String string2, int n2, boolean bl) {
            this.notebook = jTabbedPane;
            if (string == null) {
                string = tcpmon.getMessage("port01", "Port") + " " + n;
            }
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            String string3 = tcpmon.getMessage("start00", "Start");
            this.stopButton = new JButton(string3);
            jPanel.add(this.stopButton);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel.add(new JLabel("  " + tcpmon.getMessage("listenPort01", "Listen Port:") + " ", 4));
            this.portField = new JTextField("" + n, 4);
            jPanel.add(this.portField);
            jPanel.add(new JLabel("  " + tcpmon.getMessage("host00", "Host:"), 4));
            this.hostField = new JTextField(string2, 30);
            jPanel.add(this.hostField);
            jPanel.add(new JLabel("  " + tcpmon.getMessage("port02", "Port:") + " ", 4));
            this.tPortField = new JTextField("" + n2, 4);
            jPanel.add(this.tPortField);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.isProxyBox = new JCheckBox(tcpmon.getMessage("proxy00", "Proxy"));
            jPanel.add(this.isProxyBox);
            this.isProxyBox.addChangeListener(new BasicButtonListener(this, this.isProxyBox){
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = listener;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    JCheckBox jCheckBox = (JCheckBox)changeEvent.getSource();
                    boolean bl = jCheckBox.isSelected();
                    this.this$1.tPortField.setEnabled(!bl);
                    this.this$1.hostField.setEnabled(!bl);
                }
            });
            this.isProxyBox.setSelected(bl);
            this.portField.setEditable(false);
            this.portField.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
            this.hostField.setEditable(false);
            this.hostField.setMaximumSize(new Dimension(85, Short.MAX_VALUE));
            this.tPortField.setEditable(false);
            this.tPortField.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
            this.stopButton.addActionListener(new ActionListener(this, string3){
                private final /* synthetic */ String val$start;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = listener;
                    this.val$start = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (tcpmon.getMessage("stop00", "Stop").equals(actionEvent.getActionCommand())) {
                        this.this$1.stop();
                    }
                    if (this.val$start.equals(actionEvent.getActionCommand())) {
                        this.this$1.start();
                    }
                }
            });
            this.add((Component)jPanel, "North");
            this.tableModel = new DefaultTableModel(new String[]{tcpmon.getMessage("state00", "State"), tcpmon.getMessage("time00", "Time"), tcpmon.getMessage("requestHost00", "Request Host"), tcpmon.getMessage("targetHost", "Target Host"), tcpmon.getMessage("request00", "Request...")}, 0);
            this.connectionTable = new JTable(1, 2);
            this.connectionTable.setModel(this.tableModel);
            this.connectionTable.setSelectionMode(2);
            TableColumn tableColumn = this.connectionTable.getColumnModel().getColumn(STATE_COLUMN);
            tableColumn.setMaxWidth(tableColumn.getPreferredWidth() / 2);
            tableColumn = this.connectionTable.getColumnModel().getColumn(REQ_COLUMN);
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() * 2);
            ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = listener;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    int n = this.this$1.outPane.getDividerLocation();
                    if (listSelectionModel.isSelectionEmpty()) {
                        this.this$1.setLeft(new JLabel(" " + tcpmon.getMessage("wait00", "Waiting for Connection...")));
                        this.this$1.setRight(new JLabel(""));
                        this.this$1.removeButton.setEnabled(false);
                        this.this$1.removeAllButton.setEnabled(false);
                        this.this$1.saveButton.setEnabled(false);
                        this.this$1.resendButton.setEnabled(false);
                    } else {
                        int n2 = listSelectionModel.getLeadSelectionIndex();
                        if (n2 == 0) {
                            if (this.this$1.connections.size() == 0) {
                                this.this$1.setLeft(new JLabel(" " + tcpmon.getMessage("wait00", "Waiting for connection...")));
                                this.this$1.setRight(new JLabel(""));
                                this.this$1.removeButton.setEnabled(false);
                                this.this$1.removeAllButton.setEnabled(false);
                                this.this$1.saveButton.setEnabled(false);
                                this.this$1.resendButton.setEnabled(false);
                            } else {
                                Connection connection = (Connection)this.this$1.connections.lastElement();
                                this.this$1.setLeft(connection.inputScroll);
                                this.this$1.setRight(connection.outputScroll);
                                this.this$1.removeButton.setEnabled(false);
                                this.this$1.removeAllButton.setEnabled(true);
                                this.this$1.saveButton.setEnabled(true);
                                this.this$1.resendButton.setEnabled(true);
                            }
                        } else {
                            Connection connection = (Connection)this.this$1.connections.get(n2 - 1);
                            this.this$1.setLeft(connection.inputScroll);
                            this.this$1.setRight(connection.outputScroll);
                            this.this$1.removeButton.setEnabled(true);
                            this.this$1.removeAllButton.setEnabled(true);
                            this.this$1.saveButton.setEnabled(true);
                            this.this$1.resendButton.setEnabled(true);
                        }
                    }
                    this.this$1.outPane.setDividerLocation(n);
                }
            });
            this.tableModel.addRow(new Object[]{"---", tcpmon.getMessage("mostRecent00", "Most Recent"), "---", "---", "---"});
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(this.connectionTable);
            jPanel2.add((Component)jScrollPane, "Center");
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            String string4 = tcpmon.getMessage("removeSelected00", "Remove Selected");
            this.removeButton = new JButton(string4);
            jPanel3.add(this.removeButton);
            jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
            String string5 = tcpmon.getMessage("removeAll00", "Remove All");
            this.removeAllButton = new JButton(string5);
            jPanel3.add(this.removeAllButton);
            jPanel2.add((Component)jPanel3, "South");
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(new ActionListener(this, string4){
                private final /* synthetic */ String val$removeSelected;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = listener;
                    this.val$removeSelected = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$removeSelected.equals(actionEvent.getActionCommand())) {
                        this.this$1.remove();
                    }
                }
            });
            this.removeAllButton.setEnabled(false);
            this.removeAllButton.addActionListener(new ActionListener(this, string5){
                private final /* synthetic */ String val$removeAll;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = listener;
                    this.val$removeAll = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$removeAll.equals(actionEvent.getActionCommand())) {
                        this.this$1.removeAll();
                    }
                }
            });
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            this.leftPanel = new JPanel();
            this.leftPanel.setAlignmentX(0.0f);
            this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
            this.leftPanel.add(new JLabel("  " + tcpmon.getMessage("request01", "Request")));
            this.leftPanel.add(new JLabel(" " + tcpmon.getMessage("wait01", "Waiting for connection")));
            this.rightPanel = new JPanel();
            this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
            this.rightPanel.add(new JLabel("  " + tcpmon.getMessage("response00", "Response")));
            this.rightPanel.add(new JLabel(""));
            this.outPane = new JSplitPane(0, this.leftPanel, this.rightPanel);
            this.outPane.setDividerSize(4);
            jPanel4.add((Component)this.outPane, "Center");
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.xmlFormatBox = new JCheckBox(tcpmon.getMessage("xmlFormat00", "XML Format"));
            jPanel5.add(this.xmlFormatBox);
            jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
            String string6 = tcpmon.getMessage("save00", "Save");
            this.saveButton = new JButton(string6);
            jPanel5.add(this.saveButton);
            jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
            String string7 = tcpmon.getMessage("resend00", "Resend");
            this.resendButton = new JButton(string7);
            jPanel5.add(this.resendButton);
            jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
            String string8 = tcpmon.getMessage("switch00", "Switch Layout");
            this.switchButton = new JButton(string8);
            jPanel5.add(this.switchButton);
            jPanel5.add(Box.createHorizontalGlue());
            String string9 = tcpmon.getMessage("close00", "Close");
            this.closeButton = new JButton(string9);
            jPanel5.add(this.closeButton);
            jPanel4.add((Component)jPanel5, "South");
            this.saveButton.setEnabled(false);
            this.saveButton.addActionListener(new ActionListener(this, string6){
                private final /* synthetic */ String val$save;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = listener;
                    this.val$save = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$save.equals(actionEvent.getActionCommand())) {
                        this.this$1.save();
                    }
                }
            });
            this.resendButton.setEnabled(false);
            this.resendButton.addActionListener(new ActionListener(this, string7){
                private final /* synthetic */ String val$resend;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = listener;
                    this.val$resend = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$resend.equals(actionEvent.getActionCommand())) {
                        this.this$1.resend();
                    }
                }
            });
            this.switchButton.addActionListener(new ActionListener(this, string8){
                private final /* synthetic */ String val$switchStr;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = listener;
                    this.val$switchStr = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$switchStr.equals(actionEvent.getActionCommand())) {
                        int n = this.this$1.outPane.getOrientation();
                        if (n == 0) {
                            this.this$1.outPane.setOrientation(1);
                        } else {
                            this.this$1.outPane.setOrientation(0);
                        }
                        this.this$1.outPane.setDividerLocation(0.5);
                    }
                }
            });
            this.closeButton.addActionListener(new ActionListener(this, string9){
                private final /* synthetic */ String val$close;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = listener;
                    this.val$close = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$close.equals(actionEvent.getActionCommand())) {
                        this.this$1.close();
                    }
                }
            });
            JSplitPane jSplitPane = new JSplitPane(0);
            jSplitPane.setDividerSize(4);
            jSplitPane.setTopComponent(jPanel2);
            jSplitPane.setBottomComponent(jPanel4);
            jSplitPane.setDividerLocation(150);
            this.add((Component)jSplitPane, "Center");
            listSelectionModel.setSelectionInterval(0, 0);
            this.outPane.setDividerLocation(150);
            this.notebook.addTab(string, this);
            this.start();
        }

        public void setLeft(Component component) {
            this.leftPanel.remove(1);
            this.leftPanel.add(component);
        }

        public void setRight(Component component) {
            this.rightPanel.remove(1);
            this.rightPanel.add(component);
        }

        public void start() {
            int n = Integer.parseInt(this.portField.getText());
            this.portField.setText("" + n);
            int n2 = this.notebook.indexOfComponent(this);
            this.notebook.setTitleAt(n2, tcpmon.getMessage("port01", "Port") + " " + n);
            int n3 = Integer.parseInt(this.tPortField.getText());
            this.tPortField.setText("" + n3);
            this.sw = new SocketWaiter(this, n);
            this.stopButton.setText(tcpmon.getMessage("stop00", "Stop"));
            this.portField.setEditable(false);
            this.hostField.setEditable(false);
            this.tPortField.setEditable(false);
            this.isProxyBox.setEnabled(false);
        }

        public void close() {
            this.stop();
            this.notebook.remove(this);
        }

        public void stop() {
            try {
                int n = 0;
                while (n < this.connections.size()) {
                    Connection connection = (Connection)this.connections.get(n);
                    connection.halt();
                    ++n;
                }
                this.sw.halt();
                this.stopButton.setText(tcpmon.getMessage("start00", "Start"));
                this.portField.setEditable(true);
                this.hostField.setEditable(true);
                this.tPortField.setEditable(true);
                this.isProxyBox.setEnabled(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void remove() {
            int n;
            ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
            int n2 = listSelectionModel.getMinSelectionIndex();
            int n3 = n = listSelectionModel.getMaxSelectionIndex();
            while (n3 >= n2) {
                ((Connection)this.connections.get(n3 - 1)).remove();
                --n3;
            }
            if (n2 > this.connections.size()) {
                n2 = this.connections.size();
            }
            listSelectionModel.setSelectionInterval(n2, n2);
        }

        public void removeAll() {
            while (this.connections.size() > 0) {
                ((Connection)this.connections.get(0)).remove();
            }
            ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
            listSelectionModel.clearSelection();
            listSelectionModel.setSelectionInterval(0, 0);
        }

        public void save() {
            JFileChooser jFileChooser = new JFileChooser(".");
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                try {
                    File file = jFileChooser.getSelectedFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
                    n = listSelectionModel.getLeadSelectionIndex();
                    if (n == 0) {
                        n = this.connections.size();
                    }
                    Connection connection = (Connection)this.connections.get(n - 1);
                    n = Integer.parseInt(this.portField.getText());
                    fileOutputStream.write(new String(tcpmon.getMessage("listenPort01", "Listen Port:") + " " + n + "\n").getBytes());
                    fileOutputStream.write(new String(tcpmon.getMessage("targetHost01", "Target Host:") + " " + this.hostField.getText() + "\n").getBytes());
                    n = Integer.parseInt(this.tPortField.getText());
                    fileOutputStream.write(new String(tcpmon.getMessage("targetPort01", "Target Port:") + " " + n + "\n").getBytes());
                    fileOutputStream.write(new String("==== " + tcpmon.getMessage("request01", "Request") + " ====\n").getBytes());
                    fileOutputStream.write(connection.inputText.getText().getBytes());
                    fileOutputStream.write(new String("==== " + tcpmon.getMessage("response00", "Response") + " ====\n").getBytes());
                    fileOutputStream.write(connection.outputText.getText().getBytes());
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void resend() {
            try {
                ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
                int n = listSelectionModel.getLeadSelectionIndex();
                if (n == 0) {
                    n = this.connections.size();
                }
                Connection connection = (Connection)this.connections.get(n - 1);
                if (n > 0) {
                    listSelectionModel.clearSelection();
                    listSelectionModel.setSelectionInterval(0, 0);
                }
                ByteArrayInputStream byteArrayInputStream = null;
                byteArrayInputStream = new ByteArrayInputStream(connection.inputText.getText().getBytes());
                new Connection(this, byteArrayInputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class Connection
    extends Thread {
        Listener listener;
        boolean active;
        String fromHost;
        String time;
        JTextArea inputText;
        JScrollPane inputScroll;
        JTextArea outputText;
        JScrollPane outputScroll;
        Socket inSocket;
        Socket outSocket;
        Thread clientThread;
        Thread serverThread;
        SocketRR rr1 = null;
        SocketRR rr2 = null;
        InputStream inputStream;
        String HTTPProxyHost = null;
        int HTTPProxyPort = 80;

        public Connection(Listener listener) {
            this.listener = listener;
            this.HTTPProxyHost = listener.HTTPProxyHost;
            this.HTTPProxyPort = listener.HTTPProxyPort;
        }

        public Connection(Listener listener, Socket socket) {
            this(listener);
            this.inSocket = socket;
            this.start();
        }

        public Connection(Listener listener, InputStream inputStream) {
            this(listener);
            this.inputStream = inputStream;
            this.start();
        }

        public void run() {
            try {
                Object object;
                this.active = true;
                this.HTTPProxyHost = System.getProperty("http.proxyHost");
                if (this.HTTPProxyHost != null && this.HTTPProxyHost.equals("")) {
                    this.HTTPProxyHost = null;
                }
                if (this.HTTPProxyHost != null) {
                    object = System.getProperty("http.proxyPort");
                    if (object != null && ((String)object).equals("")) {
                        object = null;
                    }
                    this.HTTPProxyPort = object == null ? 80 : Integer.parseInt((String)object);
                }
                if (this.inSocket != null) {
                    object = this.inSocket.getInetAddress();
                    this.fromHost = ((InetAddress)object).getHostName();
                } else {
                    this.fromHost = "resend";
                }
                object = new SimpleDateFormat("MM/dd/yy hh:mm:ss aa");
                this.time = ((DateFormat)object).format(new Date());
                int n = this.listener.connections.size();
                this.listener.tableModel.insertRow(n + 1, new Object[]{tcpmon.getMessage("active00", "Active"), this.time, this.fromHost, this.listener.hostField.getText(), ""});
                this.listener.connections.add(this);
                this.inputText = new JTextArea(null, null, 20, 80);
                this.inputScroll = new JScrollPane(this.inputText);
                this.outputText = new JTextArea(null, null, 20, 80);
                this.outputScroll = new JScrollPane(this.outputText);
                ListSelectionModel listSelectionModel = this.listener.connectionTable.getSelectionModel();
                if (n == 0 || listSelectionModel.getLeadSelectionIndex() == 0) {
                    this.listener.outPane.setVisible(false);
                    int n2 = this.listener.outPane.getDividerLocation();
                    this.listener.setLeft(this.inputScroll);
                    this.listener.setRight(this.outputScroll);
                    this.listener.removeButton.setEnabled(false);
                    this.listener.removeAllButton.setEnabled(true);
                    this.listener.saveButton.setEnabled(true);
                    this.listener.resendButton.setEnabled(true);
                    this.listener.outPane.setDividerLocation(n2);
                    this.listener.outPane.setVisible(true);
                }
                String string = this.listener.hostField.getText();
                int n3 = Integer.parseInt(this.listener.tPortField.getText());
                InputStream inputStream = this.inputStream;
                OutputStream outputStream = null;
                InputStream inputStream2 = null;
                OutputStream outputStream2 = null;
                if (inputStream == null) {
                    inputStream = this.inSocket.getInputStream();
                }
                if (this.inSocket != null) {
                    outputStream = this.inSocket.getOutputStream();
                }
                String string2 = null;
                StringBuffer stringBuffer = null;
                int n4 = this.listener.connections.indexOf(this);
                if (this.listener.isProxyBox.isSelected() || this.HTTPProxyHost != null) {
                    int n5;
                    byte[] byArray = new byte[1];
                    stringBuffer = new StringBuffer();
                    while ((n5 = inputStream.read(byArray, 0, 1)) != -1) {
                        String string3 = new String(byArray);
                        stringBuffer.append(string3);
                        if (byArray[0] != 10) continue;
                    }
                    string2 = stringBuffer.toString();
                    this.inputText.append(string2);
                    if (string2.startsWith("GET ") || string2.startsWith("POST ")) {
                        URL uRL;
                        n5 = string2.indexOf(32) + 1;
                        while (string2.charAt(n5) == ' ') {
                            ++n5;
                        }
                        int n6 = string2.indexOf(32, n5);
                        String string4 = string2.substring(n5, n6);
                        if (string4.charAt(0) == '/') {
                            string4 = string4.substring(1);
                        }
                        if (this.listener.isProxyBox.isSelected()) {
                            uRL = new URL(string4);
                            string = uRL.getHost();
                            n3 = uRL.getPort();
                            if (n3 == -1) {
                                n3 = 80;
                            }
                            this.listener.tableModel.setValueAt(string, n4 + 1, OUTHOST_COLUMN);
                            string2 = string2.substring(0, n5) + uRL.getFile() + string2.substring(n6);
                        } else {
                            uRL = new URL("http://" + string + ":" + n3 + "/" + string4);
                            this.listener.tableModel.setValueAt(string, n4 + 1, OUTHOST_COLUMN);
                            string2 = string2.substring(0, n5) + uRL.toExternalForm() + string2.substring(n6);
                            string = this.HTTPProxyHost;
                            n3 = this.HTTPProxyPort;
                        }
                    }
                }
                if (n3 == -1) {
                    n3 = 80;
                }
                this.outSocket = new Socket(string, n3);
                inputStream2 = this.outSocket.getInputStream();
                outputStream2 = this.outSocket.getOutputStream();
                if (string2 != null) {
                    byte[] byArray = string2.getBytes();
                    outputStream2.write(byArray);
                }
                boolean bl = this.listener.xmlFormatBox.isSelected();
                this.rr1 = new SocketRR(this.inSocket, inputStream, this.outSocket, outputStream2, this.inputText, bl, this.listener.tableModel, n4 + 1);
                this.rr2 = new SocketRR(this.outSocket, inputStream2, this.inSocket, outputStream, this.outputText, bl, null, 0);
                while (!this.rr1.isDone() && !this.rr2.isDone()) {
                    Thread.sleep(10L);
                }
                this.rr1.halt();
                this.rr2.halt();
                this.rr1 = null;
                this.rr2 = null;
                this.active = false;
                if (n4 >= 0) {
                    this.listener.tableModel.setValueAt(tcpmon.getMessage("done00", "Done"), 1 + n4, STATE_COLUMN);
                }
            }
            catch (Exception exception) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                int n = this.listener.connections.indexOf(this);
                if (n >= 0) {
                    this.listener.tableModel.setValueAt(tcpmon.getMessage("error00", "Error"), 1 + n, STATE_COLUMN);
                }
                exception.printStackTrace(printWriter);
                printWriter.close();
                this.outputText.append(stringWriter.toString());
                this.halt();
            }
        }

        public void halt() {
            try {
                if (this.rr1 != null) {
                    this.rr1.halt();
                }
                if (this.rr2 != null) {
                    this.rr2.halt();
                }
                if (this.inSocket != null) {
                    this.inSocket.close();
                }
                this.inSocket = null;
                if (this.outSocket != null) {
                    this.outSocket.close();
                }
                this.outSocket = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void remove() {
            try {
                this.halt();
                int n = this.listener.connections.indexOf(this);
                this.listener.tableModel.removeRow(n + 1);
                this.listener.connections.remove(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class SocketRR
    extends Thread {
        Socket inSocket = null;
        Socket outSocket = null;
        JTextArea textArea;
        InputStream in = null;
        OutputStream out = null;
        boolean xmlFormat;
        boolean done = false;
        TableModel tmodel = null;
        int tableIndex = 0;

        public SocketRR(Socket socket, InputStream inputStream, Socket socket2, OutputStream outputStream, JTextArea jTextArea, boolean bl, TableModel tableModel, int n) {
            this.inSocket = socket;
            this.in = inputStream;
            this.outSocket = socket2;
            this.out = outputStream;
            this.textArea = jTextArea;
            this.xmlFormat = bl;
            this.tmodel = tableModel;
            this.tableIndex = n;
            this.start();
        }

        public boolean isDone() {
            return this.done;
        }

        public void run() {
            try {
                byte[] byArray = new byte[4096];
                byte[] byArray2 = new byte[8192];
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                while (true) {
                    int n4;
                    int n5;
                    if ((n5 = this.in.available()) == 0) {
                        n5 = 1;
                    }
                    if (n + n5 > 4096) {
                        n5 = 4096 - n;
                    }
                    if ((n5 = this.in.read(byArray, n, n5)) == -1) break;
                    if (this.out != null) {
                        this.out.write(byArray, n, n5);
                    }
                    if (this.tmodel != null && n2 < 50) {
                        String string = (String)this.tmodel.getValueAt(this.tableIndex, REQ_COLUMN);
                        if ((string = string + new String(byArray, n, n5)).length() > 50) {
                            string = string.substring(0, 50);
                        }
                        n2 = string.length();
                        n4 = string.indexOf(10);
                        if (n4 > 0) {
                            string = string.substring(0, n4 - 1);
                            n2 = 50;
                        }
                        this.tmodel.setValueAt(string, this.tableIndex, REQ_COLUMN);
                    }
                    if (this.xmlFormat) {
                        int n6 = 0;
                        int n7 = 0;
                        n = 0;
                        while (n6 < n5) {
                            if (byArray[n6] != 60 && byArray[n6] != 47) {
                                byArray2[n7++] = byArray[n6];
                            } else if (n6 + 1 < n5) {
                                byte by = byArray[n6];
                                byte by2 = byArray[n6 + 1];
                                int n8 = -1;
                                if (by == 60) {
                                    n8 = by2 != 47 ? n3++ : --n3;
                                } else if (by == 47 && by2 == 62) {
                                    --n3;
                                }
                                if (n8 != -1) {
                                    byArray2[n7++] = 10;
                                    n4 = 0;
                                    while (n4 < n8) {
                                        byArray2[n7++] = 32;
                                        ++n4;
                                    }
                                }
                                byArray2[n7++] = byArray[n6];
                            } else {
                                n = 1;
                            }
                            ++n6;
                        }
                        this.textArea.append(new String(byArray2, 0, n7));
                    } else {
                        this.textArea.append(new String(byArray, 0, n5));
                    }
                    SocketRR.sleep(3L);
                }
                SocketRR.sleep(3L);
                this.done = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void halt() {
            try {
                if (this.inSocket != null) {
                    this.inSocket.close();
                }
                if (this.outSocket != null) {
                    this.outSocket.close();
                }
                this.inSocket = null;
                this.outSocket = null;
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
                this.in = null;
                this.out = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class SocketWaiter
    extends Thread {
        ServerSocket sSocket = null;
        Listener listener;
        int port;
        boolean pleaseStop = false;

        public SocketWaiter(Listener listener, int n) {
            this.listener = listener;
            this.port = n;
            this.start();
        }

        public void run() {
            block4: {
                try {
                    this.listener.setLeft(new JLabel(tcpmon.getMessage("wait00", " Waiting for Connection...")));
                    this.listener.repaint();
                    this.sSocket = new ServerSocket(this.port);
                    while (true) {
                        Socket socket = this.sSocket.accept();
                        if (!this.pleaseStop) {
                            new Connection(this.listener, socket);
                            socket = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    if ("socket closed".equals(exception.getMessage())) break block4;
                    JLabel jLabel = new JLabel(exception.toString());
                    jLabel.setForeground(Color.red);
                    this.listener.setLeft(jLabel);
                    this.listener.setRight(new JLabel(""));
                    this.listener.stop();
                }
            }
        }

        public void halt() {
            try {
                this.pleaseStop = true;
                new Socket("127.0.0.1", this.port);
                if (this.sSocket != null) {
                    this.sSocket.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class AdminPage
    extends JPanel {
        public JRadioButton listenerButton;
        public JRadioButton proxyButton;
        public JLabel hostLabel;
        public JLabel tportLabel;
        public JTextField port;
        public JTextField host;
        public JTextField tport;
        public JTabbedPane noteb;
        public JCheckBox HTTPProxyBox;
        public JTextField HTTPProxyHost;
        public JTextField HTTPProxyPort;
        public JLabel HTTPProxyHostLabel;
        public JLabel HTTPProxyPortLabel;

        public AdminPage(JTabbedPane jTabbedPane, String string) {
            JPanel jPanel = null;
            JButton jButton = null;
            this.setLayout(new BorderLayout());
            this.noteb = jTabbedPane;
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel = new JPanel(gridBagLayout);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)new JLabel(tcpmon.getMessage("newTCP00", "Create a new TCP/IP Monitor...") + " "), gridBagConstraints);
            jPanel.add(Box.createRigidArea(new Dimension(1, 5)), gridBagConstraints);
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            jPanel2.add((Component)new JLabel(tcpmon.getMessage("listenPort00", "Listen Port #") + " "), gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.port = new JTextField(4);
            jPanel2.add((Component)this.port, gridBagConstraints);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            jPanel.add(Box.createRigidArea(new Dimension(1, 5)), gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)new JLabel(tcpmon.getMessage("actAs00", "Act as a...")), gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            String string2 = tcpmon.getMessage("listener00", "Listener");
            this.listenerButton = new JRadioButton(string2);
            jPanel.add((Component)this.listenerButton, gridBagConstraints);
            buttonGroup.add(this.listenerButton);
            this.listenerButton.setSelected(true);
            this.listenerButton.addActionListener(new ActionListener(this, string2){
                private final /* synthetic */ String val$listener;
                private final /* synthetic */ AdminPage this$1;
                {
                    this.this$1 = adminPage;
                    this.val$listener = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$listener.equals(actionEvent.getActionCommand())) {
                        boolean bl = this.this$1.listenerButton.isSelected();
                        this.this$1.tport.setEnabled(bl);
                        this.this$1.host.setEnabled(bl);
                        this.this$1.hostLabel.setForeground(bl ? Color.black : Color.gray);
                        this.this$1.tportLabel.setForeground(bl ? Color.black : Color.gray);
                    }
                }
            });
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            jPanel.add(Box.createRigidArea(new Dimension(25, 0)));
            this.hostLabel = new JLabel(tcpmon.getMessage("targetHostname00", "Target Hostname") + " ");
            jPanel.add((Component)this.hostLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.host = new JTextField(30);
            jPanel.add((Component)this.host, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            jPanel.add(Box.createRigidArea(new Dimension(25, 0)));
            this.tportLabel = new JLabel(tcpmon.getMessage("targetPort00", "Target Port #") + " ");
            jPanel.add((Component)this.tportLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.tport = new JTextField(4);
            jPanel.add((Component)this.tport, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            String string3 = tcpmon.getMessage("proxy00", "Proxy");
            this.proxyButton = new JRadioButton(string3);
            jPanel.add((Component)this.proxyButton, gridBagConstraints);
            buttonGroup.add(this.proxyButton);
            this.proxyButton.addActionListener(new ActionListener(this, string3){
                private final /* synthetic */ String val$proxy;
                private final /* synthetic */ AdminPage this$1;
                {
                    this.this$1 = adminPage;
                    this.val$proxy = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$proxy.equals(actionEvent.getActionCommand())) {
                        boolean bl = this.this$1.proxyButton.isSelected();
                        this.this$1.tport.setEnabled(!bl);
                        this.this$1.host.setEnabled(!bl);
                        this.this$1.hostLabel.setForeground(bl ? Color.gray : Color.black);
                        this.this$1.tportLabel.setForeground(bl ? Color.gray : Color.black);
                    }
                }
            });
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            jPanel.add(Box.createRigidArea(new Dimension(1, 10)), gridBagConstraints);
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.setBorder(new TitledBorder(tcpmon.getMessage("options00", "Options")));
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)jPanel3, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            String string4 = tcpmon.getMessage("proxySupport00", "HTTP Proxy Support");
            this.HTTPProxyBox = new JCheckBox(string4);
            jPanel3.add((Component)this.HTTPProxyBox, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            this.HTTPProxyHostLabel = new JLabel(tcpmon.getMessage("hostname00", "Hostname") + " ");
            jPanel3.add((Component)this.HTTPProxyHostLabel, gridBagConstraints);
            this.HTTPProxyHostLabel.setForeground(Color.gray);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.HTTPProxyHost = new JTextField(30);
            jPanel3.add((Component)this.HTTPProxyHost, gridBagConstraints);
            this.HTTPProxyHost.setEnabled(false);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            this.HTTPProxyPortLabel = new JLabel(tcpmon.getMessage("port00", "Port #") + " ");
            jPanel3.add((Component)this.HTTPProxyPortLabel, gridBagConstraints);
            this.HTTPProxyPortLabel.setForeground(Color.gray);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.HTTPProxyPort = new JTextField(4);
            jPanel3.add((Component)this.HTTPProxyPort, gridBagConstraints);
            this.HTTPProxyPort.setEnabled(false);
            this.HTTPProxyBox.addActionListener(new ActionListener(this, string4){
                private final /* synthetic */ String val$proxySupport;
                private final /* synthetic */ AdminPage this$1;
                {
                    this.this$1 = adminPage;
                    this.val$proxySupport = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$proxySupport.equals(actionEvent.getActionCommand())) {
                        boolean bl = this.this$1.HTTPProxyBox.isSelected();
                        Color color = bl ? Color.black : Color.gray;
                        this.this$1.HTTPProxyHost.setEnabled(bl);
                        this.this$1.HTTPProxyPort.setEnabled(bl);
                        this.this$1.HTTPProxyHostLabel.setForeground(color);
                        this.this$1.HTTPProxyPortLabel.setForeground(color);
                    }
                }
            });
            String string5 = System.getProperty("http.proxyHost");
            if (string5 != null && string5.equals("")) {
                string5 = null;
            }
            this.HTTPProxyBox.setSelected(string5 != null);
            this.HTTPProxyHost.setEnabled(string5 != null);
            this.HTTPProxyPort.setEnabled(string5 != null);
            this.HTTPProxyHostLabel.setForeground(string5 != null ? Color.black : Color.gray);
            this.HTTPProxyPortLabel.setForeground(string5 != null ? Color.black : Color.gray);
            if (string5 != null) {
                this.HTTPProxyBox.setSelected(true);
                this.HTTPProxyHost.setText(string5);
                string5 = System.getProperty("http.proxyPort");
                if (string5 != null && string5.equals("")) {
                    string5 = null;
                }
                if (string5 == null) {
                    string5 = "80";
                }
                this.HTTPProxyPort.setText(string5);
            }
            jPanel.add(Box.createRigidArea(new Dimension(1, 10)), gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            String string6 = tcpmon.getMessage("add00", "Add");
            jButton = new JButton(string6);
            jPanel.add((Component)jButton, gridBagConstraints);
            this.add((Component)new JScrollPane(jPanel), "Center");
            jButton.addActionListener(new ActionListener(this, string6){
                private final /* synthetic */ String val$add;
                private final /* synthetic */ AdminPage this$1;
                {
                    this.this$1 = adminPage;
                    this.val$add = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$add.equals(actionEvent.getActionCommand())) {
                        Listener listener = null;
                        int n = Integer.parseInt(this.this$1.port.getText());
                        String string = this.this$1.host.getText();
                        int n2 = 0;
                        String string2 = this.this$1.tport.getText();
                        if (string2 != null && !string2.equals("")) {
                            n2 = Integer.parseInt(string2);
                        }
                        listener = AdminPage.access$000(this.this$1).new Listener(this.this$1.noteb, null, n, string, n2, this.this$1.proxyButton.isSelected());
                        string2 = this.this$1.HTTPProxyHost.getText();
                        if ("".equals(string2)) {
                            string2 = null;
                        }
                        listener.HTTPProxyHost = string2;
                        string2 = this.this$1.HTTPProxyPort.getText();
                        if ("".equals(string2)) {
                            string2 = null;
                        }
                        if (string2 != null) {
                            listener.HTTPProxyPort = Integer.parseInt(string2);
                        }
                        this.this$1.port.setText(null);
                        this.this$1.host.setText(null);
                        this.this$1.tport.setText(null);
                    }
                }
            });
            jTabbedPane.addTab(string, this);
            jTabbedPane.repaint();
            jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
        }

        static /* synthetic */ tcpmon access$000(AdminPage adminPage) {
            return adminPage.tcpmon.this;
        }
    }
}

