/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils.compiler;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.compiler.AbstractCompiler;
import org.apache.axis.utils.compiler.CompilerError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.tools.javac.Main;

public class Javac
extends AbstractCompiler {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$utils$compiler$Javac == null ? (class$org$apache$axis$utils$compiler$Javac = Javac.class$("org.apache.axis.utils.compiler.Javac")) : class$org$apache$axis$utils$compiler$Javac).getName());
    public static final String CLASSIC_CLASS = "sun.tools.javac.Main";
    public static final String MODERN_CLASS = "com.sun.tools.javac.Main";
    private boolean modern = false;
    static /* synthetic */ Class class$org$apache$axis$utils$compiler$Javac;

    public Javac() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass(MODERN_CLASS);
            this.modern = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug((Object)"Javac connector could not find modern compiler -- falling back to classic.");
            try {
                classLoader.loadClass(CLASSIC_CLASS);
                this.modern = false;
            }
            catch (Exception exception) {
                log.error((Object)JavaUtils.getMessage("noCompiler00"), (Throwable)exception);
                throw new RuntimeException(JavaUtils.getMessage("noCompiler00"));
            }
        }
        log.debug((Object)("Javac compiler class: " + (this.modern ? MODERN_CLASS : CLASSIC_CLASS)));
    }

    public boolean compile() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Main main = new Main((OutputStream)byteArrayOutputStream, "javac");
        boolean bl = main.compile(this.toStringArray(this.fillArguments(new ArrayList())));
        this.errors = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return bl;
    }

    protected List parseStream(BufferedReader bufferedReader) throws IOException {
        if (this.modern) {
            return this.parseModernStream(bufferedReader);
        }
        return this.parseClassicStream(bufferedReader);
    }

    protected List parseModernStream(BufferedReader bufferedReader) throws IOException {
        ArrayList<CompilerError> arrayList = new ArrayList<CompilerError>();
        String string = null;
        StringBuffer stringBuffer = null;
        while (true) {
            stringBuffer = new StringBuffer();
            do {
                if ((string = bufferedReader.readLine()) == null) {
                    if (stringBuffer.length() > 0) {
                        arrayList.add(new CompilerError("\n" + stringBuffer.toString()));
                    }
                    return arrayList;
                }
                log.debug((Object)string);
                stringBuffer.append(string);
                stringBuffer.append('\n');
            } while (!string.endsWith("^"));
            arrayList.add(this.parseModernError(stringBuffer.toString()));
        }
    }

    private CompilerError parseModernError(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        try {
            String string2;
            int n;
            String string3 = stringTokenizer.nextToken();
            if (string3.length() == 1) {
                string3 = string3 + ":" + stringTokenizer.nextToken();
            }
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            String string4 = stringTokenizer.nextToken("\n").substring(1);
            String string5 = stringTokenizer.nextToken("\n");
            int n3 = string5.indexOf(" ", n = (string2 = stringTokenizer.nextToken("\n")).indexOf("^"));
            if (n3 == -1) {
                n3 = string5.length();
            }
            return new CompilerError(string3, false, n2, n, n2, n3, string4);
        }
        catch (NoSuchElementException noSuchElementException) {
            return new CompilerError("no more tokens - could not parse error message: " + string);
        }
        catch (Exception exception) {
            return new CompilerError("could not parse error message: " + string);
        }
    }

    protected List parseClassicStream(BufferedReader bufferedReader) throws IOException {
        ArrayList<CompilerError> arrayList = null;
        String string = null;
        StringBuffer stringBuffer = null;
        while (true) {
            stringBuffer = new StringBuffer();
            int n = 0;
            while (n < 3) {
                string = bufferedReader.readLine();
                if (string == null) {
                    return arrayList;
                }
                log.debug((Object)string);
                stringBuffer.append(string);
                stringBuffer.append('\n');
                ++n;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<CompilerError>();
            }
            arrayList.add(this.parseClassicError(stringBuffer.toString()));
        }
    }

    private CompilerError parseClassicError(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        try {
            String string2;
            int n;
            String string3 = stringTokenizer.nextToken();
            if (string3.length() == 1) {
                string3 = string3 + ":" + stringTokenizer.nextToken();
            }
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            String string4 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreElements()) {
                string4 = string4 + stringTokenizer.nextToken();
            }
            stringTokenizer = new StringTokenizer(string4.trim(), "\n");
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            int n3 = string6.indexOf(" ", n = (string2 = stringTokenizer.nextToken()).indexOf("^"));
            if (n3 == -1) {
                n3 = string6.length();
            }
            return new CompilerError(this.srcDir + File.separator + string3, true, n2, n, n2, n3, string5);
        }
        catch (NoSuchElementException noSuchElementException) {
            return new CompilerError("no more tokens - could not parse error message: " + string);
        }
        catch (Exception exception) {
            return new CompilerError("could not parse error message: " + string);
        }
    }

    public String toString() {
        return "Sun Javac Compiler";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

