/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.axis.utils.compiler.Compiler;

public abstract class AbstractCompiler
implements Compiler {
    protected String file;
    protected String srcDir;
    protected String destDir;
    protected String classpath;
    protected String encoding = null;
    protected InputStream errors;

    public void setFile(String string) {
        this.file = string;
    }

    public void setSource(String string) {
        this.srcDir = string;
    }

    public void setDestination(String string) {
        this.destDir = string;
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public List getErrors() throws IOException {
        return this.parseStream(new BufferedReader(new InputStreamReader(this.errors)));
    }

    protected abstract List parseStream(BufferedReader var1) throws IOException;

    protected List fillArguments(List list) {
        list.add("-d");
        list.add(this.destDir);
        list.add("-classpath");
        list.add(this.classpath);
        if (this.srcDir != null) {
            list.add("-sourcepath");
            list.add(this.srcDir);
        }
        list.add("-O");
        list.add("-g");
        if (this.encoding != null) {
            list.add("-encoding");
            list.add(this.encoding);
        }
        return list;
    }

    protected String[] toStringArray(List list) {
        String[] stringArray = new String[list.size() + 1];
        int n = 0;
        while (n < list.size()) {
            stringArray[n] = (String)list.get(n);
            ++n;
        }
        stringArray[n] = this.file;
        return stringArray;
    }
}

