/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.IOException;
import java.io.InputStream;

public class NonBlockingBufferedInputStream
extends InputStream {
    private InputStream in;
    private int remainingContent = Integer.MAX_VALUE;
    private byte[] buffer = new byte[4096];
    private int offset = 0;
    private int numbytes = 0;

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
        this.numbytes = 0;
        this.offset = 0;
        this.remainingContent = inputStream == null ? 0 : Integer.MAX_VALUE;
    }

    public void setContentLength(int n) {
        if (this.in != null) {
            this.remainingContent = n - (this.numbytes - this.offset);
        }
    }

    private void refillBuffer() throws IOException {
        if (this.remainingContent == 0 || this.in == null) {
            return;
        }
        this.numbytes = this.in.available();
        if (this.numbytes <= 0) {
            this.numbytes = 1;
        }
        if (this.numbytes > this.remainingContent) {
            this.numbytes = this.remainingContent;
        }
        if (this.numbytes > this.buffer.length) {
            this.numbytes = this.buffer.length;
        }
        this.numbytes = this.in.read(this.buffer, 0, this.numbytes);
        this.remainingContent -= this.numbytes;
        this.offset = 0;
    }

    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (this.offset >= this.numbytes) {
            this.refillBuffer();
        }
        if (this.offset >= this.numbytes) {
            return -1;
        }
        return this.buffer[this.offset++];
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.numbytes - this.offset;
        if (n3 >= n2) {
            System.arraycopy(this.buffer, this.offset, byArray, n, n2);
            this.offset += n2;
            return n2;
        }
        if (n3 > 0) {
            System.arraycopy(this.buffer, this.offset, byArray, n, n3);
            this.offset = this.numbytes;
            return n3;
        }
        if (this.in == null) {
            return -1;
        }
        this.refillBuffer();
        if (this.offset >= this.numbytes) {
            return -1;
        }
        return this.read(byArray, n, n2);
    }

    public int skip(int n) throws IOException {
        int n2 = 0;
        while (n-- > 0 && this.read() >= 0) {
            ++n2;
        }
        return n2;
    }

    public int available() throws IOException {
        if (this.in == null) {
            return 0;
        }
        return this.numbytes - this.offset + this.in.available();
    }

    public void close() throws IOException {
        this.setInputStream(null);
    }
}

