/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.configuration.ServletEngineConfigurationFactory;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFaultElement;
import org.apache.axis.security.servlet.ServletSecurityProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisHttpSession;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Admin;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class AxisServlet
extends HttpServlet {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$transport$http$AxisServlet == null ? (class$org$apache$axis$transport$http$AxisServlet = AxisServlet.class$("org.apache.axis.transport.http.AxisServlet")) : class$org$apache$axis$transport$http$AxisServlet).getName());
    private String transportName = "http";
    private AxisEngine engine = null;
    private ServletSecurityProvider securityProvider = null;
    private boolean enableList = false;
    private static final String AXIS_ENGINE = "AxisEngine";
    private boolean isDebug = false;
    private String webInfPath = null;
    private String jwsClassDir = null;
    private String homeDir = null;
    static /* synthetic */ Class class$org$apache$axis$transport$http$AxisServlet;

    public void init() {
        String string;
        ServletContext servletContext = this.getServletConfig().getServletContext();
        this.webInfPath = servletContext.getRealPath("/WEB-INF");
        this.homeDir = servletContext.getRealPath("/");
        this.isDebug = log.isDebugEnabled();
        if (this.isDebug) {
            log.debug((Object)"In servlet init");
        }
        if ((string = this.getInitParameter("transport.name")) == null) {
            string = servletContext.getInitParameter("transport.name");
        }
        if (string != null) {
            this.transportName = string;
        }
        if ((string = this.getInitParameter("use-servlet-security")) != null && string.equalsIgnoreCase("true")) {
            this.securityProvider = new ServletSecurityProvider();
        }
        if ((string = System.getProperty("axis.enableListQuery")) != null && string.equalsIgnoreCase("true")) {
            this.enableList = true;
        }
        this.jwsClassDir = (string = System.getProperty("axis.jws.servletClassDir")) != null ? this.homeDir + string : servletContext.getRealPath("/");
    }

    public AxisServer getEngine() throws AxisFault {
        return AxisServlet.getEngine(this);
    }

    public static AxisServer getEngine(HttpServlet httpServlet) throws AxisFault {
        ServletContext servletContext = httpServlet.getServletContext();
        if (servletContext.getAttribute(AXIS_ENGINE) == null) {
            String string = servletContext.getRealPath("/WEB-INF");
            EngineConfiguration engineConfiguration = new ServletEngineConfigurationFactory(servletContext).getServerEngineConfig();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("servletContext", servletContext);
            String string2 = httpServlet.getInitParameter("axis.attachments.Directory");
            if (string2 != null) {
                hashMap.put("axis.attachments.Directory", string2);
            }
            if (null != string) {
                hashMap.put("servlet.realpath", string + File.separator + "attachments");
            }
            hashMap.put("engineConfig", engineConfiguration);
            servletContext.setAttribute(AXIS_ENGINE, (Object)AxisServer.getServer(hashMap));
        }
        return (AxisServer)servletContext.getAttribute(AXIS_ENGINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.isDebug) {
            log.debug((Object)"In doGet");
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (this.engine == null) {
            try {
                this.engine = this.getEngine();
            }
            catch (AxisFault axisFault) {
                httpServletResponse.setContentType("text/html");
                printWriter.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                printWriter.println("<p>" + JavaUtils.getMessage("somethingWrong00") + "</p>");
                printWriter.println("<pre>" + axisFault.toString() + " </pre>");
                return;
            }
        }
        ServletContext servletContext = this.getServletConfig().getServletContext();
        MessageContext messageContext = new MessageContext(this.engine);
        messageContext.setProperty("jws.classDir", this.jwsClassDir);
        messageContext.setProperty("home.dir", this.homeDir);
        String string = servletContext.getRealPath(httpServletRequest.getServletPath());
        String string2 = this.webInfPath;
        if (string == null) {
            httpServletResponse.setContentType("text/html");
            printWriter.println("<html><h1>Axis HTTP Servlet</h1>");
            printWriter.println(JavaUtils.getMessage("reachedServlet00"));
            printWriter.println("<p>" + JavaUtils.getMessage("transportName00", "<b>" + this.transportName + "</b>"));
            printWriter.println("</html>");
            return;
        }
        messageContext.setProperty("path", httpServletRequest.getServletPath());
        messageContext.setProperty("realpath", string);
        messageContext.setProperty("configPath", string2);
        messageContext.setTransportName(this.transportName);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, (Object)this);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, httpServletRequest);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, httpServletResponse);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, this.webInfPath);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, httpServletRequest.getPathInfo());
        messageContext.setProperty("Authorization", httpServletRequest.getHeader("Authorization"));
        messageContext.setProperty("remoteaddr", httpServletRequest.getRemoteAddr());
        try {
            block27: {
                try {
                    String string3 = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
                    messageContext.setProperty(MessageContext.TRANS_URL, string3);
                    boolean bl = false;
                    boolean bl2 = false;
                    String string4 = httpServletRequest.getQueryString();
                    if (string4 != null) {
                        if (string4.equalsIgnoreCase("wsdl")) {
                            bl = true;
                        } else if (string4.equalsIgnoreCase("list")) {
                            bl2 = true;
                        }
                    }
                    if (bl) {
                        this.engine.generateWSDL(messageContext);
                        Document document = (Document)messageContext.getProperty("WSDL");
                        if (document != null) {
                            httpServletResponse.setContentType("text/xml");
                            XMLUtils.DocumentToWriter(document, printWriter);
                            break block27;
                        } else {
                            httpServletResponse.setContentType("text/html");
                            printWriter.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                            printWriter.println("<p>" + JavaUtils.getMessage("noWSDL00") + "</p>");
                        }
                        break block27;
                    }
                    if (bl2) {
                        if (this.enableList) {
                            Document document = Admin.listConfig(this.engine);
                            if (document != null) {
                                httpServletResponse.setContentType("text/xml");
                                XMLUtils.DocumentToWriter(document, printWriter);
                                break block27;
                            } else {
                                httpServletResponse.setContentType("text/html");
                                printWriter.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                                printWriter.println("<p>" + JavaUtils.getMessage("noDeploy00") + "</p>");
                            }
                            break block27;
                        }
                        httpServletResponse.setContentType("text/html");
                        printWriter.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                        printWriter.println("<p><i>?list</i>" + JavaUtils.getMessage("disabled00") + "</p>");
                        break block27;
                    }
                    if (httpServletRequest.getParameterNames().hasMoreElements()) {
                        String string5;
                        httpServletResponse.setContentType("text/html");
                        Enumeration enumeration = httpServletRequest.getParameterNames();
                        String string6 = null;
                        String string7 = "";
                        while (true) {
                            if (!enumeration.hasMoreElements()) {
                                if (string6 != null) break;
                                printWriter.println("<h2>" + JavaUtils.getMessage("error00") + ":  " + JavaUtils.getMessage("invokeGet00") + "</h2>");
                                printWriter.println("<p>" + JavaUtils.getMessage("noMethod01") + "</p>");
                                Object var21_21 = null;
                                printWriter.close();
                                return;
                            }
                            string5 = (String)enumeration.nextElement();
                            if (string5.equalsIgnoreCase("method")) {
                                string6 = httpServletRequest.getParameter(string5);
                                continue;
                            }
                            string7 = string7 + "<" + string5 + ">" + httpServletRequest.getParameter(string5) + "</" + string5 + ">";
                        }
                        string5 = "<" + string6 + ">" + string7 + "</" + string6 + ">";
                        String string8 = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>" + string5 + "</SOAP-ENV:Body>" + "</SOAP-ENV:Envelope>";
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string8.getBytes());
                        Message message = new Message(byteArrayInputStream, false);
                        messageContext.setRequestMessage(message);
                        this.engine.invoke(messageContext);
                        Message message2 = messageContext.getResponseMessage();
                        if (message2 != null) {
                            printWriter.println("<p>" + JavaUtils.getMessage("gotResponse00") + "</p>");
                            printWriter.println(message2.getSOAPPart().getAsString());
                            break block27;
                        } else {
                            printWriter.println("<p>" + JavaUtils.getMessage("noResponse01") + "</p>");
                        }
                        break block27;
                    }
                    httpServletResponse.setContentType("text/html");
                    printWriter.println("<h1>" + httpServletRequest.getRequestURI() + "</h1>");
                    printWriter.println(string2);
                    printWriter.println("<p>" + JavaUtils.getMessage("axisService00") + "</p>");
                    printWriter.println("<i>" + JavaUtils.getMessage("perhaps00") + "</i>");
                }
                catch (AxisFault axisFault) {
                    httpServletResponse.setContentType("text/html");
                    printWriter.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                    printWriter.println("<p>" + JavaUtils.getMessage("somethingWrong00") + "</p>");
                    printWriter.println("<pre>" + axisFault.toString() + " </pre>");
                    Object var21_23 = null;
                    printWriter.close();
                    return;
                }
                catch (Exception exception) {
                    httpServletResponse.setContentType("text/html");
                    printWriter.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                    printWriter.println("<p>" + JavaUtils.getMessage("somethingWrong00") + "</p>");
                    printWriter.println("<pre>Exception - " + exception + "<br>");
                    exception.printStackTrace(httpServletResponse.getWriter());
                    printWriter.println("</pre>");
                    Object var21_24 = null;
                    printWriter.close();
                    return;
                }
            }
            Object var21_22 = null;
            printWriter.close();
            return;
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            printWriter.close();
            return;
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        if (this.isDebug) {
            log.debug((Object)"In doPost");
        }
        if (this.engine == null) {
            try {
                this.engine = this.getEngine();
            }
            catch (AxisFault axisFault) {
                log.debug((Object)axisFault);
                Message message = new Message(axisFault);
                httpServletResponse.setContentType(message.getContentType());
                httpServletResponse.setContentLength(message.getContentLength());
                message.writeContentToStream((OutputStream)httpServletResponse.getOutputStream());
                return;
            }
        }
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        httpServletResponse.setBufferSize(8192);
        if (this.engine == null) {
            this.engine = (AxisEngine)servletContext.getAttribute(AXIS_ENGINE);
        }
        if (this.engine == null) {
            ServletException servletException = new ServletException(JavaUtils.getMessage("noEngine00"));
            log.debug((Object)servletException);
            throw servletException;
        }
        MessageContext messageContext = new MessageContext(this.engine);
        if (this.isDebug) {
            log.debug((Object)("MessageContext:" + messageContext));
        }
        if (this.isDebug) {
            log.debug((Object)("HEADER_CONTENT_TYPE:" + httpServletRequest.getHeader("Content-Type")));
        }
        if (this.isDebug) {
            log.debug((Object)("HEADER_CONTENT_LOCATION:" + httpServletRequest.getHeader("Content-Location")));
        }
        Message message = new Message(httpServletRequest.getInputStream(), false, httpServletRequest.getHeader("Content-Type"), httpServletRequest.getHeader("Content-Location"));
        if (this.isDebug) {
            log.debug((Object)("Message:" + message));
        }
        messageContext.setRequestMessage(message);
        messageContext.setTransportName(this.transportName);
        messageContext.setProperty("jws.classDir", this.jwsClassDir);
        messageContext.setProperty("home.dir", this.homeDir);
        messageContext.setProperty("path", httpServletRequest.getServletPath());
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, (Object)this);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, httpServletRequest);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, httpServletResponse);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, this.webInfPath);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, httpServletRequest.getPathInfo());
        messageContext.setProperty("Authorization", httpServletRequest.getHeader("Authorization"));
        messageContext.setProperty("remoteaddr", httpServletRequest.getRemoteAddr());
        if (this.securityProvider != null) {
            messageContext.setProperty("securityProvider", this.securityProvider);
        }
        if (this.isDebug) {
            log.debug((Object)("Constants.MC_HOME_DIR:" + servletContext.getRealPath("/")));
            log.debug((Object)("Constants.MC_RELATIVE_PATH:" + httpServletRequest.getServletPath()));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETLOCATION:" + this.webInfPath));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + httpServletRequest.getPathInfo()));
            log.debug((Object)("HTTPConstants.HEADER_AUTHORIZATION:" + httpServletRequest.getHeader("Authorization")));
            log.debug((Object)("Constants.MC_REMOTE_ADDR:" + httpServletRequest.getRemoteAddr()));
            log.debug((Object)("securityProvider:" + this.securityProvider));
        }
        String string = httpServletRequest.getHeader("SOAPAction");
        if (this.isDebug) {
            log.debug((Object)("HEADER_SOAP_ACTION:" + string));
        }
        try {
            if (string == null) {
                AxisFault axisFault = new AxisFault("Client.NoSOAPAction", JavaUtils.getMessage("noHeader00", "SOAPAction"), null, null);
                log.debug((Object)axisFault);
                throw axisFault;
            }
            if ("".equals(string)) {
                string = httpServletRequest.getContextPath();
            }
            if (string != null) {
                messageContext.setUseSOAPAction(true);
                messageContext.setSOAPActionURI(string);
            }
            messageContext.setSession(new AxisHttpSession(httpServletRequest));
            object = servletContext.getRealPath(httpServletRequest.getServletPath());
            if (object != null) {
                messageContext.setProperty("realpath", object);
            }
            String string2 = this.webInfPath;
            if (this.isDebug) {
                log.debug((Object)("configPath:" + string2));
            }
            messageContext.setProperty("configPath", string2);
            if (this.isDebug) {
                log.debug((Object)"Invoking Axis Engine.");
            }
            this.engine.invoke(messageContext);
            if (this.isDebug) {
                log.debug((Object)"Return from Axis Engine.");
            }
        }
        catch (Exception exception) {
            Object object2;
            log.debug((Object)exception);
            if (exception instanceof AxisFault) {
                object2 = (AxisFault)exception;
                if ("Server.Unauthorized".equals(((AxisFault)object2).getFaultCode())) {
                    httpServletResponse.setStatus(401);
                } else {
                    httpServletResponse.setStatus(500);
                }
            } else {
                httpServletResponse.setStatus(500);
            }
            if (!(exception instanceof AxisFault)) {
                object = AxisFault.makeFault(exception);
            }
            if (message == null) {
                message = new Message((AxisFault)object);
                messageContext.setResponseMessage(message);
            }
            try {
                object2 = message.getSOAPEnvelope();
                ((SOAPEnvelope)object2).clearBody();
                ((SOAPEnvelope)object2).addBodyElement(new SOAPFaultElement((AxisFault)object));
                messageContext.setResponseMessage(message);
            }
            catch (AxisFault axisFault) {
                // empty catch block
            }
        }
        message = messageContext.getResponseMessage();
        if (null == message) {
            if (this.isDebug) {
                log.debug((Object)"NO AXIS MESSAGE TO RETURN!");
            }
            object = JavaUtils.getMessage("noData00");
            httpServletResponse.setContentLength(((String)object).getBytes().length);
            httpServletResponse.getWriter().print((String)object);
        } else {
            if (this.isDebug) {
                log.debug((Object)("Returned Content-Type:" + message.getContentType()));
            }
            int n = 0;
            httpServletResponse.setContentType(message.getContentType());
            n = message.getContentLength();
            httpServletResponse.setContentLength(n);
            if (this.isDebug) {
                log.debug((Object)("Returned Content-Length:" + n));
            }
            message.writeContentToStream((OutputStream)httpServletResponse.getOutputStream());
        }
        if (!httpServletResponse.isCommitted()) {
            httpServletResponse.flushBuffer();
        }
        if (this.isDebug) {
            log.debug((Object)"Response sent.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

