/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.providers.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisServiceConfig;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.providers.BasicProvider;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.axis.utils.cache.JavaClass;
import org.apache.axis.wsdl.fromJava.Emitter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public abstract class JavaProvider
extends BasicProvider {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$providers$java$JavaProvider == null ? (class$org$apache$axis$providers$java$JavaProvider = JavaProvider.class$("org.apache.axis.providers.java.JavaProvider")) : class$org$apache$axis$providers$java$JavaProvider).getName());
    public static final String OPTION_CLASSNAME = "className";
    public static final String OPTION_IS_STATIC = "isStatic";
    public static final String OPTION_CLASSPATH = "classPath";
    private String classNameOption = "className";
    private String allowedMethodsOption = "allowedMethods";
    static /* synthetic */ Class class$org$apache$axis$providers$java$JavaProvider;

    public Object getServiceObject(MessageContext messageContext, Handler handler, String string) throws Exception {
        String string2 = messageContext.getService().getName();
        String string3 = (String)handler.getOption("scope");
        if (string3 == null) {
            string3 = "Request";
        }
        if (string3.equalsIgnoreCase("Request")) {
            return this.getNewServiceObject(messageContext, string);
        }
        if (string3.equalsIgnoreCase("Session")) {
            if (string2 == null) {
                string2 = messageContext.getService().toString();
            }
            if (messageContext.getSession() != null) {
                Object object = messageContext.getSession().get(string2);
                if (object == null) {
                    object = this.getNewServiceObject(messageContext, string);
                    messageContext.getSession().set(string2, object);
                }
                return object;
            }
            return this.getNewServiceObject(messageContext, string);
        }
        if (string3.equalsIgnoreCase("Application")) {
            AxisEngine axisEngine = messageContext.getAxisEngine();
            if (axisEngine.getApplicationSession() != null) {
                Object object = axisEngine.getApplicationSession().get(string2);
                if (object == null) {
                    object = this.getNewServiceObject(messageContext, string);
                    axisEngine.getApplicationSession().set(string2, object);
                }
                return object;
            }
            return this.getNewServiceObject(messageContext, string);
        }
        return null;
    }

    public abstract void processMessage(MessageContext var1, String var2, String var3, SOAPEnvelope var4, SOAPEnvelope var5, JavaClass var6, Object var7) throws Exception;

    public void invoke(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "JavaProvider::invoke (" + this + ")"));
        }
        String string = messageContext.getTargetService();
        SOAPService sOAPService = messageContext.getService();
        String string2 = this.getServiceClassName(sOAPService);
        String string3 = this.getAllowedMethods(sOAPService);
        if (string2 == null || string2.equals("")) {
            throw new AxisFault("Server.NoClassForService", JavaUtils.getMessage("noOption00", this.getServiceClassNameOptionName(), string), null, null);
        }
        if (string3 == null || string3.equals("")) {
            throw new AxisFault("Server.NoMethodConfig", JavaUtils.getMessage("noOption00", this.allowedMethodsOption, string), null, null);
        }
        if (string3.equals("*")) {
            string3 = null;
        }
        try {
            AxisServiceConfig axisServiceConfig;
            SOAPEnvelope sOAPEnvelope;
            Object object = this.getServiceObject(messageContext, sOAPService, string2);
            JavaClass javaClass = JavaClass.find(object.getClass());
            Message message = messageContext.getRequestMessage();
            SOAPEnvelope sOAPEnvelope2 = message.getSOAPEnvelope();
            Message message2 = messageContext.getResponseMessage();
            SOAPEnvelope sOAPEnvelope3 = sOAPEnvelope = message2 == null ? new SOAPEnvelope() : message2.getSOAPEnvelope();
            if (messageContext.getResponseMessage() == null) {
                message2 = new Message(sOAPEnvelope);
                messageContext.setResponseMessage(message2);
            }
            if ((axisServiceConfig = this.getConfiguration(object)) != null) {
                string3 = axisServiceConfig.getAllowedMethods();
            }
            this.processMessage(messageContext, string2, string3, sOAPEnvelope2, sOAPEnvelope, javaClass, object);
        }
        catch (Exception exception) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exception);
            throw AxisFault.makeFault(exception);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "JavaProvider::invoke (" + this + ")"));
        }
    }

    public void generateWSDL(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "JavaProvider::editWSDL (" + this + ")"));
        }
        String string = messageContext.getTargetService();
        SOAPService sOAPService = messageContext.getService();
        String string2 = this.getAllowedMethods(sOAPService);
        if (string2 == null || string2.equals("")) {
            throw new AxisFault("Server.NoMethodConfig", JavaUtils.getMessage("noOption00", this.getServiceClassNameOptionName(), string), null, null);
        }
        if (string2.equals("*")) {
            string2 = null;
        }
        try {
            String string3 = messageContext.getStrProp(MessageContext.TRANS_URL);
            String string4 = messageContext.getTargetService();
            String string5 = "Service";
            Class clazz = this.getServiceClass(messageContext, this.getServiceClassName(sOAPService));
            AxisServiceConfig axisServiceConfig = this.getConfiguration(clazz);
            if (axisServiceConfig != null) {
                string2 = axisServiceConfig.getAllowedMethods();
            }
            Emitter emitter = new Emitter();
            emitter.setMode(sOAPService.getStyle());
            emitter.setClsSmart(clazz, string3);
            emitter.setAllowedMethods(string2);
            emitter.setIntfNamespace(string3);
            emitter.setLocationUrl(string3);
            emitter.setTypeMapping((TypeMapping)messageContext.getTypeMappingRegistry().getTypeMapping("http://schemas.xmlsoap.org/soap/encoding/"));
            emitter.setDefaultTypeMapping((TypeMapping)messageContext.getTypeMappingRegistry().getDefaultTypeMapping());
            Document document = emitter.emit(0);
            messageContext.setProperty("WSDL", document);
        }
        catch (Exception exception) {
            throw AxisFault.makeFault(exception);
        }
    }

    private String getAllowedMethods(Handler handler) {
        String string = (String)handler.getOption(this.allowedMethodsOption);
        if (string == null || string.length() == 0) {
            string = (String)handler.getOption("methodName");
        }
        return string;
    }

    protected Object getNewServiceObject(MessageContext messageContext, String string) throws Exception {
        ClassLoader classLoader = messageContext.getClassLoader();
        ClassCache classCache = messageContext.getAxisEngine().getClassCache();
        JavaClass javaClass = classCache.lookup(string, classLoader);
        return javaClass.getJavaClass().newInstance();
    }

    protected String getServiceClassName(Handler handler) {
        return (String)handler.getOption(this.getServiceClassNameOptionName());
    }

    protected String getServiceClassNameOptionName() {
        return this.classNameOption;
    }

    protected Class getServiceClass(MessageContext messageContext, String string) throws Exception {
        SOAPService sOAPService = messageContext.getService();
        Object object = this.getServiceObject(messageContext, sOAPService, string);
        return object.getClass();
    }

    public AxisServiceConfig getConfiguration(Object object) {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        try {
            Method method = clazz.getDeclaredMethod("getAxisServiceConfig", new Class[0]);
            if (method != null && Modifier.isStatic(method.getModifiers())) {
                return (AxisServiceConfig)method.invoke(null, null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

