/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.encoding.DeserializationContextImpl;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Mapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class SOAPEnvelope
extends MessageElement {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$message$SOAPEnvelope == null ? (class$org$apache$axis$message$SOAPEnvelope = SOAPEnvelope.class$("org.apache.axis.message.SOAPEnvelope")) : class$org$apache$axis$message$SOAPEnvelope).getName());
    public Vector headers = new Vector();
    public Vector bodyElements = new Vector();
    public Vector trailers = new Vector();
    public String messageType;
    static /* synthetic */ Class class$org$apache$axis$message$SOAPEnvelope;

    public SOAPEnvelope() {
        this(true);
    }

    public SOAPEnvelope(boolean bl) {
        if (bl) {
            if (this.namespaces == null) {
                this.namespaces = new ArrayList();
            }
            this.namespaces.add(new Mapping("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV"));
            this.namespaces.add(new Mapping("http://www.w3.org/2001/XMLSchema", "xsd"));
            this.namespaces.add(new Mapping("http://www.w3.org/2001/XMLSchema-instance", "xsi"));
        }
        this.setDirty(true);
    }

    public SOAPEnvelope(InputStream inputStream) {
        try {
            InputSource inputSource = new InputSource(inputStream);
            DeserializationContextImpl deserializationContextImpl = null;
            AxisClient axisClient = new AxisClient(new NullProvider());
            MessageContext messageContext = new MessageContext(axisClient);
            deserializationContextImpl = new DeserializationContextImpl(inputSource, messageContext, "request", this);
            deserializationContextImpl.parse();
        }
        catch (Exception exception) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exception);
            throw new RuntimeException(exception.toString());
        }
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String string) {
        this.messageType = string;
    }

    public Vector getBodyElements() throws AxisFault {
        return this.bodyElements;
    }

    public Vector getTrailers() {
        return this.trailers;
    }

    public SOAPBodyElement getFirstBody() throws AxisFault {
        if (this.bodyElements.isEmpty()) {
            return null;
        }
        return (SOAPBodyElement)this.bodyElements.elementAt(0);
    }

    public Vector getHeaders() throws AxisFault {
        return this.headers;
    }

    public Vector getHeadersByActor(ArrayList arrayList) {
        Vector<SOAPHeader> vector = new Vector<SOAPHeader>();
        Iterator iterator = this.headers.iterator();
        while (iterator.hasNext()) {
            SOAPHeader sOAPHeader = (SOAPHeader)iterator.next();
            if (!"http://schemas.xmlsoap.org/soap/actor/next".equals(sOAPHeader.getActor()) && (arrayList == null || !arrayList.contains(sOAPHeader.getActor()))) continue;
            vector.add(sOAPHeader);
        }
        return vector;
    }

    public void addHeader(SOAPHeader sOAPHeader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("addHeader00"));
        }
        sOAPHeader.setEnvelope(this);
        this.headers.addElement(sOAPHeader);
        this._isDirty = true;
    }

    public void addBodyElement(SOAPBodyElement sOAPBodyElement) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("addBody00"));
        }
        sOAPBodyElement.setEnvelope(this);
        this.bodyElements.addElement(sOAPBodyElement);
        this._isDirty = true;
    }

    public void removeHeader(SOAPHeader sOAPHeader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("removeHeader00"));
        }
        this.headers.removeElement(sOAPHeader);
        this._isDirty = true;
    }

    public void removeBodyElement(SOAPBodyElement sOAPBodyElement) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("removeBody00"));
        }
        this.bodyElements.removeElement(sOAPBodyElement);
        this._isDirty = true;
    }

    public void removeTrailer(MessageElement messageElement) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("removeTrailer00"));
        }
        this.trailers.removeElement(messageElement);
        this._isDirty = true;
    }

    public void clearBody() {
        if (!this.bodyElements.isEmpty()) {
            this.bodyElements.removeAllElements();
        }
        this._isDirty = true;
    }

    public void addTrailer(MessageElement messageElement) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("removeTrailer00"));
        }
        messageElement.setEnvelope(this);
        this.trailers.addElement(messageElement);
        this._isDirty = true;
    }

    public SOAPHeader getHeaderByName(String string, String string2) throws AxisFault {
        return this.getHeaderByName(string, string2, false);
    }

    public SOAPHeader getHeaderByName(String string, String string2, boolean bl) throws AxisFault {
        MessageContext messageContext;
        SOAPHeader sOAPHeader = (SOAPHeader)this.findElement(this.headers, string, string2);
        if (!bl && (messageContext = MessageContext.getCurrentContext()) != null && sOAPHeader != null) {
            String string3 = sOAPHeader.getActor();
            ArrayList arrayList = messageContext.getAxisEngine().getActorURIs();
            if (!(string3 == null || "http://schemas.xmlsoap.org/soap/actor/next".equals(string3) || arrayList != null && arrayList.contains(string3))) {
                sOAPHeader = null;
            }
        }
        return sOAPHeader;
    }

    public SOAPBodyElement getBodyByName(String string, String string2) throws AxisFault {
        return (SOAPBodyElement)this.findElement(this.bodyElements, string, string2);
    }

    protected MessageElement findElement(Vector vector, String string, String string2) {
        if (vector.isEmpty()) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MessageElement messageElement = (MessageElement)enumeration.nextElement();
            if (!messageElement.getNamespaceURI().equals(string) || !messageElement.getName().equals(string2)) continue;
            return messageElement;
        }
        return null;
    }

    public Enumeration getHeadersByName(String string, String string2) throws AxisFault {
        return this.getHeadersByName(string, string2, false);
    }

    public Enumeration getHeadersByName(String string, String string2, boolean bl) throws AxisFault {
        ArrayList arrayList = null;
        boolean bl2 = false;
        Vector<SOAPHeader> vector = new Vector<SOAPHeader>();
        Enumeration enumeration = this.headers.elements();
        while (enumeration.hasMoreElements()) {
            SOAPHeader sOAPHeader = (SOAPHeader)enumeration.nextElement();
            if (!sOAPHeader.getNamespaceURI().equals(string) || !sOAPHeader.getName().equals(string2)) continue;
            if (!bl) {
                Object object;
                if (bl2) {
                    object = MessageContext.getCurrentContext();
                    if (object != null) {
                        arrayList = ((MessageContext)object).getAxisEngine().getActorURIs();
                    }
                    bl2 = false;
                }
                if ((object = sOAPHeader.getActor()) != null && !"http://schemas.xmlsoap.org/soap/actor/next".equals(object) && (arrayList == null || !arrayList.contains(object))) continue;
            }
            vector.addElement(sOAPHeader);
        }
        return vector.elements();
    }

    public void outputImpl(SerializationContext serializationContext) throws Exception {
        Object object;
        Enumeration enumeration;
        boolean bl = serializationContext.getPretty();
        serializationContext.setPretty(true);
        if (this.namespaces != null) {
            enumeration = this.namespaces.iterator();
            while (enumeration.hasNext()) {
                object = (Mapping)enumeration.next();
                serializationContext.registerPrefixForURI(((Mapping)object).getPrefix(), ((Mapping)object).getNamespaceURI());
            }
        }
        serializationContext.startElement(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Envelope"), this.attributes);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.headers.size() + " " + JavaUtils.getMessage("headers00")));
        }
        if (!this.headers.isEmpty()) {
            serializationContext.startElement(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header"), null);
            enumeration = this.headers.elements();
            while (enumeration.hasMoreElements()) {
                object = (SOAPHeader)enumeration.nextElement();
                ((MessageElement)object).output(serializationContext);
            }
            serializationContext.endElement();
        }
        if (this.bodyElements.isEmpty()) {
            // empty if block
        }
        serializationContext.startElement(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body"), null);
        enumeration = this.bodyElements.elements();
        while (enumeration.hasMoreElements()) {
            object = (SOAPBodyElement)enumeration.nextElement();
            ((MessageElement)object).output(serializationContext);
        }
        serializationContext.outputMultiRefs();
        serializationContext.endElement();
        enumeration = this.trailers.elements();
        while (enumeration.hasMoreElements()) {
            object = (MessageElement)enumeration.nextElement();
            ((MessageElement)object).output(serializationContext);
        }
        serializationContext.endElement();
        serializationContext.setPretty(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

