/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.ArrayList;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SymbolTable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAX2EventRecorder {
    private static final byte STATE_SET_DOCUMENT_LOCATOR = 0;
    private static final byte STATE_START_DOCUMENT = 1;
    private static final byte STATE_END_DOCUMENT = 2;
    private static final byte STATE_START_PREFIX_MAPPING = 3;
    private static final byte STATE_END_PREFIX_MAPPING = 4;
    private static final byte STATE_START_ELEMENT = 5;
    private static final byte STATE_END_ELEMENT = 6;
    private static final byte STATE_CHARACTERS = 7;
    private static final byte STATE_IGNORABLE_WHITESPACE = 8;
    private static final byte STATE_PROCESSING_INSTRUCTION = 9;
    private static final byte STATE_SKIPPED_ENTITY = 10;
    private static final byte STATE_NEWELEMENT = 11;
    Locator locator;
    intArrayVector events = new intArrayVector();
    Object[] attrs = new Object[20];
    int numattrs = 0;
    SymbolTable st = new SymbolTable();
    ArrayList elements = new ArrayList();

    public void clear() {
        this.locator = null;
        this.events = new intArrayVector();
        this.attrs = new Object[20];
        this.numattrs = 0;
        this.st = new SymbolTable();
    }

    public int getLength() {
        return this.events.getLength();
    }

    public int setDocumentLocator(Locator locator) {
        this.locator = locator;
        return this.events.add(0, 0, 0, 0, 0);
    }

    public int startDocument() {
        return this.events.add(1, 0, 0, 0, 0);
    }

    public int endDocument() {
        return this.events.add(2, 0, 0, 0, 0);
    }

    public int startPrefixMapping(String string, String string2) {
        return this.events.add(3, this.st.addSymbol(string), this.st.addSymbol(string2), 0, 0);
    }

    public int endPrefixMapping(String string) {
        return this.events.add(4, this.st.addSymbol(string), 0, 0, 0);
    }

    public int startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.numattrs == this.attrs.length) {
            Object[] objectArray = new Object[this.numattrs * 2];
            System.arraycopy(this.attrs, 0, objectArray, 0, this.numattrs);
            this.attrs = objectArray;
        }
        this.attrs[this.numattrs++] = new AttributesImpl(attributes);
        return this.events.add(5, this.st.addSymbol(string), this.st.addSymbol(string2), this.st.addSymbol(string3), this.numattrs - 1);
    }

    public int endElement(String string, String string2, String string3) {
        return this.events.add(6, this.st.addSymbol(string), this.st.addSymbol(string2), this.st.addSymbol(string3), 0);
    }

    public int characters(char[] cArray, int n, int n2) {
        return this.events.add(7, this.st.addSymbol(cArray, n, n2), 0, n2, 0);
    }

    public int ignorableWhitespace(char[] cArray, int n, int n2) {
        return this.events.add(8, this.st.addSymbol(cArray, n, n2), n, n2, 0);
    }

    public int processingInstruction(String string, String string2) {
        return this.events.add(9, this.st.addSymbol(string), this.st.addSymbol(string2), 0, 0);
    }

    public int skippedEntity(String string) {
        return this.events.add(10, this.st.addSymbol(string), 0, 0, 0);
    }

    public int newElement(MessageElement messageElement) {
        return this.events.add(11, this.addElement(messageElement), 0, 0, 0);
    }

    private int addElement(MessageElement messageElement) {
        this.elements.add(messageElement);
        return this.elements.size() - 1;
    }

    public void replay(ContentHandler contentHandler) throws SAXException {
        this.replay(0, this.events.getLength() - 1, contentHandler);
    }

    public void replay(int n, int n2, ContentHandler contentHandler) throws SAXException {
        if (n == 0 && n2 == -1) {
            this.replay(contentHandler);
            return;
        }
        if (n2 + 1 > this.events.getLength() || n2 < n) {
            return;
        }
        int n3 = n;
        while (n3 <= n2) {
            switch (this.events.get(n3, 0)) {
                case 0: {
                    contentHandler.setDocumentLocator(this.locator);
                    break;
                }
                case 1: {
                    contentHandler.startDocument();
                    break;
                }
                case 2: {
                    contentHandler.endDocument();
                    break;
                }
                case 3: {
                    contentHandler.startPrefixMapping(this.st.getSymbol(this.events.get(n3, 1)), this.st.getSymbol(this.events.get(n3, 2)));
                    break;
                }
                case 4: {
                    contentHandler.endPrefixMapping(this.st.getSymbol(this.events.get(n3, 1)));
                    break;
                }
                case 5: {
                    int n4 = this.events.get(n3, 4);
                    contentHandler.startElement(this.st.getSymbol(this.events.get(n3, 1)), this.st.getSymbol(this.events.get(n3, 2)), this.st.getSymbol(this.events.get(n3, 3)), (Attributes)this.attrs[this.events.get(n3, 4)]);
                    break;
                }
                case 6: {
                    contentHandler.endElement(this.st.getSymbol(this.events.get(n3, 1)), this.st.getSymbol(this.events.get(n3, 2)), this.st.getSymbol(this.events.get(n3, 3)));
                    break;
                }
                case 7: {
                    contentHandler.characters(this.st.getSymbol(this.events.get(n3, 1)).toCharArray(), this.events.get(n3, 2), this.events.get(n3, 3));
                    break;
                }
                case 8: {
                    contentHandler.characters(this.st.getSymbol(this.events.get(n3, 1)).toCharArray(), this.events.get(n3, 2), this.events.get(n3, 3));
                    break;
                }
                case 9: {
                    contentHandler.processingInstruction(this.st.getSymbol(this.events.get(n3, 1)), this.st.getSymbol(this.events.get(n3, 2)));
                    break;
                }
                case 10: {
                    contentHandler.skippedEntity(this.st.getSymbol(this.events.get(n3, 1)));
                    break;
                }
                case 11: {
                    if (!(contentHandler instanceof DeserializationContext)) break;
                    DeserializationContext deserializationContext = (DeserializationContext)((Object)contentHandler);
                    deserializationContext.setCurElement((MessageElement)this.elements.get(this.events.get(n3, 1)));
                }
            }
            ++n3;
        }
    }

    class intArrayVector {
        private int RECORD_SIZE = 5;
        private int currentSize = 0;
        private int[] intarray = new int[50 * this.RECORD_SIZE];

        intArrayVector() {
        }

        public int add(int n, int n2, int n3, int n4, int n5) {
            if (this.currentSize == this.intarray.length) {
                int[] nArray = new int[this.currentSize * 2];
                System.arraycopy(this.intarray, 0, nArray, 0, this.currentSize);
                this.intarray = nArray;
            }
            int n6 = this.currentSize / this.RECORD_SIZE;
            this.intarray[this.currentSize++] = n;
            this.intarray[this.currentSize++] = n2;
            this.intarray[this.currentSize++] = n3;
            this.intarray[this.currentSize++] = n4;
            this.intarray[this.currentSize++] = n5;
            return n6;
        }

        public int[] get(int n) {
            int[] nArray = new int[]{this.intarray[n * 5], this.intarray[n * 5 + 1], this.intarray[n * 5 + 2], this.intarray[n * 5 + 3], this.intarray[n * 5 + 4]};
            return nArray;
        }

        public int get(int n, int n2) {
            return this.intarray[n * this.RECORD_SIZE + n2];
        }

        public int getLength() {
            return this.currentSize / this.RECORD_SIZE;
        }
    }
}

