/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.lang.reflect.Method;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.RPCHandler;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.axis.utils.cache.JavaClass;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RPCElement
extends SOAPBodyElement {
    protected Vector params = new Vector();
    protected boolean needDeser = false;
    protected boolean elementIsFirstParam = false;
    protected Class[] defaultParamTypes = null;

    public RPCElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) {
        super(string, string2, string3, attributes, deserializationContext);
        QName qName;
        String string4;
        this.encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        this.needDeser = true;
        SOAPService sOAPService = deserializationContext.getMessageContext().getService();
        if (sOAPService != null && sOAPService.getStyle() == 1 && (string4 = sOAPService.getMethodForElementName(qName = new QName(string, string2))) != null) {
            this.name = string4;
            this.elementIsFirstParam = true;
        }
    }

    public RPCElement(String string, String string2, Object[] objectArray) {
        this.setNamespaceURI(string);
        this.name = string2;
        this.encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        int n = 0;
        while (objectArray != null && n < objectArray.length) {
            if (objectArray[n] instanceof RPCParam) {
                this.addParam((RPCParam)objectArray[n]);
            } else {
                String string3 = null;
                if (string3 == null) {
                    string3 = "arg" + n;
                }
                this.addParam(new RPCParam(string3, objectArray[n]));
            }
            ++n;
        }
    }

    public RPCElement(String string) {
        this.encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        this.name = string;
    }

    public String getMethodName() {
        return this.name;
    }

    public Class[] getJavaParamTypes() {
        return this.defaultParamTypes;
    }

    public void deserialize() throws SAXException {
        this.needDeser = false;
        MessageContext messageContext = this.context.getMessageContext();
        SOAPService sOAPService = messageContext.getService();
        String string = null;
        if (sOAPService != null) {
            string = (String)sOAPService.getOption("className");
        }
        if (string != null) {
            int n;
            ClassLoader classLoader = messageContext.getClassLoader();
            ClassCache classCache = messageContext.getAxisEngine().getClassCache();
            JavaClass javaClass = null;
            try {
                javaClass = classCache.lookup(string, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SAXException(classNotFoundException);
            }
            if (MessageElement.log.isDebugEnabled()) {
                MessageElement.log.debug((Object)JavaUtils.getMessage("lookup00", this.name, string));
            }
            Method[] methodArray = javaClass.getMethod(this.name);
            int n2 = n = this.getChildren() == null ? 0 : this.getChildren().size();
            if (methodArray != null) {
                int n3 = 0;
                while (n3 < methodArray.length) {
                    block12: {
                        this.defaultParamTypes = methodArray[n3].getParameterTypes();
                        if (this.defaultParamTypes.length >= n) {
                            try {
                                if (this.elementIsFirstParam) {
                                    this.context.pushElementHandler(new RPCHandler(this));
                                    this.context.setCurElement(null);
                                } else {
                                    this.context.pushElementHandler(new EnvelopeHandler(new RPCHandler(this)));
                                    this.context.setCurElement(this);
                                }
                                this.publishToHandler((ContentHandler)((Object)this.context));
                            }
                            catch (SAXException sAXException) {
                                this.params = new Vector();
                                break block12;
                            }
                            return;
                        }
                    }
                    ++n3;
                }
            }
        }
        this.context.pushElementHandler(new EnvelopeHandler(new RPCHandler(this)));
        this.context.setCurElement(this);
        this.publishToHandler((ContentHandler)((Object)this.context));
    }

    public RPCParam getParam(String string) throws SAXException {
        if (this.needDeser) {
            this.deserialize();
        }
        int n = 0;
        while (n < this.params.size()) {
            RPCParam rPCParam = (RPCParam)this.params.elementAt(n);
            if (rPCParam.getName().equals(string)) {
                return rPCParam;
            }
            ++n;
        }
        return null;
    }

    public Vector getParams() throws SAXException {
        if (this.needDeser) {
            this.deserialize();
        }
        return this.params;
    }

    public void addParam(RPCParam rPCParam) {
        rPCParam.setRPCCall(this);
        this.params.addElement(rPCParam);
    }

    protected void outputImpl(SerializationContext serializationContext) throws Exception {
        if (this.encodingStyle.equals("")) {
            serializationContext.registerPrefixForURI("", this.getNamespaceURI());
        }
        MessageContext messageContext = serializationContext.getMessageContext();
        boolean bl = true;
        if (messageContext != null && messageContext.getOperationStyle() != 0 && !messageContext.isPropertyTrue("wrapped")) {
            bl = false;
        }
        if (bl) {
            serializationContext.startElement(new QName(this.namespaceURI, this.name), this.attributes);
        }
        int n = 0;
        while (n < this.params.size()) {
            ((RPCParam)this.params.elementAt(n)).serialize(serializationContext);
            ++n;
        }
        if (bl) {
            serializationContext.endElement();
        }
    }
}

