/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import javax.xml.rpc.namespace.QName;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.message.BodyBuilder;
import org.apache.axis.message.HeaderBuilder;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.JavaUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EnvelopeBuilder
extends SOAPHandler {
    private MessageElement element;
    private SOAPEnvelope envelope;
    private boolean gotHeader = false;
    private boolean gotBody = false;
    private static final QName headerQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header");
    private static final QName bodyQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body");

    public EnvelopeBuilder(String string) {
        this.envelope = new SOAPEnvelope(false);
        this.envelope.setMessageType(string);
        this.myElement = this.envelope;
    }

    public EnvelopeBuilder(SOAPEnvelope sOAPEnvelope, String string) {
        this.envelope = sOAPEnvelope;
        this.envelope.setMessageType(string);
        this.myElement = this.envelope;
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        if (!string.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            throw new SAXException(JavaUtils.getMessage("badNamespace00", string));
        }
        if (!string2.equals("Envelope")) {
            throw new SAXException(JavaUtils.getMessage("badTag00", string2));
        }
        String string4 = "";
        int n = string3.indexOf(":");
        if (n > 0) {
            string4 = string3.substring(0, n);
        }
        this.envelope.setPrefix(string4);
        this.envelope.setNamespaceURI(string);
        this.envelope.setNSMappings(deserializationContext.getCurrentNSMappings());
        deserializationContext.pushNewElement(this.envelope);
    }

    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        QName qName = new QName(string, string2);
        if (qName.equals(headerQName)) {
            if (this.gotHeader) {
                throw new SAXException(JavaUtils.getMessage("only1Header00"));
            }
            this.gotHeader = true;
            return new HeaderBuilder(this.envelope);
        }
        if (qName.equals(bodyQName)) {
            if (this.gotBody) {
                throw new SAXException(JavaUtils.getMessage("only1Body00"));
            }
            this.gotBody = true;
            return new BodyBuilder(this.envelope);
        }
        if (!this.gotBody) {
            throw new SAXException(JavaUtils.getMessage("noCustomElems00"));
        }
        return null;
    }

    public void onEndChild(String string, String string2, DeserializationContext deserializationContext) {
        if (this.element != null) {
            this.envelope.addTrailer(this.element);
        }
    }

    public void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        this.envelope.setDirty(false);
    }
}

