/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.session.SimpleSession;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleSessionHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$handlers$SimpleSessionHandler == null ? (class$org$apache$axis$handlers$SimpleSessionHandler = SimpleSessionHandler.class$("org.apache.axis.handlers.SimpleSessionHandler")) : class$org$apache$axis$handlers$SimpleSessionHandler).getName());
    public static final String SESSION_ID = "SimpleSession.id";
    public static final String SESSION_NS = "http://xml.apache.org/axis/session";
    public static final String SESSION_LOCALPART = "sessionID";
    public static final QName sessionHeaderName = new QName("http://xml.apache.org/axis/session", "sessionID");
    private Hashtable activeSessions = new Hashtable();
    private long curSessionID = 0L;
    private long reapPeriodicity = 30000L;
    private long lastReapTime = 0L;
    private int defaultSessionTimeout = 60;
    static /* synthetic */ Class class$org$apache$axis$handlers$SimpleSessionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext messageContext) throws AxisFault {
        long l = System.currentTimeMillis();
        boolean bl = false;
        SimpleSessionHandler simpleSessionHandler = this;
        synchronized (simpleSessionHandler) {
            if (l > this.lastReapTime + this.reapPeriodicity) {
                bl = true;
                this.lastReapTime = l;
            }
        }
        if (bl) {
            Set set = this.activeSessions.keySet();
            HashSet hashSet = new HashSet();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                SimpleSession simpleSession = (SimpleSession)this.activeSessions.get(k);
                if ((long)(simpleSession.getTimeout() * 1000) <= l - simpleSession.getLastAccessTime()) continue;
                log.debug((Object)JavaUtils.getMessage("timeout00", k.toString()));
                hashSet.add(k);
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.activeSessions.remove(iterator.next());
            }
        }
        if (messageContext.isClient()) {
            this.doClient(messageContext);
        } else {
            this.doServer(messageContext);
        }
    }

    public void doClient(MessageContext messageContext) throws AxisFault {
        if (messageContext.getPastPivot()) {
            Message message = messageContext.getResponseMessage();
            if (message == null) {
                return;
            }
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeaderByName(SESSION_NS, SESSION_LOCALPART);
            if (sOAPHeader == null) {
                return;
            }
            try {
                Long l = (Long)sOAPHeader.getValueAsType(Constants.XSD_LONG);
                AxisEngine axisEngine = messageContext.getAxisEngine();
                axisEngine.setOption(SESSION_ID, l);
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
        } else {
            AxisEngine axisEngine = messageContext.getAxisEngine();
            Long l = (Long)axisEngine.getOption(SESSION_ID);
            if (l == null) {
                return;
            }
            Message message = messageContext.getRequestMessage();
            if (message == null) {
                throw new AxisFault(JavaUtils.getMessage("noRequest00"));
            }
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPHeader sOAPHeader = new SOAPHeader(SESSION_NS, SESSION_LOCALPART, l);
            sOAPEnvelope.addHeader(sOAPHeader);
        }
    }

    public void doServer(MessageContext messageContext) throws AxisFault {
        if (messageContext.getPastPivot()) {
            Long l = (Long)messageContext.getProperty(SESSION_ID);
            if (l == null) {
                return;
            }
            Message message = messageContext.getResponseMessage();
            if (message == null) {
                return;
            }
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPHeader sOAPHeader = new SOAPHeader(SESSION_NS, SESSION_LOCALPART, l);
            sOAPEnvelope.addHeader(sOAPHeader);
        } else {
            Long l;
            Message message = messageContext.getRequestMessage();
            if (message == null) {
                throw new AxisFault(JavaUtils.getMessage("noRequest00"));
            }
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeaderByName(SESSION_NS, SESSION_LOCALPART);
            if (sOAPHeader != null) {
                try {
                    l = (Long)sOAPHeader.getValueAsType(Constants.XSD_LONG);
                }
                catch (Exception exception) {
                    throw AxisFault.makeFault(exception);
                }
            } else {
                l = this.getNewSession();
            }
            SimpleSession simpleSession = (SimpleSession)this.activeSessions.get(l);
            if (simpleSession == null) {
                l = this.getNewSession();
                simpleSession = (SimpleSession)this.activeSessions.get(l);
            }
            simpleSession.touch();
            messageContext.setSession(simpleSession);
            messageContext.setProperty(SESSION_ID, l);
        }
    }

    private synchronized Long getNewSession() {
        Long l = new Long(this.curSessionID++);
        SimpleSession simpleSession = new SimpleSession();
        simpleSession.setTimeout(this.defaultSessionTimeout);
        this.activeSessions.put(l, simpleSession);
        return l;
    }

    public void setReapPeriodicity(long l) {
        this.reapPeriodicity = l;
    }

    public void setDefaultSessionTimeout(int n) {
        this.defaultSessionTimeout = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

