/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.wsdl.fromJava.Types;
import org.xml.sax.Attributes;

public class DateSerializer
implements Serializer {
    private static SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static Calendar calendar = new GregorianCalendar();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        String string;
        serializationContext.startElement(qName, attributes);
        Calendar calendar = DateSerializer.calendar;
        synchronized (calendar) {
            DateSerializer.calendar.setTime((Date)object);
            if (DateSerializer.calendar.get(0) == 0) {
                serializationContext.writeString("-");
                DateSerializer.calendar.setTime((Date)object);
                DateSerializer.calendar.set(0, 1);
                object = DateSerializer.calendar.getTime();
            }
            string = zulu.format((Date)object);
        }
        serializationContext.writeString(string);
        serializationContext.endElement();
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public boolean writeSchema(Types types) throws Exception {
        return false;
    }

    static {
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

