/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.InternalException;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.ser.BeanPropertyDescriptor;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.fromJava.ClassRep;
import org.apache.axis.wsdl.fromJava.FieldRep;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class BeanSerializer
implements Serializer,
Serializable {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$encoding$ser$BeanSerializer == null ? (class$org$apache$axis$encoding$ser$BeanSerializer = BeanSerializer.class$("org.apache.axis.encoding.ser.BeanSerializer")) : class$org$apache$axis$encoding$ser$BeanSerializer).getName());
    private static final Object[] noArgs = new Object[0];
    private short elementPropertyFormat = PROPERTY_NAME;
    public static short PROPERTY_NAME = 0;
    public static short FORCE_UPPER = 1;
    public static short FORCE_LOWER = (short)2;
    QName xmlType;
    Class javaType;
    private BeanPropertyDescriptor[] propertyDescriptor = null;
    private Vector beanAttributeNames = null;
    static /* synthetic */ Class class$org$apache$axis$encoding$ser$BeanSerializer;
    static /* synthetic */ Class class$java$lang$Object;

    public BeanSerializer(Class clazz, QName qName) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.propertyDescriptor = BeanSerializer.getPd(clazz);
        this.beanAttributeNames = BeanSerializer.getBeanAttributes(clazz);
    }

    public BeanSerializer(Class clazz, QName qName, short s) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.setElementPropertyFormat(s);
        this.propertyDescriptor = BeanSerializer.getPd(clazz);
        this.beanAttributeNames = BeanSerializer.getBeanAttributes(clazz);
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        boolean bl = Constants.isSOAP_ENC(serializationContext.getMessageContext().getEncodingStyle());
        Attributes attributes2 = this.getObjectAttributes(object, attributes);
        serializationContext.startElement(qName, attributes2);
        try {
            int n = 0;
            while (n < this.propertyDescriptor.length) {
                String string = this.propertyDescriptor[n].getName();
                if (!string.equals("class") && !this.beanAttributeNames.contains(Utils.xmlNameToJava(string))) {
                    string = BeanSerializer.format(string, this.elementPropertyFormat);
                    Method method = this.propertyDescriptor[n].getReadMethod();
                    if (method != null && method.getParameterTypes().length == 0) {
                        Object object2 = this.propertyDescriptor[n].getReadMethod().invoke(object, noArgs);
                        serializationContext.serialize(new QName("", string), null, object2, this.propertyDescriptor[n].getReadMethod().getReturnType());
                    } else {
                        int n2 = 0;
                        while (n2 >= 0) {
                            Object object3 = null;
                            try {
                                object3 = this.propertyDescriptor[n].getReadMethod().invoke(object, new Integer(n2));
                                ++n2;
                            }
                            catch (Exception exception) {
                                n2 = -1;
                            }
                            if (n2 < 0) continue;
                            serializationContext.serialize(new QName("", string), null, object3, this.propertyDescriptor[n].getReadMethod().getReturnType());
                        }
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exception);
            throw new IOException(exception.toString());
        }
        serializationContext.endElement();
    }

    static BeanPropertyDescriptor[] getPd(Class clazz) {
        BeanPropertyDescriptor[] beanPropertyDescriptorArray;
        try {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            beanPropertyDescriptorArray = BeanPropertyDescriptor.processPropertyDescriptors(propertyDescriptorArray, clazz);
        }
        catch (Exception exception) {
            throw new InternalException(exception);
        }
        return beanPropertyDescriptorArray;
    }

    static Vector getBeanAttributes(Class clazz) {
        try {
            Method method = clazz.getMethod("getAttributeElements", new Class[0]);
            String[] stringArray = (String[])method.invoke(null, noArgs);
            Vector<String> vector = new Vector<String>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                vector.add(stringArray[n]);
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            return new Vector();
        }
    }

    public short getElementPropertyFormat() {
        return this.elementPropertyFormat;
    }

    public void setElementPropertyFormat(short s) {
        if (s > FORCE_LOWER || s < PROPERTY_NAME) {
            s = PROPERTY_NAME;
        }
        this.elementPropertyFormat = s;
    }

    static String format(String string, short s) {
        if (s == PROPERTY_NAME) {
            return string;
        }
        String string2 = "";
        if (string.length() > 1) {
            string2 = string.substring(1);
        }
        if (s == FORCE_UPPER) {
            return Character.toUpperCase(string.charAt(0)) + string2;
        }
        return Character.toLowerCase(string.charAt(0)) + string2;
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public boolean writeSchema(Types types) throws Exception {
        Object object;
        Object object2;
        Object object3;
        javax.wsdl.QName qName = types.getWsdlQName(this.xmlType);
        Element element = types.createElement("complexType");
        types.writeSchemaElement(qName, element);
        element.setAttribute("name", qName.getLocalPart());
        Object object4 = null;
        Class clazz = this.javaType.getSuperclass();
        Vector vector = types.getStopClasses();
        if (!(clazz == null || clazz == (class$java$lang$Object == null ? (class$java$lang$Object = BeanSerializer.class$("java.lang.Object")) : class$java$lang$Object) || vector != null && vector.contains(clazz.getName()))) {
            object3 = types.writeType(clazz);
            object2 = types.createElement("complexContent");
            element.appendChild((Node)object2);
            object = types.createElement("extension");
            object2.appendChild((Node)object);
            object.setAttribute("base", (String)object3);
            object4 = object;
        } else {
            object4 = element;
        }
        object3 = types.createElement("all");
        object4.appendChild((Node)object3);
        object2 = types.getBeanBuilder().build(this.javaType);
        object = ((ClassRep)object2).getFields();
        int n = 0;
        while (n < ((Vector)object).size()) {
            FieldRep fieldRep = (FieldRep)((Vector)object).elementAt(n);
            if (this.beanAttributeNames.contains(fieldRep.getName())) {
                this.writeAttribute(types, fieldRep.getName(), fieldRep.getType(), element);
            } else {
                this.writeField(types, fieldRep.getName(), fieldRep.getType(), fieldRep.getIndexed(), (Element)object3);
            }
            ++n;
        }
        return true;
    }

    private void writeField(Types types, String string, Class clazz, boolean bl, Element element) throws Exception {
        String string2 = types.writeType(clazz);
        Element element2 = types.createElement(string, string2, types.isNullable(clazz), element.getOwnerDocument());
        if (bl) {
            element2.setAttribute("maxOccurs", "unbounded");
        }
        element.appendChild(element2);
    }

    private void writeAttribute(Types types, String string, Class clazz, Element element) throws Exception {
        if (!types.isSimpleSchemaType(clazz)) {
            throw new AxisFault(JavaUtils.getMessage("AttrNotSimpleType00", string, clazz.getName()));
        }
        String string2 = types.writeType(clazz);
        Element element2 = types.createAttributeElement(string, string2, false, element.getOwnerDocument());
        element.appendChild(element2);
    }

    private Attributes getObjectAttributes(Object object, Attributes attributes) {
        if (this.beanAttributeNames.isEmpty()) {
            return attributes;
        }
        AttributesImpl attributesImpl = attributes != null ? new AttributesImpl(attributes) : new AttributesImpl();
        try {
            int n = 0;
            while (n < this.propertyDescriptor.length) {
                String string = this.propertyDescriptor[n].getName();
                if (!string.equals("class") && this.beanAttributeNames.contains(Utils.xmlNameToJava(string))) {
                    string = BeanSerializer.format(string, this.elementPropertyFormat);
                    Method method = this.propertyDescriptor[n].getReadMethod();
                    if (method != null && method.getParameterTypes().length == 0) {
                        Object object2 = this.propertyDescriptor[n].getReadMethod().invoke(object, noArgs);
                        String string2 = object2 != null ? object2.toString() : "";
                        attributesImpl.addAttribute("", string, string, "CDATA", string2);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return attributesImpl;
        }
        return attributesImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

