/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.io.ByteArrayOutputStream;
import org.apache.axis.utils.JavaUtils;

public class Hex {
    byte[] m_value = null;
    public static final String ERROR_ODD_NUMBER_OF_DIGITS = JavaUtils.getMessage("oddDigits00");
    public static final String ERROR_BAD_CHARACTER_IN_HEX_STRING = JavaUtils.getMessage("badChars01");
    public static final int[] DEC = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public Hex() {
    }

    public Hex(String string) {
        this.m_value = Hex.decode(string);
    }

    public Hex(byte[] byArray) {
        this.m_value = byArray;
    }

    public byte[] getBytes() {
        return this.m_value;
    }

    public String toString() {
        return Hex.encode(this.m_value);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        String string = object.toString();
        String string2 = this.toString();
        return string.equals(string2);
    }

    public static byte[] decode(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (n + 1 >= string.length()) {
                throw new IllegalArgumentException(ERROR_ODD_NUMBER_OF_DIGITS);
            }
            char c2 = string.charAt(n + 1);
            int n2 = 0;
            if (c >= '0' && c <= '9') {
                n2 = (byte)(n2 + (c - 48) * 16);
            } else if (c >= 'a' && c <= 'f') {
                n2 = (byte)(n2 + (c - 97 + 10) * 16);
            } else if (c >= 'A' && c <= 'F') {
                n2 = (byte)(n2 + (c - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException(ERROR_BAD_CHARACTER_IN_HEX_STRING);
            }
            if (c2 >= '0' && c2 <= '9') {
                n2 = (byte)(n2 + (c2 - 48));
            } else if (c2 >= 'a' && c2 <= 'f') {
                n2 = (byte)(n2 + (c2 - 97 + 10));
            } else if (c2 >= 'A' && c2 <= 'F') {
                n2 = (byte)(n2 + (c2 - 65 + 10));
            } else {
                throw new IllegalArgumentException(ERROR_BAD_CHARACTER_IN_HEX_STRING);
            }
            byteArrayOutputStream.write(n2);
            n += 2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Hex.convertDigit(byArray[n] >> 4));
            stringBuffer.append(Hex.convertDigit(byArray[n] & 0xF));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static int convert2Int(byte[] byArray) {
        if (byArray.length < 4) {
            return 0;
        }
        if (DEC[byArray[0]] < 0) {
            throw new IllegalArgumentException(ERROR_BAD_CHARACTER_IN_HEX_STRING);
        }
        int n = DEC[byArray[0]];
        n <<= 4;
        if (DEC[byArray[1]] < 0) {
            throw new IllegalArgumentException(ERROR_BAD_CHARACTER_IN_HEX_STRING);
        }
        n += DEC[byArray[1]];
        n <<= 4;
        if (DEC[byArray[2]] < 0) {
            throw new IllegalArgumentException(ERROR_BAD_CHARACTER_IN_HEX_STRING);
        }
        n += DEC[byArray[2]];
        n <<= 4;
        if (DEC[byArray[3]] < 0) {
            throw new IllegalArgumentException(ERROR_BAD_CHARACTER_IN_HEX_STRING);
        }
        return n += DEC[byArray[3]];
    }

    private static char convertDigit(int n) {
        if ((n &= 0xF) >= 10) {
            return (char)(n - 10 + 97);
        }
        return (char)(n + 48);
    }
}

